/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.ui.internal.Trace;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;

public class TogglePublishAction
implements IViewActionDelegate,
IActionDelegate2,
ISelectionChangedListener {
    private static final String LAST_AUTO_PUBLISH = "last-auto-publish";
    protected IViewPart view;
    protected IAction action;
    protected IServer server;

    public void init(IViewPart view) {
        this.view = view;
        view.getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run(IAction action2) {
        block7: {
            if (this.server == null) {
                return;
            }
            try {
                IServerWorkingCopy wc = this.server.createWorkingCopy();
                ServerWorkingCopy wc2 = (ServerWorkingCopy)wc;
                int current = wc2.getAutoPublishSetting();
                if (current == 1) {
                    int last = wc2.getAttribute(LAST_AUTO_PUBLISH, 0);
                    if (last > 1) {
                        wc2.setAutoPublishSetting(last);
                    } else {
                        wc2.setAutoPublishSetting(2);
                    }
                } else {
                    wc2.setAttribute(LAST_AUTO_PUBLISH, current);
                    wc2.setAutoPublishSetting(1);
                }
                wc2.save(false, null);
            }
            catch (CoreException ce) {
                if (!Trace.ENABLED) break block7;
                Trace.trace((byte)1, "Could not modify auto-publish setting", ce);
            }
        }
    }

    public void selectionChanged(IAction action2, ISelection selection) {
        this.server = null;
        boolean enabled = true;
        boolean state = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Iterator iter = sel.iterator();
            if (!iter.hasNext()) {
                enabled = false;
            } else {
                Object obj = iter.next();
                if (iter.hasNext()) {
                    enabled = false;
                } else if (obj instanceof IServer) {
                    this.server = (IServer)obj;
                    state = ((Server)this.server).getAutoPublishSetting() == 1;
                } else {
                    enabled = false;
                }
            }
        } else {
            enabled = false;
        }
        this.action.setChecked(state);
        this.action.setEnabled(enabled);
    }

    public void dispose() {
        this.view.getViewSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void init(IAction action2) {
        this.action = action2;
        this.action.setChecked(true);
    }

    public void runWithEvent(IAction action2, Event event) {
        this.run(action2);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(this.action, event.getSelection());
    }
}

