/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;

public class ServerDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object obj, IDecoration decoration) {
        IFile file;
        ImageDescriptor id;
        if (obj instanceof IServer) {
            IServer server = (IServer)obj;
            if (server.getServerType() == null || !server.getServerType().getId().startsWith("com.ibm.ws.st.server")) {
                return;
            }
            WebSphereServer serverDelegate = (WebSphereServer)server.loadAdapter(WebSphereServer.class, (IProgressMonitor)new NullProgressMonitor());
            if (serverDelegate != null) {
                String[] errors;
                String name = serverDelegate.getServerDisplayName();
                if (name != null && !name.isEmpty()) {
                    decoration.addSuffix(" [" + name + "]");
                }
                if (serverDelegate.isLocalSetup() && serverDelegate.getServerInfo() != null && (errors = serverDelegate.getServerInfo().getServerErrors()).length > 0) {
                    ImageDescriptor id2 = Activator.getImageDescriptor("errorOverlay");
                    decoration.addOverlay(id2, 2);
                    decoration.addSuffix(" " + NLS.bind((String)Messages.serverDecoratorErrors, (Object)Integer.toString(errors.length)));
                }
            }
        } else if (obj instanceof IFile && (id = Activator.getImageDescriptor((file = (IFile)obj).getName())) != null) {
            decoration.addOverlay(id);
        }
    }
}

