/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimeExplorer {

    public static class Node {
        private final NodeType type;
        private final UserDirectory userDir;

        public Node(UserDirectory userDir, NodeType type) {
            this.userDir = userDir;
            this.type = type;
        }

        public NodeType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Node)) {
                return false;
            }
            Node n = (Node)o;
            return n.userDir.equals((Object)this.userDir) && n.type.equals((Object)this.type);
        }

        public int hashCode() {
            int hash = this.type.hashCode();
            if (this.userDir != null) {
                hash += this.userDir.hashCode();
            }
            return hash;
        }

        public Object getParent() {
            return this.userDir;
        }

        public UserDirectory getUserDirectory() {
            return this.userDir;
        }

        public IRuntime getRuntime() {
            return this.userDir.getWebSphereRuntime().getRuntime();
        }

        public WebSphereRuntime getWebSphereRuntime() {
            return this.userDir.getWebSphereRuntime();
        }

        public String getName() {
            if (this.type == NodeType.SERVERS) {
                return Messages.runtimeServers;
            }
            if (this.type == NodeType.SHARED_CONFIGURATIONS) {
                return Messages.runtimeSharedConfigurations;
            }
            return Messages.runtimeSharedApplications;
        }

        public Object[] getChildren() {
            if (this.type == NodeType.SERVERS) {
                WebSphereRuntime wr = this.userDir.getWebSphereRuntime();
                return wr.getWebSphereServerInfos(this.userDir).toArray();
            }
            if (this.type == NodeType.SHARED_CONFIGURATIONS) {
                return this.userDir.getSharedConfiguration();
            }
            return null;
        }
    }

    public static enum NodeType {
        SERVERS,
        SHARED_CONFIGURATIONS,
        SHARED_APPLICATIONS;

    }
}

