/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.ws.kernel.feature.internal.util.ImageInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Images {
    private final Map<String, ImageInfo> images;
    public Map<String, Map<String, ImageInfo>> cohorts;

    public Images() {
        this.images = new HashMap<String, ImageInfo>();
        this.cohorts = new HashMap<String, Map<String, ImageInfo>>();
    }

    public Images(int capacity) {
        this.images = new HashMap<String, ImageInfo>(capacity);
        this.cohorts = new HashMap<String, Map<String, ImageInfo>>();
    }

    protected void put(ImageInfo image) {
        String name = image.getName();
        String cohortName = image.getBaseName();
        String version = image.getVersion();
        this.images.put(name, image);
        Map<String, ImageInfo> cohort = this.cohorts.get(cohortName);
        if (cohort == null) {
            cohort = new HashMap<String, ImageInfo>();
            this.cohorts.put(cohortName, cohort);
        }
        cohort.put(version, image);
    }

    public Map<String, ImageInfo> getImages() {
        return this.images;
    }

    public ImageInfo getImage(String name) {
        return this.images.get(name);
    }

    public Map<String, Map<String, ImageInfo>> getCohorts() {
        return this.cohorts;
    }

    public Set<String> getCohortNames() {
        return this.cohorts.keySet();
    }

    public Map<String, ImageInfo> getCohort(String baseName) {
        return this.cohorts.get(baseName);
    }

    public ImageInfo getImage(String baseName, String version) {
        Map<String, ImageInfo> cohort = this.getCohort(baseName);
        return cohort == null ? null : cohort.get(version);
    }
}

