/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.ui.internal;

import com.ibm.ws.st.core.internal.APIVisibility;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.jee.core.internal.SharedLibRefInfo;
import com.ibm.ws.st.jee.core.internal.SharedLibertyUtils;
import com.ibm.ws.st.jee.ui.internal.Activator;
import com.ibm.ws.st.jee.ui.internal.Messages;
import com.ibm.ws.st.jee.ui.internal.SWTUtil;
import com.ibm.ws.st.jee.ui.internal.SharedLibSelectionDialog;
import com.ibm.ws.st.jee.ui.internal.Trace;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;

public class SharedLibPropertiesPage
extends PropertyPage {
    protected IProject project;
    protected SharedLibRefInfo settings = new SharedLibRefInfo();
    protected List<ConfigurationFile.LibRef> libRefs;
    protected List<ConfigurationFile.LibRef> defaultLibRefs;
    protected Table libTable;
    protected Button apiVisibilityCheckboxAPI;
    protected Button apiVisibilityCheckboxIBMAPI;
    protected Button apiVisibilityCheckboxSpec;
    protected Button apiVisibilityCheckboxStable;
    protected Button apiVisibilityCheckboxThirdParty;
    EnumSet<APIVisibility> apiVisibility;

    protected Control createContents(Composite parent) {
        this.loadSettings();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        label.setText(Messages.sharedLibReferences);
        data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.libTable = new Table(composite, 68354);
        data = new GridData(4, 4, true, false);
        data.heightHint = 100;
        data.verticalSpan = 2;
        this.libTable.setLayoutData((Object)data);
        TableColumn idColumn = new TableColumn(this.libTable, 0);
        idColumn.setText(Messages.sharedLibIdColumn);
        idColumn.setResizable(true);
        TableColumn typeColumn = new TableColumn(this.libTable, 0);
        typeColumn.setText(Messages.sharedLibTypeColumn);
        typeColumn.setResizable(true);
        this.libTable.setHeaderVisible(true);
        this.resetTable();
        this.resizeColumns(this.libTable);
        Button add = SWTUtil.createButton(composite, Messages.add);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SharedLibSelectionDialog dialog = new SharedLibSelectionDialog(SharedLibPropertiesPage.this.getShell(), SharedLibPropertiesPage.this.libRefs);
                if (dialog.open() == 0) {
                    String id = dialog.getId();
                    boolean isPrivate = dialog.getIsPrivate();
                    ConfigurationFile.LibRef ref = new ConfigurationFile.LibRef(id, isPrivate ? ConfigurationFile.LibraryRefType.PRIVATE : ConfigurationFile.LibraryRefType.COMMON);
                    SharedLibPropertiesPage.this.libRefs.add(ref);
                    TableItem item = new TableItem(SharedLibPropertiesPage.this.libTable, 0);
                    item.setText(new String[]{ref.id, ref.type.getName()});
                    item.setData((Object)ref);
                    item.setImage(Activator.getImage("library"));
                }
            }
        });
        final Button remove = SWTUtil.createButton(composite, Messages.remove);
        remove.setEnabled(false);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int[] indices = SharedLibPropertiesPage.this.libTable.getSelectionIndices();
                if (indices == null || indices.length == 0) {
                    return;
                }
                for (int ind : indices) {
                    TableItem item = SharedLibPropertiesPage.this.libTable.getItem(ind);
                    SharedLibPropertiesPage.this.libRefs.remove(item.getData());
                }
                SharedLibPropertiesPage.this.libTable.remove(indices);
                remove.setEnabled(false);
            }
        });
        this.libTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int ind = SharedLibPropertiesPage.this.libTable.getSelectionIndex();
                remove.setEnabled(ind >= 0);
            }
        });
        Group group = new Group(composite, 16);
        group.setText(Messages.sharedLibAPIVisibilityLabel);
        data = new GridData(1, 4, true, false);
        data.horizontalSpan = 3;
        data.minimumWidth = 130;
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout());
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SharedLibPropertiesPage.this.setValid(SharedLibPropertiesPage.this.isValid());
            }
        };
        this.apiVisibilityCheckboxAPI = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxAPI.setText(Messages.sharedLibAPIVisibilityAPI);
        this.apiVisibilityCheckboxAPI.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxIBMAPI = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxIBMAPI.setText(Messages.sharedLibAPIVisibilityIBMAPI);
        this.apiVisibilityCheckboxIBMAPI.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxSpec = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxSpec.setText(Messages.sharedLibAPIVisibilitySpec);
        this.apiVisibilityCheckboxSpec.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxStable = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxStable.setText(Messages.sharedLibAPIVisibilityStable);
        this.apiVisibilityCheckboxStable.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxThirdParty = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxThirdParty.setText(Messages.sharedLibAPIVisibilityThirdParty);
        this.apiVisibilityCheckboxThirdParty.addSelectionListener((SelectionListener)selectionListener);
        this.updateAPIVisibilityCheckboxeValues(this.apiVisibility);
        return composite;
    }

    protected void loadSettings() {
        IAdaptable element = this.getElement();
        this.project = (IProject)element.getAdapter(IProject.class);
        if (this.project == null) {
            return;
        }
        this.settings = SharedLibertyUtils.getSharedLibRefInfo((IProject)this.project);
        this.libRefs = this.settings.getLibRefs();
        this.defaultLibRefs = new ArrayList<ConfigurationFile.LibRef>(this.libRefs);
        this.apiVisibility = APIVisibility.getAPIVisibilityFromProperties((Properties)this.settings);
    }

    protected void saveSettings() {
        if (this.project == null) {
            return;
        }
        IPath path = this.project.getLocation().append(".settings/com.ibm.ws.st.shared.library.ref");
        SharedLibertyUtils.saveSettings((Properties)this.settings, (IPath)path);
        IModule module = ServerUtil.getModule((IProject)this.project);
        if (module != null) {
            IServer[] servers;
            for (IServer server : servers = ServerUtil.getServersByModule((IModule)module, null)) {
                try {
                    WebSphereServerBehaviour serverB = (WebSphereServerBehaviour)server.loadAdapter(WebSphereServerBehaviour.class, null);
                    if (serverB != null) {
                        serverB.setModulePublishState(2, new IModule[]{module});
                    }
                    if (!(server instanceof Server)) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Expecting server " + server.getName() + " to be an instance of org.eclipse.wst.server.core.internal.Server");
                        continue;
                    }
                    Server s = (Server)server;
                    if (s.getAutoPublishSetting() == 1 || server.getServerState() != 2) continue;
                    server.publish(3, null, null, null);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Failed to update publish state for " + module.getName(), e);
                }
            }
        }
    }

    protected void resetTable() {
        this.libTable.select(-1);
        this.libTable.removeAll();
        for (ConfigurationFile.LibRef ref : this.libRefs) {
            TableItem item = new TableItem(this.libTable, 0);
            item.setText(new String[]{ref.id, ref.type.getName()});
            item.setData((Object)ref);
            item.setImage(Activator.getImage("library"));
        }
    }

    protected void resizeColumns(Table table) {
        int i;
        TableLayout tableLayout = new TableLayout();
        int numColumns = table.getColumnCount();
        for (i = 0; i < numColumns; ++i) {
            table.getColumn(i).pack();
        }
        for (i = 0; i < numColumns; ++i) {
            int w = Math.max(75, table.getColumn(i).getWidth());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(w, w, true));
        }
        table.setLayout((Layout)tableLayout);
    }

    public boolean isValid() {
        return this.apiVisibilityCheckboxAPI.getSelection() || this.apiVisibilityCheckboxIBMAPI.getSelection() || this.apiVisibilityCheckboxSpec.getSelection() || this.apiVisibilityCheckboxStable.getSelection() || this.apiVisibilityCheckboxThirdParty.getSelection();
    }

    public boolean performOk() {
        boolean sharedLibraryChanged;
        boolean apiVisibilityChanged = this.apiVisibilityChanged();
        boolean bl = sharedLibraryChanged = !this.libRefs.equals(this.defaultLibRefs);
        if (apiVisibilityChanged) {
            this.settings.setProperty("com.ibm.ws.st.core.api.visibility.api", Boolean.toString(this.apiVisibilityCheckboxAPI.getSelection()));
            this.settings.setProperty("com.ibm.ws.st.core.api.visibility.ibmapi", Boolean.toString(this.apiVisibilityCheckboxIBMAPI.getSelection()));
            this.settings.setProperty("com.ibm.ws.st.core.api.visibility.spec", Boolean.toString(this.apiVisibilityCheckboxSpec.getSelection()));
            this.settings.setProperty("com.ibm.ws.st.core.api.visibility.stable", Boolean.toString(this.apiVisibilityCheckboxStable.getSelection()));
            this.settings.setProperty("com.ibm.ws.st.core.api.visibility.thirdparty", Boolean.toString(this.apiVisibilityCheckboxThirdParty.getSelection()));
        }
        if (sharedLibraryChanged) {
            this.settings.setLibRefs(this.libRefs);
        }
        if (sharedLibraryChanged || apiVisibilityChanged) {
            this.saveSettings();
        }
        return true;
    }

    protected boolean apiVisibilityChanged() {
        return this.apiVisibilityCheckboxAPI.getSelection() != this.apiVisibility.contains(APIVisibility.API) || this.apiVisibilityCheckboxIBMAPI.getSelection() != this.apiVisibility.contains(APIVisibility.IBM_API) || this.apiVisibilityCheckboxSpec.getSelection() != this.apiVisibility.contains(APIVisibility.SPEC) || this.apiVisibilityCheckboxStable.getSelection() != this.apiVisibility.contains(APIVisibility.STABLE) || this.apiVisibilityCheckboxThirdParty.getSelection() != this.apiVisibility.contains(APIVisibility.THIRD_PARTY);
    }

    protected void updateAPIVisibilityCheckboxeValues(EnumSet<APIVisibility> apiVisibility) {
        this.apiVisibilityCheckboxAPI.setSelection(apiVisibility.contains(APIVisibility.API));
        this.apiVisibilityCheckboxIBMAPI.setSelection(apiVisibility.contains(APIVisibility.IBM_API));
        this.apiVisibilityCheckboxSpec.setSelection(apiVisibility.contains(APIVisibility.SPEC));
        this.apiVisibilityCheckboxStable.setSelection(apiVisibility.contains(APIVisibility.STABLE));
        this.apiVisibilityCheckboxThirdParty.setSelection(apiVisibility.contains(APIVisibility.THIRD_PARTY));
    }

    public void performDefaults() {
        this.libRefs = this.defaultLibRefs;
        this.defaultLibRefs = new ArrayList<ConfigurationFile.LibRef>(this.libRefs);
        this.resetTable();
        this.updateAPIVisibilityCheckboxeValues(APIVisibility.getDefaults());
    }
}

