/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.xml.internal;

import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class XMLDocumentBuilder {
    protected Document doc;

    public void createNewDocument(String rootElement) throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.doc.setXmlStandalone(true);
        Element element = this.doc.createElement(rootElement);
        this.doc.appendChild(element);
    }

    public void readDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setIgnoringComments(true);
        builderFactory.setCoalescing(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        builderFactory.setValidating(false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        this.doc = builder.parse(xmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXMLDocument(File f) throws IOException, TransformerException {
        if (this.doc == null) {
            Trace.logError("No file was provided to write", null);
            return;
        }
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        try (FileOutputStream outFile = new FileOutputStream(f);){
            DOMSource source = new DOMSource(this.doc);
            StreamResult result = new StreamResult(outFile);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("version", "1.0");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
    }
}

