/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.common.core.ext.internal.util.FileUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.docker.core.internal.AbstractFlattenImageHandler;
import com.ibm.ws.st.docker.core.internal.Activator;
import com.ibm.ws.st.docker.core.internal.Messages;
import com.ibm.ws.st.docker.core.internal.Trace;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.util.SocketUtil;

public class LibertyDockerRunUtility {
    public static String getLibertyUsrPath(Map<String, String> serviceInfo) {
        String defaultPath = "/opt/ibm/wlp/usr";
        if (serviceInfo == null) {
            Trace.logError("The service info map is null so using default Liberty Docker user directory.", null);
            return "/opt/ibm/wlp/usr";
        }
        String installDir = serviceInfo.get("LibertyRuntimeInstallPath");
        if (installDir != null && !installDir.isEmpty()) {
            return installDir + "/usr";
        }
        Trace.logError("The runtime install path is not set properly in the service info - using the default user directory", null);
        return "/opt/ibm/wlp/usr";
    }

    public static String getLibertyStdevPath(Map<String, String> serviceInfo) {
        String defaultPath = "/opt/ibm/wlp/stdev";
        if (serviceInfo == null) {
            Trace.logError("The service info map is null so using default Liberty Docker stdev directory.", null);
            return "/opt/ibm/wlp/stdev";
        }
        String installDir = serviceInfo.get("LibertyRuntimeInstallPath");
        if (installDir != null && !installDir.isEmpty()) {
            return installDir + "/stdev";
        }
        Trace.logError("The runtime install path is not set properly in the service info - using the default stdev directory", null);
        return "/opt/ibm/wlp/stdev";
    }

    public static List<String> getCreateCommand(BaseDockerContainer container, boolean looseCfgModeChanged, String newMode, String currentMode, String newContainerName, String imageName, WebSphereServer server) throws Exception {
        List<String> createCmd = LibertyDockerRunUtility.getRunCommand(container, looseCfgModeChanged, newMode, currentMode, newContainerName, imageName, server);
        createCmd.set(1, "create");
        Collections.replaceAll(createCmd, "-td", "-t");
        return createCmd;
    }

    public static List<String> getRunCommand(BaseDockerContainer container, boolean looseCfgModeChanged, String newMode, String currentMode, String newContainerName, String imageName, WebSphereServer server) throws Exception {
        if (server.isLooseConfigEnabled() && looseCfgModeChanged) {
            LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
            if (serverExt != null) {
                Map serviceInfo = server.getServiceInfo();
                String containerName = serverExt.getContainerName(server);
                serviceInfo.put("dockerContainer", containerName);
                IPath userFolder = server.getUserDirectory().getPath();
                LibertyDockerRunUtility.copyFromContainerToHost(userFolder, serviceInfo, container);
            }
            Map<IPath, IPath> volumes = LibertyDockerRunUtility.calculateVolumes(container, server, true);
            return LibertyDockerRunUtility.getRunCommand(container, newMode, currentMode, newContainerName, imageName, volumes, server);
        }
        Map<IPath, IPath> volumes = LibertyDockerRunUtility.calculateVolumes(container, server, looseCfgModeChanged);
        return LibertyDockerRunUtility.getRunCommand(container, newMode, currentMode, newContainerName, imageName, volumes, server);
    }

    public static List<String> getStartCommand(String containerName) {
        ArrayList<String> startCmd = new ArrayList<String>();
        startCmd.add("docker");
        startCmd.add("start");
        startCmd.add(containerName);
        return startCmd;
    }

    public static String getDebugPort(BaseDockerContainer container) throws Exception {
        List env = container.getEnv();
        String debugPort = "7777";
        for (String envDef : env) {
            String varStart;
            if (!envDef.startsWith(varStart = "WLP_DEBUG_ADDRESS=")) continue;
            String port = envDef.substring(varStart.length());
            try {
                int portNum = Integer.parseInt(port);
                if (portNum < 1 || portNum > 65535) continue;
                debugPort = port;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return debugPort;
    }

    public static String mergeStrings(List<String> strings) {
        boolean start = true;
        StringBuilder builder = new StringBuilder();
        for (String str : strings) {
            if (start) {
                start = false;
            } else {
                builder.append(" ");
            }
            builder.append(str);
        }
        return builder.toString();
    }

    private static List<String> getRunCommand(BaseDockerContainer container, String newMode, String currentMode, String containerName, String imageName, Map<IPath, IPath> volumes, WebSphereServer server) throws Exception {
        ArrayList<String> newCmd = new ArrayList<String>();
        List env = container.getEnv();
        Map portBindings = container.getPortBindings();
        List cmd = container.getCommand();
        boolean isLocal = SocketUtil.isLocalhost((String)server.getServer().getHost());
        newCmd.add("docker");
        newCmd.add("run");
        for (Object envDef : env) {
            if (((String)envDef).equals("WLP_DEBUG_REMOTE=y") && !"debug".equals(newMode)) continue;
            newCmd.add("-e");
            newCmd.add("\"" + (String)envDef + "\"");
        }
        if ("debug".equals(newMode)) {
            newCmd.add("-e WLP_DEBUG_REMOTE=y");
        }
        if (container.getPublishAllPorts() || "debug".equals(newMode) && isLocal) {
            newCmd.add("-P");
        }
        String debugPort = LibertyDockerRunUtility.getDebugPort(container);
        for (Map.Entry entry : portBindings.entrySet()) {
            if (((String)entry.getKey()).equals(debugPort)) continue;
            newCmd.add("-p");
            newCmd.add((String)entry.getValue() + ":" + (String)entry.getKey());
        }
        if ("debug".equals(newMode)) {
            if (isLocal) {
                newCmd.add("--expose");
                newCmd.add(debugPort);
            } else {
                String mappedPort = server.getRemoteServerStartDebugPort();
                newCmd.add("-p");
                newCmd.add(mappedPort + ":" + debugPort);
            }
        }
        List<String> volumeArgs = LibertyDockerRunUtility.getVolumeArgs(volumes);
        newCmd.addAll(volumeArgs);
        newCmd.add("--name");
        newCmd.add(containerName);
        newCmd.add("-td");
        newCmd.add(imageName);
        for (String item : cmd) {
            if (item.equals(currentMode)) {
                newCmd.add(newMode);
                continue;
            }
            newCmd.add(item);
        }
        return newCmd;
    }

    public static String setupNewContainer(UserDirectory userDir, IPath workspaceRoot, BaseDockerContainer origContainer, Map<String, String> serviceInfo, WebSphereServer wasServer, MountProperty existingVolumeStatus, IProgressMonitor monitor) throws IOException, ConnectException, Exception {
        IProgressMonitor mon = monitor;
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        mon.beginTask(Messages.dockerCreatingNewContainer, 100);
        String origContainerName = origContainer.getContainerName();
        try {
            AbstractDockerMachine machine = origContainer.getDockerMachine();
            List<String> newNames = LibertyDockerRunUtility.getNewNames("run", serviceInfo.get("dockerImage"), origContainerName, machine, true, true, false);
            String newImageName = newNames.get(0);
            String containerName = newNames.get(1);
            IPath adjustedUsrFolder = BaseDockerContainer.getLocalToContainerPath((IPath)userDir.getPath());
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Volume mount is " + adjustedUsrFolder);
            }
            try {
                if (!existingVolumeStatus.equals((Object)MountProperty.OTHER_USR_MOUNT)) {
                    LibertyDockerRunUtility.copyFromContainerToHost(userDir.getPath(), serviceInfo, origContainer);
                }
            }
            catch (ConnectException ce) {
                throw ce;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            mon.worked(20);
            try {
                if (existingVolumeStatus.equals((Object)MountProperty.OTHER_USR_MOUNT)) {
                    String outputPath = origContainer.getEnvValue("WLP_OUTPUT_DIR");
                    IPath workAreaPath = new Path(outputPath).append(serviceInfo.get("libertyServerName")).append("workarea");
                    origContainer.deleteFolder(workAreaPath.toString());
                }
            }
            catch (Exception e) {
                Trace.trace((byte)1, "Cannot delete the workarea folder from the container.");
            }
            LibertyDockerRunUtility.flattenImage(newImageName, serviceInfo, origContainer, machine);
            mon.worked(20);
            origContainer.stop();
            mon.worked(20);
            List<String> runCmd = LibertyDockerRunUtility.getCreateCommand(origContainer, false, "run", "run", containerName, newImageName, wasServer);
            String cmd = LibertyDockerRunUtility.mergeStrings(runCmd);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Starting container: " + containerName + " with run command: " + cmd);
            }
            mon.worked(20);
            machine.runCommand(cmd, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L);
            mon.worked(20);
            List<String> startCmd = LibertyDockerRunUtility.getStartCommand(containerName);
            String startCmdStr = LibertyDockerRunUtility.mergeStrings(startCmd);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Starting container: " + containerName + ", with command: " + startCmdStr);
            }
            machine.runCommand(startCmdStr, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L, mon);
            serviceInfo.put("dockerContainer", origContainerName);
            String string = containerName;
            return string;
        }
        catch (Exception e) {
            Trace.logError("Failed to create run docker commands need to set up the new container", e);
            throw e;
        }
        finally {
            mon.done();
        }
    }

    public static void flattenImage(String newImageName, Map<String, String> serviceInfo, BaseDockerContainer finalContainer, AbstractDockerMachine machine) throws ConnectException {
        boolean flattened;
        block5: {
            flattened = false;
            try {
                AbstractFlattenImageHandler handler;
                String originalImage = serviceInfo.get("dockerImage");
                String currentImage = finalContainer.getImageName();
                long origSize = machine.getImageSize(originalImage);
                long currentSize = machine.getImageSize(currentImage);
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Docker original image " + originalImage + " size: " + origSize);
                    Trace.trace((byte)0, "Docker current image " + currentImage + " size: " + currentSize);
                }
                if (currentSize > origSize * 2L && (double)currentSize > Math.pow(10.0, 9.0) && (handler = Activator.getFlattenImageHandler()) != null) {
                    flattened = handler.handleFlattenImage(finalContainer, newImageName);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block5;
                Trace.trace((byte)1, "Failed to flatten the " + finalContainer.getContainerName() + " container.", e);
            }
        }
        if (!flattened) {
            finalContainer.commit(newImageName);
        }
    }

    public static List<String> getNewNames(String mode, String origImageName, String origContainerName, AbstractDockerMachine machine, boolean isLooseConfigEnabled, boolean isUserContainer, boolean includeMode) throws Exception {
        List existingContainers = machine.getContainerNames(true);
        List existingImages = machine.getImages();
        return LibertyDockerRunUtility.getNewNames(mode, origImageName, origContainerName, isLooseConfigEnabled, isUserContainer, includeMode, existingContainers, existingImages);
    }

    public static List<String> getNewNames(String mode, String origImageName, String origContainerName, boolean isLooseConfigEnabled, boolean isUserContainer, boolean includeMode, List<String> existingContainers, List<String> existingImages) throws Exception {
        ArrayList<String> newNames = new ArrayList<String>(2);
        String modifiedOrig = null;
        String modifiedOrigImage = null;
        if (!isUserContainer) {
            modifiedOrig = origContainerName.replace("_dev", "");
            modifiedOrigImage = origImageName.replace(origContainerName.toLowerCase() + "_", "");
        } else {
            if (origContainerName.contains("_dev") || origContainerName.contains("_debug") || origContainerName.contains("_run")) {
                modifiedOrig = origContainerName.replace("_dev", "");
                modifiedOrig = modifiedOrig.replace("_debug", "");
                if ((modifiedOrig = modifiedOrig.replace("_run", "")).length() == 0) {
                    modifiedOrig = "wlp";
                }
            } else {
                modifiedOrig = origContainerName;
            }
            modifiedOrigImage = origImageName;
        }
        boolean endsWithDashNumber = modifiedOrig.matches(".*-[0-9]+");
        if (endsWithDashNumber) {
            modifiedOrig = modifiedOrig.substring(0, modifiedOrig.lastIndexOf("-"));
        }
        String baseContainerName = modifiedOrig + (isLooseConfigEnabled ? "_dev" : "") + (includeMode ? "_" + mode : "");
        String baseImageName = baseContainerName.toLowerCase() + "_" + modifiedOrigImage;
        String containerName = baseContainerName;
        String imageName = baseImageName;
        int i = 1;
        while (existingContainers.contains(containerName) || existingImages.contains(imageName)) {
            containerName = modifiedOrig + "-" + i++ + (isLooseConfigEnabled ? "_dev" : "") + (includeMode ? "_" + mode : "");
            imageName = containerName.toLowerCase() + "_" + modifiedOrigImage;
        }
        newNames.add(imageName);
        newNames.add(containerName);
        return newNames;
    }

    private static IPath getWorkspacePath(WebSphereServer wsServer) {
        IPath workspacePath = null;
        if (wsServer.getWebSphereRuntime() != null) {
            workspacePath = wsServer.getWebSphereRuntime().getProject().getWorkspace().getRoot().getLocation();
        }
        if (workspacePath == null) {
            workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        return workspacePath;
    }

    private static void copyFromContainerToHost(IPath mappedUsrFolder, Map<String, String> serviceInfo, BaseDockerContainer container) throws ConnectException, IOException, CoreException {
        String serverConfigPath = serviceInfo.get("libertyServerConfigPath");
        String usrFolder = serverConfigPath.replace("/servers/" + serviceInfo.get("libertyServerName"), "/.");
        try {
            container.copyOut(usrFolder, mappedUsrFolder.toString());
        }
        catch (ConnectException ce) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Can't connect to container in order to copy the following usr folder from the container to the local filesystem:" + usrFolder);
            }
            throw ce;
        }
        catch (IOException io) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Can't copy the usr folder from the container to the local filesystem:" + mappedUsrFolder.toString());
            }
            throw io;
        }
        IProject runtimeProject = ResourcesPlugin.getWorkspace().getRoot().getProject(mappedUsrFolder.lastSegment());
        if (runtimeProject != null) {
            runtimeProject.refreshLocal(2, null);
        } else if (Trace.ENABLED) {
            Trace.trace((byte)1, "Runtime project was null, and could not be refreshed. MappedUsrFolder was: " + mappedUsrFolder);
        }
    }

    public static List<String> getVolumeArgs(Map<IPath, IPath> volumeMap) {
        ArrayList<String> args = new ArrayList<String>();
        if (volumeMap == null || volumeMap.isEmpty()) {
            return args;
        }
        for (Map.Entry<IPath, IPath> entry : volumeMap.entrySet()) {
            IPath path = entry.getKey();
            if (path.toFile().exists()) {
                IPath adjustedSrcPath = BaseDockerContainer.getLocalToContainerPath((IPath)path);
                args.add("-v");
                args.add("\"" + adjustedSrcPath.toString() + ":" + entry.getValue().toString() + "\"");
                continue;
            }
            if (!Trace.ENABLED) continue;
            Trace.trace((byte)1, "No volume will be created for the following path because it does not exist on the file system: " + path.toOSString());
        }
        return args;
    }

    public static List<IPath> getAdditionalVolumes(List<String> additionalVolumes, BaseDockerContainer container) throws Exception {
        Map existingVolumes = container.getMountedVolumeHash();
        ArrayList<IPath> newVolumes = new ArrayList<IPath>();
        for (String path : additionalVolumes) {
            boolean found = false;
            Path srcPath = new Path(path);
            for (IPath existingPath : existingVolumes.keySet()) {
                if (!existingPath.isPrefixOf((IPath)srcPath)) continue;
                found = true;
                break;
            }
            if (found) continue;
            newVolumes.add((IPath)srcPath);
        }
        return newVolumes;
    }

    public static Map<IPath, IPath> calculateVolumes(BaseDockerContainer container, WebSphereServer wsServer, boolean looseCfgModeChanged) throws Exception {
        Map volumes = container.getMountedVolumeHash();
        Map serviceInfo = wsServer.getServiceInfo();
        String libertyUsrPath = LibertyDockerRunUtility.getLibertyUsrPath(serviceInfo);
        String libertyStdevPath = LibertyDockerRunUtility.getLibertyStdevPath(serviceInfo);
        if (wsServer.isLooseConfigEnabled()) {
            LibertyDockerServer serverExt;
            IPath usrDirPath = wsServer.getUserDirectory().getPath();
            Path expectedDest = new Path(libertyUsrPath);
            IPath dest = (IPath)volumes.get(usrDirPath = FileUtil.getCanonicalPath((IPath)usrDirPath));
            if (!expectedDest.equals((Object)dest)) {
                volumes.put(usrDirPath, expectedDest);
            }
            if ((serverExt = (LibertyDockerServer)((Object)wsServer.getAdapter(LibertyDockerServer.class))) == null) {
                Trace.logError("The server should be a Liberty Docker server but the conversion failed.", null);
            } else {
                List<String> mandatoryVolumes = serverExt.getMandatoryVolumes(wsServer);
                String candidate = libertyStdevPath;
                for (String mandatoryVolume : mandatoryVolumes) {
                    if (!LibertyDockerRunUtility.newVolumeNeeded(volumes, (IPath)new Path(mandatoryVolume))) continue;
                    volumes.put(new Path(mandatoryVolume), LibertyDockerRunUtility.getVolumeDestination(candidate, volumes));
                }
                IPath workspacePath = LibertyDockerRunUtility.getWorkspacePath(wsServer);
                if (LibertyDockerRunUtility.newVolumeNeeded(volumes, workspacePath = FileUtil.getCanonicalPath((IPath)workspacePath))) {
                    volumes.put(workspacePath, LibertyDockerRunUtility.getVolumeDestination(candidate, volumes));
                }
                Set<IPath> moduleLocations = LibertyDockerRunUtility.getAllModuleLocations(wsServer);
                List<String> additionalVolumes = serverExt.getAdditionalVolumes(wsServer);
                LibertyDockerRunUtility.mergeModuleLocations(moduleLocations, additionalVolumes);
                ArrayList<IPath> newVolumes = new ArrayList<IPath>();
                for (IPath moduleLocation : moduleLocations) {
                    if (!LibertyDockerRunUtility.newVolumeNeeded(volumes, moduleLocation)) continue;
                    dest = LibertyDockerRunUtility.getVolumeDestination(libertyStdevPath, volumes);
                    volumes.put(moduleLocation, dest);
                    newVolumes.add(moduleLocation);
                }
                serverExt.setAdditionalVolumes(wsServer, newVolumes);
            }
        } else if (looseCfgModeChanged) {
            Iterator it = volumes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                IPath dest = (IPath)entry.getValue();
                String destStr = dest.toString();
                if (!destStr.startsWith(libertyStdevPath) && !destStr.equals(libertyUsrPath)) continue;
                it.remove();
            }
        }
        return volumes;
    }

    public static void addModuleLocations(WebSphereServer wsServer, Map<IPath, IPath> containerVolumes, Set<IPath> locations, IModule module) {
        Set<IPath> moduleLocations = LibertyDockerRunUtility.getLocations(wsServer, module);
        for (IPath location : moduleLocations) {
            boolean found = false;
            for (IPath existingPath : containerVolumes.keySet()) {
                IPath basePath = FileUtil.getCanonicalPath((IPath)existingPath);
                if (!basePath.isPrefixOf(location)) continue;
                found = true;
            }
            if (found) continue;
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "No existing volume was found for: " + location);
            }
            LibertyDockerRunUtility.mergeModuleLocation(locations, location);
        }
    }

    public static Set<IPath> getLocations(WebSphereServer server, IModule module) {
        HashSet<IPath> locations = new HashSet<IPath>();
        LibertyDockerRunUtility.getLocations(server, module, locations);
        return locations;
    }

    public static Set<IPath> getAllModuleLocations(WebSphereServer server) {
        IModule[] modules = server.getServer().getModules();
        HashSet<IPath> locations = new HashSet<IPath>();
        for (IModule module : modules) {
            LibertyDockerRunUtility.getLocations(server, module, locations);
        }
        return locations;
    }

    private static void getLocations(WebSphereServer server, IModule module, Set<IPath> locations) {
        IModule[] children;
        IProject project = module.getProject();
        if (project != null) {
            IPath projectPath = project.getLocation();
            IPath parentPath = FileUtil.getCanonicalPath((IPath)projectPath.removeLastSegments(1));
            LibertyDockerRunUtility.mergeModuleLocation(locations, parentPath);
        }
        for (IModule child : children = server.getChildModules(new IModule[]{module})) {
            LibertyDockerRunUtility.getLocations(server, child, locations);
        }
    }

    public static void mergeModuleLocations(Set<IPath> locations, Collection<String> newLocations) {
        for (String newLocation : newLocations) {
            LibertyDockerRunUtility.mergeModuleLocation(locations, (IPath)new Path(newLocation));
        }
    }

    public static void mergeModuleLocation(Set<IPath> locations, IPath location) {
        boolean found = false;
        IPath newPath = FileUtil.getCanonicalPath((IPath)location);
        for (IPath path : locations) {
            if (path.isPrefixOf(newPath)) {
                found = true;
                break;
            }
            if (!newPath.isPrefixOf(path)) continue;
            locations.remove(path);
            break;
        }
        if (!found) {
            locations.add(newPath);
        }
    }

    private static boolean newVolumeNeeded(Map<IPath, IPath> volumes, IPath localPath) {
        boolean found = false;
        for (IPath path : volumes.keySet()) {
            if (!path.isPrefixOf(localPath)) continue;
            found = true;
            break;
        }
        return !found;
    }

    private static IPath getVolumeDestination(String root, Map<IPath, IPath> existingVolumes) {
        int i = 0;
        Path path = new Path(root);
        Collection<IPath> destPaths = existingVolumes.values();
        while (destPaths.contains(path)) {
            path = new Path(root + ++i);
        }
        return path;
    }

    public static MountProperty checkContainerForLooseConfigMountVolume(BaseDockerContainer container, Map<String, String> serviceInfo, IPath workspacePath) {
        EnumSet<MountProperties> mountVolumeDescription;
        block11: {
            mountVolumeDescription = EnumSet.noneOf(MountProperties.class);
            try {
                String stdevString;
                IPath usrMount = BaseDockerContainer.getContainerToLocalPath((IPath)new Path(container.getMountSourceForDestination(LibertyDockerRunUtility.getLibertyUsrPath(serviceInfo))));
                if (usrMount != null) {
                    if (FileUtil.getCanonicalPath((String)usrMount.toString()).startsWith(FileUtil.getCanonicalPath((IPath)workspacePath).toString())) {
                        mountVolumeDescription.add(MountProperties.SAME_USR_MOUNT);
                    } else {
                        mountVolumeDescription.add(MountProperties.OTHER_USR_MOUNT);
                    }
                }
                IPath stdevMount = null;
                boolean matchesCurrentWorkspace = false;
                int i = 0;
                String base = LibertyDockerRunUtility.getLibertyStdevPath(serviceInfo);
                while ((stdevString = container.getMountSourceForDestination(base + (i == 0 ? "" : Integer.toString(i)))) != null) {
                    stdevMount = BaseDockerContainer.getContainerToLocalPath((IPath)new Path(stdevString));
                    if (stdevMount != null && FileUtil.getCanonicalPath((String)stdevMount.toString()).startsWith(FileUtil.getCanonicalPath((IPath)workspacePath).toString())) {
                        matchesCurrentWorkspace = true;
                        break;
                    }
                    ++i;
                    if (stdevMount != null) continue;
                }
                if (matchesCurrentWorkspace) {
                    mountVolumeDescription.add(MountProperties.SAME_WORKSPACE_MOUNT);
                } else {
                    mountVolumeDescription.add(MountProperties.OTHER_WORKSPACE_MOUNT);
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block11;
                Trace.logError("Failed to determine if the " + container.getContainerName() + " container is already set up for running applications directly from the workspace", e);
            }
        }
        MountProperty prop = MountProperty.NO_USR_MOUNT;
        if (mountVolumeDescription.contains((Object)MountProperties.SAME_USR_MOUNT) && mountVolumeDescription.contains((Object)MountProperties.SAME_WORKSPACE_MOUNT)) {
            prop = MountProperty.SAME_USR_MOUNT;
        }
        if (mountVolumeDescription.contains((Object)MountProperties.OTHER_USR_MOUNT) && mountVolumeDescription.contains((Object)MountProperties.OTHER_WORKSPACE_MOUNT)) {
            prop = MountProperty.OTHER_USR_MOUNT;
        }
        return prop;
    }

    public static enum MountProperty {
        OTHER_USR_MOUNT,
        SAME_USR_MOUNT,
        NO_USR_MOUNT;

    }

    private static enum MountProperties {
        SAME_USR_MOUNT,
        SAME_WORKSPACE_MOUNT,
        OTHER_USR_MOUNT,
        OTHER_WORKSPACE_MOUNT;

    }
}

