/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde;

import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import java.net.URL;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DDEPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.xwt.dde.ui";
    private static DDEPlugin plugin;
    public static final String PREFERENCES_SORT_TREE_ALPHABETICALLY = "PreferenceSortTreeAlphabetically";
    public static final String PREFERENCES_EXPAND_SECTIONS = "PreferenceExpandSections";
    public static final boolean PREFERENCES_SORT_TREE_ALPHABETICALLY_DEFAULT_VALUE = true;
    public static final boolean PREFERENCES_EXPAND_SECTIONS_DEFAULT_VALUE = true;
    public Font FONT_DEFAULT;
    public Font FONT_DEFAULT_BOLD;

    public DDEPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CustomizationManager.getInstance();
        this.initializeFonts();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DDEPlugin getDefault() {
        return plugin;
    }

    public Image getImage(String iconName) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        if (imageRegistry.get(iconName) != null) {
            return imageRegistry.get(iconName);
        }
        imageRegistry.put(iconName, this.getImageDescriptor(iconName));
        return imageRegistry.get(iconName);
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.xwt.dde", (String)path);
    }

    public Image getIcon(String name) {
        try {
            ImageRegistry imageRegistry = this.getImageRegistry();
            if (imageRegistry.get(name) != null) {
                return imageRegistry.get(name);
            }
            URL installURL = DDEPlugin.getDefault().getBundle().getEntry("/");
            String imageString = "icons/" + name;
            URL imageURL = new URL(installURL, imageString);
            imageRegistry.put(name, ImageDescriptor.createFromURL((URL)imageURL));
            return imageRegistry.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Image getImageFromRegistry(String name) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        return imageRegistry.get(name);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(PREFERENCES_SORT_TREE_ALPHABETICALLY, true);
        store.setDefault(PREFERENCES_EXPAND_SECTIONS, true);
    }

    private void initializeFonts() {
        try {
            this.FONT_DEFAULT = JFaceResources.getDefaultFont();
            FontData[] fontData = this.FONT_DEFAULT.getFontData();
            for (int i = 0; i < fontData.length; ++i) {
                fontData[i].setStyle(1);
            }
            this.FONT_DEFAULT_BOLD = new Font(null, fontData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

