/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.servertype;

import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractLaunchConfigurationExtension;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerExtension;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ServerTypeExtensionFactory {
    public static final String SERVER_TYPE_LAUNCH_ATTRIBUTE = "serverLaunchConfigurationClass";
    public static final String SERVER_TYPE_ID_ATTRIBUTE = "typeId";
    public static final String SERVER_TYPE_SERVER_ATTR = "serverClass";
    public static final String SERVER_TYPE_BEHAVIOUR_ATTR = "serverBehaviourClass";
    public static final String SERVER_ID = "id";
    public static HashMap<String, IConfigurationElement> serverTypeMap = null;
    public static HashMap<String, AbstractLaunchConfigurationExtension> serverLaunchClassMap = null;

    protected static Object getExtensionClass(String serverType, String attribute) {
        Object returnClass;
        block3: {
            returnClass = null;
            IConfigurationElement configClass = serverTypeMap.get(serverType);
            if (configClass != null) {
                try {
                    returnClass = configClass.createExecutableExtension(attribute);
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block3;
                    Trace.trace((byte)1, "Failed to load extension class serverType=" + serverType + ", attribute=" + attribute);
                }
            }
        }
        return returnClass;
    }

    public static AbstractLaunchConfigurationExtension getServerLaunchOperation(String serverType) {
        AbstractLaunchConfigurationExtension launchClass;
        if (serverTypeMap == null) {
            ServerTypeExtensionFactory.init();
        }
        if ((launchClass = serverLaunchClassMap.get(serverType)) == null) {
            launchClass = (AbstractLaunchConfigurationExtension)((Object)ServerTypeExtensionFactory.getExtensionClass(serverType, SERVER_TYPE_LAUNCH_ATTRIBUTE));
            serverLaunchClassMap.put(serverType, launchClass);
        }
        return launchClass;
    }

    public static AbstractServerBehaviourExtension getServerBehaviourExtension(String serverType) {
        if (serverTypeMap == null) {
            ServerTypeExtensionFactory.init();
        }
        AbstractServerBehaviourExtension serverBehaviour = (AbstractServerBehaviourExtension)ServerTypeExtensionFactory.getExtensionClass(serverType, SERVER_TYPE_BEHAVIOUR_ATTR);
        return serverBehaviour;
    }

    public static AbstractServerExtension getServerExtension(String serverType) {
        if (serverTypeMap == null) {
            ServerTypeExtensionFactory.init();
        }
        AbstractServerExtension server = (AbstractServerExtension)ServerTypeExtensionFactory.getExtensionClass(serverType, SERVER_TYPE_SERVER_ATTR);
        return server;
    }

    protected static void init() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ws.st.common.core.ext.serverTypeExtension");
        serverTypeMap = new HashMap();
        serverLaunchClassMap = new HashMap();
        String serverTypeId = null;
        for (IConfigurationElement elem : configElements) {
            serverTypeId = elem.getAttribute(SERVER_TYPE_ID_ATTRIBUTE);
            serverTypeMap.put(serverTypeId, elem);
        }
    }
}

