/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.ui.internal.wizard.IServerWizardComposite;
import com.ibm.ws.st.ui.internal.wizard.WebSphereServerParentComposite;
import com.ibm.ws.st.ui.internal.wizard.WebSphereServerWizardCommonFragment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class WebSphereServerWizardFragment
extends WebSphereServerWizardCommonFragment {
    protected WebSphereServerParentComposite comp;
    protected IPath lastRuntimeLocation = null;
    protected IRuntime lastRuntime = null;
    protected boolean hadServers = false;

    public boolean hasComposite() {
        return this.isLocalhost();
    }

    public boolean isComplete() {
        if (!this.hasComposite() || this.comp == null || this.comp.isDisposed()) {
            return false;
        }
        return this.comp.isComplete();
    }

    public Composite createComposite(Composite parent, IWizardHandle wizard) {
        this.comp = new WebSphereServerParentComposite(parent, wizard, this.getActiveServerTypeExtensions(), this.getTaskModel());
        return this.comp;
    }

    public void enter() {
        IRuntime rt = (IRuntime)this.getTaskModel().getObject("runtime");
        if (this.lastRuntime != null && !this.lastRuntime.equals(rt)) {
            boolean hasServers = this.runtimeHasServers();
            if (hasServers != this.hadServers) {
                this.comp.updateChildren(hasServers);
            } else {
                for (Control ctrl : this.comp.getChildren()) {
                    if (!(ctrl instanceof IServerWizardComposite)) continue;
                    ((IServerWizardComposite)ctrl).reInitialize();
                }
            }
        }
        this.lastRuntime = rt;
        this.hadServers = this.runtimeHasServers();
        if (!this.runtimeHasServers() || !this.isLocalhost()) {
            return;
        }
        IServerWorkingCopy wc = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        if (this.comp != null) {
            UserDirectory userDir = (UserDirectory)this.getTaskModel().getObject("userDirectory");
            this.comp.setServer(wc, userDir);
        } else {
            WebSphereServer server = (WebSphereServer)wc.loadAdapter(WebSphereServer.class, null);
            server.setDefaults((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (this.hasComposite() && this.comp != null) {
            this.comp.performFinish(monitor);
        }
    }

    public void performCancel(IProgressMonitor monitor) {
        if (this.hasComposite() && this.comp != null) {
            this.comp.performCancel();
        }
    }
}

