/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.utility.UtilityWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UtilityWizard
extends Wizard {
    protected final UtilityWizardPage page;

    public UtilityWizard(UtilityWizardPage page) {
        this.page = page;
        this.setWindowTitle(page.getTitle());
        this.addPage((IWizardPage)page);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("wizServer"));
    }

    public static int open(Shell shell, UtilityWizardPage page) {
        UtilityWizard wizard = new UtilityWizard(page);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setPageSize(400, 400);
        return dialog.open();
    }

    public boolean performFinish() {
        if (!this.page.preFinish()) {
            return false;
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        UtilityWizard.this.page.finish(monitor);
                    }
                    catch (Throwable t) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)UtilityWizard.this.getShell(), (String)UtilityWizard.this.page.getTitle(), (String)t.getLocalizedMessage());
                            }
                        });
                        throw new InvocationTargetException(t);
                    }
                }
            });
        }
        catch (Exception e) {
            Trace.logError("Error finishing wizard with the title: " + this.page.getTitle(), e);
            return false;
        }
        return true;
    }
}

