/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.marker.MarkerResolutionGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class QuickFixProcessor
implements IQuickAssistProcessor {
    private static final MarkerResolutionGenerator resolutionGen = new MarkerResolutionGenerator();

    public boolean canAssist(IQuickAssistInvocationContext quickAssistContext) {
        Iterator iter = this.getAnnotationIterator(quickAssistContext);
        if (iter != null) {
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                if (!(anno instanceof SimpleMarkerAnnotation)) continue;
                IMarker marker = ((SimpleMarkerAnnotation)anno).getMarker();
                try {
                    if (!"com.ibm.ws.st.core.configmarker".equals(marker.getType()) || !resolutionGen.hasResolutions(marker)) continue;
                    return true;
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, (String)"Failed to get marker type for quick assist processing.", (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean canFix(Annotation arg0) {
        return false;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext quickAssistContext) {
        Iterator iter = this.getAnnotationIterator(quickAssistContext);
        if (iter != null) {
            ArrayList<QuickFixCompletionProposal> proposals = new ArrayList<QuickFixCompletionProposal>();
            while (iter.hasNext()) {
                Annotation anno = (Annotation)iter.next();
                if (!(anno instanceof SimpleMarkerAnnotation)) continue;
                IMarker marker = ((SimpleMarkerAnnotation)anno).getMarker();
                try {
                    IMarkerResolution[] resolutions;
                    if (!"com.ibm.ws.st.core.configmarker".equals(marker.getType()) || (resolutions = resolutionGen.getResolutions(marker)) == null) continue;
                    for (IMarkerResolution resolution : resolutions) {
                        proposals.add(new QuickFixCompletionProposal(marker, resolution));
                    }
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, (String)"Failed to get marker type for quick assist processing.", (Throwable)e);
                }
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private Iterator getAnnotationIterator(IQuickAssistInvocationContext quickAssistContext) {
        IAnnotationModel model;
        ISourceViewer viewer = quickAssistContext.getSourceViewer();
        IAnnotationModel iAnnotationModel = model = viewer != null ? viewer.getAnnotationModel() : null;
        if (model instanceof IAnnotationModelExtension2) {
            int documentOffset = quickAssistContext.getOffset();
            int length = viewer != null ? viewer.getSelectedRange().y : 0;
            return ((IAnnotationModelExtension2)model).getAnnotationIterator(documentOffset, length, true, true);
        }
        return null;
    }

    private static class QuickFixCompletionProposal
    implements ICompletionProposal {
        private final IMarker marker;
        private final IMarkerResolution resolution;

        public QuickFixCompletionProposal(IMarker marker, IMarkerResolution resolution) {
            this.marker = marker;
            this.resolution = resolution;
        }

        public void apply(IDocument arg0) {
            this.resolution.run(this.marker);
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.resolution.getLabel();
        }

        public Image getImage() {
            return Activator.getImage("configElement");
        }

        public Point getSelection(IDocument arg0) {
            return null;
        }
    }
}

