/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public class QuickFixPlainTextPassword
extends AbstractMarkerResolution {
    public String getLabel() {
        return Messages.plainTextQuickFix;
    }

    public void run(IMarker marker) {
        String xpath = marker.getAttribute("xpathAttr", "");
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        if (configFile.encodePassword(xpath)) {
            try {
                configFile.save(null);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Quick fix for plain text password failed. Error trying to save configuration file: " + configFile.getURI(), e);
                }
                this.showErrorMessage();
            }
        } else {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for plain text password failed. Error trying to encode '" + xpath + "' in configuration: " + configFile.getURI(), null);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.encodingFailedMessage;
    }
}

