/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.validation.ConfigurationQuickFix;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterUtil;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class QuickFixIgnoreAllProperties
extends AbstractMarkerResolution
implements ConfigurationQuickFix {
    private final String elementName;

    public QuickFixIgnoreAllProperties() {
        this(null);
    }

    public QuickFixIgnoreAllProperties(String elemName) {
        this.elementName = elemName;
    }

    public String getLabel() {
        if (this.elementName == null) {
            return Messages.ignoreAllAttrAllElemLabel;
        }
        return NLS.bind((String)Messages.ignoreAllAttrElemLabel, (Object[])new String[]{this.elementName});
    }

    public void run(IMarker marker) {
        block4: {
            IFile resource = this.getResource(marker);
            if (resource == null) {
                return;
            }
            if (this.ignoreAllAttributes((IResource)resource)) {
                try {
                    resource.touch((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                catch (CoreException e) {
                    if (!Trace.ENABLED) break block4;
                    Trace.trace((byte)6, "Quick fix for ignore all unrecognized attributes failed. Error trying to refresh configuration file: " + resource.getLocationURI(), e);
                }
            }
        }
        this.showErrorMessage();
    }

    public ConfigurationQuickFix.ResolutionType getResolutionType() {
        if (this.elementName == null) {
            return ConfigurationQuickFix.ResolutionType.IGNORE_ALL_ATTR_ALL_ELEM;
        }
        return ConfigurationQuickFix.ResolutionType.IGNORE_ALL_ATTR_ELEM;
    }

    private boolean ignoreAllAttributes(IResource resource) {
        if (this.elementName == null) {
            return ValidationFilterUtil.ignoreAllAttributes((IResource)resource);
        }
        return ValidationFilterUtil.ignoreAllAttributes((IResource)resource, (String)this.elementName);
    }

    @Override
    protected String getErrorMessage() {
        return Messages.ignoreAllPropFailedMessage;
    }
}

