/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.validation.ConfigurationQuickFix;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;

public class QuickFixBestMatchProperty
extends AbstractMarkerResolution
implements ConfigurationQuickFix {
    private final String bestMatch;

    public QuickFixBestMatchProperty(String bestMatch) {
        this.bestMatch = bestMatch;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.unrecognizedPropertyQuickFix, (Object[])new String[]{this.bestMatch});
    }

    public void run(IMarker marker) {
        String xpath = marker.getAttribute("xpathAttr", "");
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        if (configFile.changePropertyName(xpath, this.bestMatch)) {
            try {
                configFile.save(null);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Quick fix for unknown attribute failed. Error trying to save configuration file: " + configFile.getURI(), e);
                }
                this.showErrorMessage();
            }
        } else {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for unknown attribute failed. Error trying to change attribute name '" + xpath + "' in configuration: " + configFile.getURI(), null);
            }
            this.showErrorMessage();
        }
    }

    public ConfigurationQuickFix.ResolutionType getResolutionType() {
        return ConfigurationQuickFix.ResolutionType.BEST_MATCH_ATTR;
    }

    @Override
    protected String getErrorMessage() {
        return Messages.propChangeFailedMessage;
    }
}

