/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractMarkerResolution
implements IMarkerResolution {
    protected IFile getResource(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource != null && resource instanceof IFile) {
            return (IFile)resource;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)6, "Quick fix failed. Marker's resource is null or not a file", null);
        }
        this.showErrorMessage();
        return null;
    }

    protected ConfigurationFile getConfigFile(IResource resource) {
        ConfigurationFile configFile;
        block5: {
            URI uri;
            UserDirectory userDir;
            configFile = ConfigUtils.getConfigFile((IResource)resource);
            if (configFile == null && (userDir = ConfigUtils.getUserDirectory((URI)(uri = resource.getLocation().toFile().toURI()))) != null) {
                try {
                    configFile = new ConfigurationFile(uri, userDir);
                }
                catch (IOException e) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)1, "Could not create configuration file: " + uri);
                }
            }
        }
        if (configFile == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix failed. Could not locate configuration file: " + resource.getLocationURI(), null);
            }
            this.showErrorMessage();
        }
        return configFile;
    }

    protected abstract String getErrorMessage();

    protected void showErrorMessage() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MessageDialog.openError((Shell)shell, (String)Messages.title, (String)this.getErrorMessage());
    }
}

