/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import com.ibm.ws.st.core.internal.repository.ISite;
import com.ibm.ws.st.core.internal.repository.ISource;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TestRuntimeDownloader
implements ISite {
    private boolean authenticated = false;
    private static final int DELAY = 2000;

    static void delay(IProgressMonitor monitor) {
        monitor.beginTask("Connecting...", 100);
        monitor.worked(20);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        monitor.worked(50);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        monitor.done();
    }

    public boolean authenticate(PasswordAuthentication pa, IProgressMonitor monitor) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "authenticate");
        }
        TestRuntimeDownloader.delay(monitor);
        this.authenticated = pa != null && "tim".equals(pa.getUserName());
        return this.authenticated;
    }

    public List<IProduct> getCoreProducts(IProgressMonitor monitor) {
        IProduct p = new IProduct(){

            public String getName() {
                return "wlp-test.zip";
            }

            public String getDescription() {
                return "Test download description";
            }

            public IProduct.Type getType() {
                return IProduct.Type.INSTALL;
            }

            public IProduct.ProductType getProductType() {
                return IProduct.ProductType.LOCAL_TYPE;
            }

            public long getSize() {
                return 25000L;
            }

            public License getLicense(IProgressMonitor monitor) throws IOException {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "getLicense");
                }
                TestRuntimeDownloader.delay(monitor);
                if (!TestRuntimeDownloader.this.isAuthenticated()) {
                    throw new IOException("not authenticated");
                }
                return new License("Test license", "Test License");
            }

            public String getSiteName() {
                return "Test Download";
            }

            public List<String> getProvideFeature() {
                return null;
            }

            public List<String> getRequireFeature() {
                return null;
            }

            public IRuntimeInfo getRuntimeInfo() {
                return null;
            }

            public String getAttribute(String name) {
                return null;
            }

            public ISource getSource() {
                return null;
            }

            public String getHashSHA256() {
                return null;
            }

            public boolean isInstallOnlyFeature() {
                return false;
            }
        };
        return Arrays.asList(p);
    }

    public String getName() {
        return "Test Download";
    }

    public boolean isAuthenticationRequired() {
        return true;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void reset() {
    }

    public List<IProduct> getApplicableProducts(IRuntimeInfo runtimeInfo, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public List<IProduct> getConfigSnippetProducts(IProgressMonitor monitor) {
        return Collections.emptyList();
    }
}

