/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.License;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.download.ScrollableMessageDialog;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddonUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void refreshMetadata(WebSphereRuntime runtime, IProgressMonitor monitor2) {
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final boolean[] done = new boolean[]{false};
        final String runtimeName = runtime.getRuntime().getName();
        int totalWork = 700;
        int worked = 100;
        String message = NLS.bind((String)Messages.taskRefreshingMetadata, (Object)runtimeName);
        try {
            monitor.beginTask(message, 700);
            monitor.subTask(message);
            monitor.worked(worked);
            runtime.generateMetadata((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    done[0] = true;
                    if (!event.getResult().isOK() && Trace.ENABLED) {
                        Trace.trace((byte)1, "Metadata refresh did not finish successfully for " + runtimeName);
                    }
                    event.getJob().removeJobChangeListener((IJobChangeListener)this);
                }
            }, true, 15);
            while (!monitor.isCanceled() && !done[0]) {
                try {
                    Thread.sleep(300L);
                    if (worked >= 700) continue;
                    monitor.worked(50);
                    worked += 50;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (worked < 700) {
                monitor.worked(700 - worked);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected static boolean isRefreshMetadataRequired(List<IProduct> selectedList) {
        for (IProduct p : selectedList) {
            List features = p.getProvideFeature();
            if (features == null || features.isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static void refreshServerFolder(final WebSphereServerInfo server) {
        Job job = new Job(Messages.wizRefreshServerFolderJob){

            protected IStatus run(IProgressMonitor monitor) {
                block3: {
                    IFolder serverFolder = server.getServerFolder();
                    if (serverFolder != null && serverFolder.exists()) {
                        try {
                            serverFolder.refreshLocal(2, monitor);
                        }
                        catch (CoreException ce) {
                            if (!Trace.ENABLED) break block3;
                            Trace.trace((byte)1, "Couldn't refresh server folder: " + serverFolder.getName(), ce);
                        }
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.job.family".equals(family);
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static void showResult(final Shell shell, Map<IProduct, IStatus> statusMap) {
        if (statusMap.isEmpty()) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "The install status is either empty or there was no successful install");
            }
            return;
        }
        final StringBuilder detailedMessage = new StringBuilder();
        StringBuilder productsInstalled = new StringBuilder();
        StringBuilder productsfailed = new StringBuilder();
        StringBuilder productsCancelled = new StringBuilder();
        final StringBuilder messageDescription = new StringBuilder();
        String successMessage = "";
        String failureMessage = "";
        for (IProduct product : statusMap.keySet()) {
            IStatus status = statusMap.get(product);
            if (status == Status.OK_STATUS) {
                productsInstalled.append("    - ").append(product.getName()).append("\n");
                continue;
            }
            if (status == Status.CANCEL_STATUS) {
                productsCancelled.append("    - ").append(product.getName()).append("\n");
                continue;
            }
            if (status == Status.OK_STATUS) continue;
            productsfailed.append("    - ").append(product.getName()).append("\n");
            if (status.getMessage().isEmpty()) continue;
            detailedMessage.append("    - ").append(product.getName()).append("\n");
            detailedMessage.append(status.getMessage()).append("\n").append("\n");
        }
        if (productsInstalled.length() > 0) {
            successMessage = NLS.bind((String)Messages.wizInstallSuccess, (Object)productsInstalled.toString());
            messageDescription.append(successMessage).append("\n");
        }
        if (productsCancelled.length() > 0) {
            productsCancelled.append(Messages.wizInstallCancelled);
            detailedMessage.append((CharSequence)productsCancelled);
            messageDescription.append((CharSequence)productsCancelled).append("\n");
        }
        if (productsfailed.length() > 0) {
            failureMessage = NLS.bind((String)Messages.wizInstallFailure, (Object)productsfailed.toString());
            messageDescription.append(failureMessage).append("\n");
        }
        final int dispIcon = failureMessage.length() > 0 ? 4 : 2;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (detailedMessage.length() > 0) {
                    Trace.logError("Install Failed :" + detailedMessage.toString(), null);
                }
                new ScrollableMessageDialog(shell, detailedMessage.toString(), dispIcon, messageDescription.toString()).open();
            }
        });
    }

    public static Map<IProduct, License> createLicenseMap() {
        return new ConcurrentHashMap<IProduct, License>();
    }
}

