/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.config.BaseCustomObject;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ReferenceBaseCustomObject
extends BaseCustomObject {
    protected static final String INDENT_STRING = "    ";

    protected String[] getReferences(CMAttributeDeclaration attrDecl) {
        if (attrDecl != null) {
            return SchemaUtil.getReferences((CMNode)attrDecl);
        }
        return null;
    }

    protected String fixReferenceForNested(Element parent, String attrName, String reference) {
        CMElementDeclaration elemDecl = this.getElementDecl(parent);
        if (elemDecl == null) {
            return reference;
        }
        CMNamedNodeMap children = elemDecl.getLocalElements();
        if (children.getNamedItem(reference) != null) {
            return reference;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            String name = children.item(i).getNodeName();
            if (!attrName.startsWith(name)) continue;
            return name;
        }
        return null;
    }

    protected Element addNested(Element parent, String name) {
        Document doc = parent.getOwnerDocument();
        int nestedLevel = this.getNestedLevel(parent);
        Element elem = doc.createElement(name);
        if (parent.hasChildNodes()) {
            parent.appendChild(doc.createTextNode(INDENT_STRING));
        } else {
            parent.appendChild(doc.createTextNode("\n" + this.getIndent(nestedLevel + 1)));
        }
        parent.appendChild(elem);
        parent.appendChild(doc.createTextNode("\n" + this.getIndent(nestedLevel)));
        return elem;
    }

    protected Element addTopLevel(Document doc, String name, String id, Element referencingElem) {
        Element elem = doc.createElement(name);
        elem.setAttribute("id", id);
        Node previousSibling = this.getTopLevelParent(referencingElem);
        if (previousSibling != null) {
            Node parent = previousSibling.getParentNode();
            parent.replaceChild(elem, previousSibling);
            parent.insertBefore(previousSibling, elem);
            parent.insertBefore(doc.createTextNode("\n\n    "), elem);
        } else {
            Element root = doc.getDocumentElement();
            root.appendChild(doc.createTextNode("\n    "));
            root.appendChild(elem);
            root.appendChild(doc.createTextNode("\n"));
        }
        return elem;
    }

    protected Node getTopLevelParent(Element elem) {
        Node node = elem;
        while (node.getParentNode() != null && node.getParentNode().getNodeType() == 1) {
            if ("server".equals(node.getParentNode().getNodeName())) {
                return node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    protected int getNestedLevel(Element elem) {
        int i = 0;
        for (Node parent = elem.getParentNode(); parent != null && parent.getNodeType() != 9; parent = parent.getParentNode()) {
            ++i;
        }
        return i;
    }

    protected String getIndent(int indent) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    protected void openElement(IEditorPart editorPart, Element elem) {
        if (editorPart instanceof DDEMultiPageEditorPart) {
            ((DDEMultiPageEditorPart)editorPart).refresh();
            ((DDEMultiPageEditorPart)editorPart).setSelection((Node)elem);
        }
    }

    protected static class IDDialog
    extends TitleAreaDialog {
        String label;
        Text idText;
        String id;

        public IDDialog(Shell parent, String label) {
            super(parent);
            this.label = label;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.idDialogTitle);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(Messages.idDialogLabel);
            this.setTitleImage(Activator.getImage("wizServer"));
            this.setMessage(NLS.bind((String)Messages.idDialogMessage, (Object)this.label));
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 11;
            layout.marginWidth = 9;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 7;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText(Messages.idLabel);
            data = new GridData(1, 2, false, false);
            label.setLayoutData((Object)data);
            this.idText = new Text(composite, 2048);
            data = new GridData(4, 4, true, false);
            this.idText.setLayoutData((Object)data);
            this.idText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    String idStr = idText.getText();
                    this.enableOKButton(idStr != null && !idStr.isEmpty());
                }
            });
            return composite;
        }

        protected Control createButtonBar(Composite parent) {
            Control control = super.createButtonBar(parent);
            this.enableOKButton(false);
            return control;
        }

        public void create() {
            super.create();
            this.idText.setFocus();
        }

        protected void okPressed() {
            this.id = this.idText.getText();
            super.okPressed();
        }

        protected void enableOKButton(boolean value) {
            this.getButton(0).setEnabled(value);
        }

        public String getId() {
            return this.id;
        }
    }
}

