/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.ws.st.ui.internal.config.IncludeDialog;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IncludeBrowser
implements IAdvancedCustomizationObject {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String invoke(String value, Node node, Element closestAncestor, IEditorPart editorPart) {
        Shell shell = editorPart.getSite().getShell();
        IEditorInput input = editorPart.getEditorInput();
        IncludeDialog dialog = new IncludeDialog(shell, closestAncestor.getOwnerDocument(), input);
        if (dialog.open() != 0) return null;
        String path = dialog.getAbsolutePath();
        File file = new File(path);
        if (file.exists()) return dialog.getFullPath();
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.title, (String)Messages.includeConfirmCreate)) {
            return null;
        }
        FileOutputStream stream = null;
        try {
            String string;
            URI includeURI;
            IProject project;
            URI workspaceURI;
            URI relativeURI;
            Path filePath = new Path(path);
            IFile ifile = ConfigUIUtils.getFile(input);
            if (ifile != null && ifile.getProject() != null && !(relativeURI = URIUtil.canonicalRelativize((URI)(workspaceURI = (project = ifile.getProject()).getLocation().toFile().toURI()), (URI)(includeURI = filePath.toFile().toURI()))).isAbsolute()) {
                IFile newFile = project.getFile((IPath)new Path(relativeURI.getPath()));
                this.createFile(newFile);
                String string2 = dialog.getFullPath();
                return string2;
            }
            IPath dirPath = filePath.removeLastSegments(1);
            File dir = new File(dirPath.toOSString());
            if (!dir.exists() && !dir.mkdirs()) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Failed to create directories for include file: " + path, null);
                }
                MessageDialog.openError((Shell)shell, (String)Messages.includeCreateFailedTitle, (String)NLS.bind((String)Messages.includeCreateDirsFailedMsg, (Object)path));
                string = null;
                return string;
            }
            if (!file.createNewFile()) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Failed to create include file: " + path, null);
                }
                MessageDialog.openError((Shell)shell, (String)Messages.includeCreateFailedTitle, (String)NLS.bind((String)Messages.includeCreateFileFailedMsg, (Object)path));
                string = null;
                return string;
            }
            stream = new FileOutputStream(file);
            stream.write("<server>\n    \n</server>".getBytes());
            return dialog.getFullPath();
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Failed to create include file: " + path, e);
            }
            MessageDialog.openError((Shell)shell, (String)Messages.includeCreateFailedTitle, (String)e.getLocalizedMessage());
            String string = null;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createFile(IFile file) throws Exception {
        if (!file.exists()) {
            ByteArrayInputStream stream = new ByteArrayInputStream("<server>\n    \n</server>".getBytes());
            this.createContainer(file.getParent());
            file.create((InputStream)stream, 0, null);
        }
    }

    private void createContainer(IContainer container) throws CoreException {
        if (container != null && !container.exists() && container instanceof IFolder) {
            IFolder folder = (IFolder)container;
            this.createContainer(folder.getParent());
            folder.create(0, true, null);
        }
    }
}

