/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.RuntimeExplorer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.server.core.IRuntime;

public class RefreshAction
extends SelectionProviderAction {
    private Object objectToRefresh;
    private final StructuredViewer viewer;

    public RefreshAction(ISelectionProvider selectionProvider, StructuredViewer viewer) {
        super(selectionProvider, Messages.actionRefresh);
        this.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.setImageDescriptor(Activator.getImageDescriptor("refresh"));
        this.viewer = viewer;
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        for (Object obj : sel) {
            if (obj instanceof IRuntime) {
                this.objectToRefresh = obj;
                continue;
            }
            if (obj instanceof WebSphereRuntime) {
                this.objectToRefresh = obj;
                continue;
            }
            if (obj instanceof UserDirectory) {
                UserDirectory userDir = (UserDirectory)obj;
                this.objectToRefresh = userDir.getWebSphereRuntime().getRuntime();
                continue;
            }
            if (obj instanceof RuntimeExplorer.Node) {
                RuntimeExplorer.Node node = (RuntimeExplorer.Node)obj;
                this.objectToRefresh = node.getWebSphereRuntime();
                continue;
            }
            if (obj instanceof WebSphereServerInfo) {
                WebSphereServerInfo server = (WebSphereServerInfo)obj;
                this.objectToRefresh = server.getWebSphereRuntime();
                continue;
            }
            if (obj instanceof ConfigurationFolder) {
                ConfigurationFolder folder = (ConfigurationFolder)obj;
                this.objectToRefresh = folder.getUserDirectory().getWebSphereRuntime();
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void run() {
        IRuntime runtime;
        if (this.objectToRefresh == null) {
            return;
        }
        if (this.objectToRefresh instanceof IRuntime) {
            runtime = (IRuntime)this.objectToRefresh;
            WebSphereRuntime wasRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
            wasRuntime.refresh();
        }
        if (this.objectToRefresh instanceof WebSphereRuntime) {
            runtime = (WebSphereRuntime)this.objectToRefresh;
            runtime.refresh();
        }
        this.viewer.refresh(this.objectToRefresh);
    }
}

