/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.DDETreeContentProvider;
import com.ibm.ws.st.ui.internal.Messages;
import java.net.URI;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.w3c.dom.Element;

public class OpenMergedConfigAction
extends SelectionProviderAction {
    private URI uri;

    public OpenMergedConfigAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.actionOpenMergedConfiguration);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof ConfigurationFile) {
                ConfigurationFile configFile = (ConfigurationFile)obj;
                this.uri = configFile.getURI();
                enabled = true;
                continue;
            }
            if (obj instanceof Element) {
                Element element = (Element)obj;
                this.uri = DDETreeContentProvider.getURI(element);
                enabled = true;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (this.uri == null) {
            return;
        }
        Activator.openMergedConfiguration(this.uri);
    }
}

