/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ContentAssistCombo
extends Composite {
    private static final int MAX_ITEMS = 6;
    protected final Object NO_SUGGESTIONS = new Object();
    protected ContentProvider contentProvider;
    protected boolean updating = false;
    protected Text textBox;
    protected Label label;

    public ContentAssistCombo(Composite parent, ContentProvider contentProvider) {
        super(parent, 0);
        this.contentProvider = contentProvider;
        this.createControl();
    }

    public ContentAssistCombo(Composite parent, List<String> list) {
        super(parent, 0);
        this.contentProvider = new SimpleContentProvider(list);
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        final Composite textComposite = new Composite((Composite)this, 2048);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        textComposite.setFont(this.getFont());
        this.textBox = new Text(textComposite, 0);
        this.textBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this.label = new Label(textComposite, 0);
        this.label.setBackground(this.textBox.getBackground());
        this.label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.label.setImage(Activator.getImage("menuDown"));
        final Shell popupShell = new Shell(this.getShell(), 16384);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        popupShell.setLayout((Layout)layout);
        final Table suggestionTable = new Table((Composite)popupShell, 65540);
        suggestionTable.setLayoutData((Object)new GridData(4, 4, true, true));
        suggestionTable.setHeaderVisible(false);
        new TableColumn(suggestionTable, 0);
        this.textBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ContentAssistCombo.this.updating) {
                    return;
                }
                if (ContentAssistCombo.this.textBox.getText().isEmpty()) {
                    popupShell.setVisible(false);
                } else {
                    ContentAssistCombo.this.fillSuggestionTable(suggestionTable, false);
                    if (suggestionTable.getItemCount() > 0) {
                        ContentAssistCombo.this.showSuggestions(popupShell, suggestionTable, textComposite);
                    } else {
                        popupShell.setVisible(false);
                    }
                }
            }
        });
        this.textBox.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (!popupShell.isVisible()) {
                    return;
                }
                switch (event.keyCode) {
                    case 0x1000002: {
                        int index = (suggestionTable.getSelectionIndex() + 1) % suggestionTable.getItemCount();
                        suggestionTable.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        int index = suggestionTable.getSelectionIndex() - 1;
                        index = index < 0 ? suggestionTable.getItemCount() - 1 : index;
                        suggestionTable.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 27: {
                        popupShell.setVisible(false);
                        break;
                    }
                }
            }
        });
        this.textBox.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (popupShell.isVisible()) {
                    popupShell.setVisible(false);
                }
            }
        });
        this.textBox.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    ContentAssistCombo.this.updating = true;
                    if (popupShell.isVisible() && suggestionTable.getSelectionIndex() != -1) {
                        TableItem item = suggestionTable.getItem(suggestionTable.getSelectionIndex());
                        if (!ContentAssistCombo.this.NO_SUGGESTIONS.equals(item.getData())) {
                            String text = suggestionTable.getItem(suggestionTable.getSelectionIndex()).getText();
                            ContentAssistCombo.this.textBox.setText(text);
                            ContentAssistCombo.this.textBox.setSelection(text.length());
                        }
                        popupShell.setVisible(false);
                        event.doit = false;
                    }
                    ContentAssistCombo.this.updating = false;
                }
            }
        });
        this.label.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (!ContentAssistCombo.this.label.isEnabled()) {
                    return;
                }
                if (popupShell.isVisible()) {
                    popupShell.setVisible(false);
                } else {
                    ContentAssistCombo.this.fillSuggestionTable(suggestionTable, true);
                    if (suggestionTable.getItemCount() == 0) {
                        TableItem item = new TableItem(suggestionTable, 0);
                        item.setText(Messages.contentAssistEmpty);
                        item.setData(ContentAssistCombo.this.NO_SUGGESTIONS);
                    }
                    ContentAssistCombo.this.showSuggestions(popupShell, suggestionTable, textComposite);
                    popupShell.setFocus();
                }
            }
        });
        suggestionTable.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                ContentAssistCombo.this.updating = true;
                if (suggestionTable.getSelectionIndex() != -1) {
                    TableItem item = suggestionTable.getItem(suggestionTable.getSelectionIndex());
                    if (!ContentAssistCombo.this.NO_SUGGESTIONS.equals(item.getData())) {
                        String text = item.getText();
                        ContentAssistCombo.this.textBox.setText(text);
                        ContentAssistCombo.this.textBox.setSelection(text.length());
                    }
                    popupShell.setVisible(false);
                }
                ContentAssistCombo.this.updating = false;
            }
        });
        suggestionTable.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 27) {
                    popupShell.setVisible(false);
                }
            }
        });
        suggestionTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                Point p = event.gc.stringExtent(item.getText());
                event.width = p.x;
                event.height = p.y;
            }
        });
        suggestionTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        suggestionTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String s = item.getText();
                GC gc = event.gc;
                int x = event.x;
                int y = event.y;
                Point match = ContentAssistCombo.this.find(s, 0);
                Color bg = null;
                if (match != null) {
                    bg = gc.getBackground();
                    gc.setBackground(gc.getDevice().getSystemColor(26));
                }
                while (match != null) {
                    Point p1 = gc.stringExtent(s.substring(0, match.x));
                    Point p2 = gc.stringExtent(s.substring(0, match.y));
                    gc.setAlpha(16);
                    gc.setBackground(gc.getDevice().getSystemColor(26));
                    gc.fillRectangle(x + p1.x + 2, y + 2, p2.x - p1.x - 2, p2.y - 1);
                    gc.setAlpha(64);
                    gc.drawRoundRectangle(x + p1.x + 1, y + 1, p2.x - p1.x - 1, p2.y, 2, 2);
                    gc.setAlpha(255);
                    match = ContentAssistCombo.this.find(s, match.y);
                }
                if (bg != null) {
                    gc.setBackground(bg);
                }
                gc.drawString(s, x + 1, y + 1, true);
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                ContentAssistCombo.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ContentAssistCombo.this.getDisplay().isDisposed()) {
                            return;
                        }
                        Control control = ContentAssistCombo.this.getDisplay().getFocusControl();
                        if (control == null || control != suggestionTable && control != popupShell) {
                            popupShell.setVisible(false);
                        }
                    }
                });
            }
        };
        this.textBox.addListener(16, focusOutListener);
        this.label.addListener(16, focusOutListener);
        suggestionTable.addListener(16, focusOutListener);
        this.getShell().addListener(10, new Listener(){

            public void handleEvent(Event event) {
                popupShell.setVisible(false);
            }
        });
    }

    protected void fillSuggestionTable(Table table, boolean includeHistory) {
        table.removeAll();
        String[] entries = this.contentProvider.getSuggestions(this.textBox.getText(), includeHistory);
        if (entries == null) {
            return;
        }
        for (String entry : entries) {
            TableItem item = new TableItem(table, 0);
            item.setText(entry);
        }
        if (table.getItemCount() > 0) {
            table.select(0);
        }
    }

    protected void showSuggestions(Shell popupShell, Table suggestionTable, Composite textComposite) {
        Point location = this.toDisplay(textComposite.getLocation());
        Point size = textComposite.getSize();
        if ((popupShell.getStyle() & 0x8000000) != 0) {
            popupShell.setLocation(location.x - size.x, location.y + size.y);
        } else {
            popupShell.setLocation(location.x, location.y + size.y);
        }
        int height = suggestionTable.getItemHeight() * Math.min(6, suggestionTable.getItemCount()) + popupShell.getBorderWidth() * 2;
        popupShell.setSize(size.x, height);
        suggestionTable.getColumn(0).setWidth(suggestionTable.getClientArea().width);
        popupShell.setVisible(true);
    }

    public void addModifyListener(ModifyListener listener) {
        this.textBox.addModifyListener(listener);
    }

    public void setText(String text) {
        this.updating = true;
        this.textBox.setText(text);
        this.textBox.setSelection(text.length());
        this.updating = false;
    }

    public void setTextAndSuggest(String text) {
        this.textBox.setText(text);
        this.textBox.setFocus();
        this.textBox.setSelection(this.textBox.getText().length());
    }

    public String getText() {
        return this.textBox.getText();
    }

    public void setEnabled(boolean enabled) {
        this.textBox.setEnabled(enabled);
        this.label.setEnabled(enabled);
    }

    public boolean matches(String text) {
        return this.find(text, 0) != null;
    }

    protected Point find(String text, int start) {
        String segment;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        int end = text.length();
        if (start < 0 || start >= end) {
            return null;
        }
        int matchStart = -1;
        String filter = this.textBox.getText();
        int ind = filter.indexOf("*");
        int posText = start;
        for (int posFilter = 0; posFilter < filter.length(); posFilter += segment.length() + 1) {
            segment = null;
            ind = filter.indexOf("*", posFilter);
            segment = ind >= 0 ? filter.substring(posFilter, ind) : filter.substring(posFilter);
            if (segment.length() <= 0) continue;
            int nextMatch = ContentAssistCombo.findSegment(text, posText, segment);
            if (nextMatch < 0) {
                return null;
            }
            if (matchStart == -1) {
                matchStart = nextMatch;
            }
            posText = nextMatch + segment.length();
        }
        if (matchStart < 0) {
            return null;
        }
        return new Point(matchStart, posText);
    }

    private static int findSegment(String text, int start, String segment) {
        int max = text.length() - segment.length();
        for (int i = start; i <= max; ++i) {
            if (!ContentAssistCombo.regionMatches(text, i, segment, 0)) continue;
            return i;
        }
        return -1;
    }

    private static boolean regionMatches(String a, int aStart, String b, int bStart) {
        int len = b.length();
        for (int i = 0; i < len; ++i) {
            char aChar = a.charAt(aStart + i);
            char bChar = b.charAt(bStart + i);
            if (aChar == bChar || Character.toLowerCase(aChar) == Character.toLowerCase(bChar) || bChar == '?' || aChar == '/' && bChar == '\\' || aChar == '\\' && bChar == '/') continue;
            return false;
        }
        return true;
    }

    public static abstract class ContentProvider {
        public String[] getSuggestions(String hint, boolean showAll) {
            return null;
        }
    }

    private class SimpleContentProvider
    extends ContentProvider {
        private final List<String> list;

        public SimpleContentProvider(List<String> list) {
            this.list = list;
        }

        @Override
        public String[] getSuggestions(String hint, boolean showAll) {
            ArrayList<String> suggestions = new ArrayList<String>();
            for (String s : this.list) {
                if (!showAll && !ContentAssistCombo.this.matches(s)) continue;
                suggestions.add(s);
            }
            return suggestions.toArray(new String[suggestions.size()]);
        }
    }
}

