/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;

public class StreamMonitor
implements IStreamMonitor {
    private final List<IStreamListener> listeners = new ArrayList<IStreamListener>(2);
    private final StringBuffer sb = new StringBuffer();
    private static final String AUDIT = "[AUDIT   ]";
    private static final String ERROR = "[ERROR   ]";
    private static final String WARNING = "[WARNING ]";
    private static final String Err = "[err]";
    private boolean useConsoleLog = true;
    private boolean printMessage = false;

    public StreamMonitor(boolean useConsoleLog) {
        this.useConsoleLog = useConsoleLog;
    }

    public void addListener(IStreamListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    protected void streamAppended(String s) {
        String r = null;
        if (this.useConsoleLog) {
            r = s;
        } else {
            int i = s.indexOf(93);
            if (s.startsWith("[") && i > 0) {
                this.printMessage = true;
                char c = s.charAt(i + 72);
                switch (c) {
                    case 'A': {
                        r = AUDIT + s.substring(i + 73);
                        break;
                    }
                    case 'E': {
                        r = ERROR + s.substring(i + 73);
                        break;
                    }
                    case 'W': {
                        r = WARNING + s.substring(i + 73);
                        break;
                    }
                    case 'O': {
                        r = s.substring(i + 73);
                        break;
                    }
                    case 'R': {
                        r = Err + s.substring(i + 73);
                        break;
                    }
                    default: {
                        this.printMessage = false;
                        return;
                    }
                }
            } else if (this.printMessage) {
                r = s;
            }
        }
        if (r != null) {
            this.sb.append(r);
            for (IStreamListener l : this.listeners) {
                l.streamAppended(r, (IStreamMonitor)this);
            }
        }
    }

    public String getContents() {
        return this.sb.toString();
    }

    public void removeListener(IStreamListener listener) {
        this.listeners.remove(listener);
    }
}

