/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationResult;

public abstract class AbstractTextFileParser {
    private static final char NL = '\n';
    private static final char CR = '\r';
    private final char[] buf = new char[256];
    private int num = -1;
    private int ind = 0;
    protected int line = 1;
    protected int charCount = -2;
    protected char nextChar;
    private final Reader r;
    protected final IFile file;

    public AbstractTextFileParser(IFile file) throws CoreException, UnsupportedEncodingException {
        this.file = file;
        this.r = new InputStreamReader(file.getContents(), file.getCharset());
    }

    protected static boolean isEOLChar(char c) {
        return '\n' == c || '\r' == c;
    }

    protected void readEOL() throws IOException {
        char c = this.nextChar;
        this.readChar();
        if (AbstractTextFileParser.isEOLChar(this.nextChar) && c != this.nextChar) {
            this.readChar();
        }
        ++this.line;
    }

    protected void readChar() throws IOException {
        ++this.charCount;
        if (this.ind >= this.num) {
            this.num = this.r.read(this.buf);
            if (this.num < 0) {
                throw new EOFException();
            }
            this.ind = 0;
        }
        this.nextChar = this.buf[this.ind++];
    }

    protected abstract void parseImpl(ValidationResult var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ValidationResult valResult, IProgressMonitor monitor) throws IOException {
        try {
            this.parseImpl(valResult);
        }
        catch (EOFException eOFException) {
        }
        finally {
            this.close();
        }
    }

    private void close() {
        try {
            this.r.close();
        }
        catch (Exception e) {
            Trace.logError("Error validating file", e);
        }
    }
}

