/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.RuntimeFeatureResolver;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigVarsUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.FeatureList;
import com.ibm.ws.st.core.internal.config.IncludeConflictResolution;
import com.ibm.ws.st.core.internal.config.LocalConfigVars;
import com.ibm.ws.st.core.internal.config.SchemaUtil;
import com.ibm.ws.st.core.internal.config.validation.CustomServerVariablesManager;
import com.ibm.ws.st.core.internal.config.validation.DOMValidationContext;
import com.ibm.ws.st.core.internal.config.validation.Matcher;
import com.ibm.ws.st.core.internal.config.validation.ValidationContext;
import com.ibm.ws.st.core.internal.config.validation.ValidationFilterMatcher;
import com.ibm.ws.st.core.internal.expression.Expression;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConfigurationValidator {
    public static final String QUICK_FIX_TYPE_ATTR = "quickFixTypeAttr";
    public static final String XPATH_ATTR = "xpathAttr";
    public static final String BEST_MATCH = "bestMatch";
    public static final String ELEMENT_NODE_NAME = "elementNodeName";
    public static final String ATTRIBUTE_NODE_NAME = "attributeNodeName";
    public static final String REFERENCE_NAME = "referenceName";
    public static final String REFERENCE_OFFSET = "referenceOffset";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String APP_SECURITY_ENABLED = "appSecurityEnabled";
    private static final String ORIG_NODE = "origNode";
    private static final String NODE_CONTEXT = "nodeContext";
    private WebSphereRuntime wsRuntime = null;
    private final HashMap<URI, ValidationContext> includes = new HashMap();
    private ValidationContext topLevelContext;
    private ValidationContext currentContext;
    private DocumentBuilder documentBuilder = null;
    private ConfigVars globalVars;
    private Map<String, Set<String>> ids;
    private final ConfigVars.ResolvedValueInfo resolvedInfo = new ConfigVars.ResolvedValueInfo();
    private ValidationFilterMatcher ignoreMatcher;
    private final QuickFixData quickFixData = new QuickFixData();
    private final Matcher matcher = new Matcher();
    private final List<String> attributes = new ArrayList<String>(4);
    private Map<String, Element> featureMap;
    private List<String> features;
    private RuntimeFeatureResolver.ResolverResult resolverResult;

    public void validate(ConfigurationFile configFile) {
        this.validate(ValidationContext.createValidationContext(configFile, null, null));
    }

    public void validate(IResource resource) {
        this.validate(ValidationContext.createValidationContext(resource, null, null));
    }

    public void validate(Document document, IResource resource) {
        this.validate(ValidationContext.createValidationContext(document, resource, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(ValidationContext context) {
        try {
            this.topLevelContext = context;
            URI uri = context.getURI();
            WebSphereServerInfo serverInfo = null;
            UserDirectory userDir = null;
            if (uri != null) {
                serverInfo = ConfigUtils.getServerInfo(uri);
                if (serverInfo != null) {
                    userDir = serverInfo.getUserDirectory();
                    this.wsRuntime = serverInfo.getWebSphereRuntime();
                } else {
                    userDir = ConfigUtils.getUserDirectory(uri);
                    this.wsRuntime = userDir != null ? userDir.getWebSphereRuntime() : WebSphereUtil.getTargetedRuntime(uri);
                }
            }
            this.processVariables(this.topLevelContext, serverInfo, userDir);
            this.processIds(this.topLevelContext);
            this.initIgnoreMatcher(this.topLevelContext);
            this.checkRemoteServerSecurePort(this.topLevelContext, serverInfo);
            this.featureMap = DOMUtils.getFeatureElementMap(context.getDocument(), context.getURI(), context.getServer(), context.getUserDirectory());
            this.features = new ArrayList<String>(this.featureMap.keySet());
            this.resolverResult = RuntimeFeatureResolver.resolve(this.wsRuntime, this.features);
            this.includes.put(this.topLevelContext.getURI(), this.topLevelContext);
            Document mergeDoc = this.createTmpDoc();
            this.processDocument(this.topLevelContext, mergeDoc);
            Element root = mergeDoc.getDocumentElement();
            if (root != null) {
                NodeList nodes = root.getElementsByTagName("featureManager");
                HashSet<String> features = new HashSet<String>(3);
                Element featureManager = null;
                if (nodes.getLength() > 0) {
                    featureManager = (Element)nodes.item(0);
                    Element elem = DOMUtils.getFirstChildElement(featureManager, "feature");
                    while (elem != null) {
                        String feature = DOMUtils.getTextContent(elem);
                        if (FeatureList.isEnabledBy("ssl-1.0", feature, this.wsRuntime)) {
                            features.add("ssl");
                        }
                        if (FeatureList.isEnabledBy("appSecurity-1.0", feature, this.wsRuntime)) {
                            features.add("appSecurity");
                        }
                        if (FeatureList.isEnabledBy("ejbRemote-3.2", feature, this.wsRuntime)) {
                            features.add("ejbRemote");
                        }
                        if (features.size() == 3) break;
                        elem = DOMUtils.getNextElement(elem, "feature");
                    }
                }
                if (features.size() == 3 || features.contains("ssl")) {
                    boolean hasNonDefaultSSL = false;
                    nodes = root.getElementsByTagName("sslDefault");
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element defaultSSLElement = (Element)nodes.item(i);
                        String sslRef = defaultSSLElement.getAttribute("sslRef");
                        if (sslRef == null || sslRef.isEmpty() || sslRef.equals("defaultSSLConfig")) continue;
                        hasNonDefaultSSL = true;
                        break;
                    }
                    if (!hasNonDefaultSSL) {
                        boolean hasNonDefaultKeystore = false;
                        nodes = root.getElementsByTagName("ssl");
                        for (int i = 0; i < nodes.getLength(); ++i) {
                            String keystoreRef;
                            Element sslElement = (Element)nodes.item(i);
                            String id = sslElement.getAttribute("id");
                            if (!"defaultSSLConfig".equals(id) || (keystoreRef = sslElement.getAttribute("keyStoreRef")) == null || keystoreRef.isEmpty() || keystoreRef.equals("defaultKeyStore")) continue;
                            hasNonDefaultKeystore = true;
                            break;
                        }
                        if (!hasNonDefaultKeystore) {
                            boolean foundValidKeystore = false;
                            nodes = root.getElementsByTagName("keyStore");
                            for (int i = 0; i < nodes.getLength(); ++i) {
                                Element keystoreElem = (Element)nodes.item(i);
                                String id = keystoreElem.getAttribute("id");
                                String password = keystoreElem.getAttribute("password");
                                if (id != null && !id.isEmpty() && !id.equals("defaultKeyStore") || password == null || password.isEmpty()) continue;
                                foundValidKeystore = true;
                                break;
                            }
                            if (!foundValidKeystore) {
                                Node errorNode;
                                Level level = Level.WARNING;
                                if (features.size() == 3) {
                                    level = Level.ERROR;
                                }
                                Node node = errorNode = featureManager != null ? (Node)featureManager.getUserData(ORIG_NODE) : null;
                                if (errorNode == null) {
                                    errorNode = this.topLevelContext.getDocument().getDocumentElement();
                                }
                                String message = Messages.missingKeystore;
                                this.quickFixData.setValues(QuickFixType.SSL_NO_KEYSTORE, null, null, -1);
                                if (features.contains("appSecurity")) {
                                    message = Messages.missingKeystoreAndUR;
                                    this.quickFixData.setAttribute(APP_SECURITY_ENABLED, Boolean.TRUE);
                                }
                                this.createMessage(message, this.getTopLevelResource(), level, errorNode, this.quickFixData);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Error during validation for: " + context.getURI(), e);
        }
        finally {
            if (this.topLevelContext != null) {
                this.topLevelContext.dispose();
            }
        }
    }

    private void processVariables(ValidationContext context, WebSphereServerInfo server, UserDirectory userDir) {
        this.globalVars = new ConfigVars();
        if (server != null) {
            server.getVariables(this.globalVars);
        } else if (userDir != null) {
            userDir.getVariables(this.globalVars);
        }
        this.processCustomVars(this.globalVars, context.getResource().getProject());
        Document doc = context.getDocument();
        if (doc != null) {
            ConfigUtils.getVariables(context.getConfigFile(), doc, context.getURI(), server, context.getUserDirectory(), this.globalVars);
        }
    }

    private void processCustomVars(ConfigVars globalVars, IProject project) {
        if (project != null) {
            CustomServerVariablesManager customServerVariablesManager = CustomServerVariablesManager.getInstance();
            customServerVariablesManager.addCustomServerVariables(globalVars, project);
        }
    }

    private void processIds(ValidationContext context) {
        String[] dropInLibIds;
        this.ids = new HashMap<String, Set<String>>();
        if (context.getDocument() != null) {
            this.ids.putAll(DOMUtils.getAllIds(context.getDocument(), context.getURI(), context.getUserDirectory()));
        }
        if ((dropInLibIds = ConfigUtils.getDropInLibIds(context.getServer(), context.getUserDirectory())).length > 0) {
            Set<String> libSet = this.ids.get("library");
            if (libSet == null) {
                libSet = new HashSet<String>();
                this.ids.put("library", libSet);
            }
            for (String id : dropInLibIds) {
                libSet.add(id);
            }
        }
    }

    private void initIgnoreMatcher(ValidationContext context) {
        IResource resource = context.getResource();
        if (resource != null) {
            this.ignoreMatcher = new ValidationFilterMatcher(resource.getProject());
        } else {
            UserDirectory ud = context.getUserDirectory();
            if (ud != null) {
                this.ignoreMatcher = new ValidationFilterMatcher(ud.getProject());
            }
        }
    }

    private void processDocument(ValidationContext context, Document mergeDoc) {
        this.currentContext = context;
        Document doc = this.currentContext.getDocument();
        if (doc == null) {
            Trace.logError("Could not load DOM for: " + context.getURI(), null);
            return;
        }
        Element serverElem = doc.getDocumentElement();
        if (serverElem == null || !DOMUtils.isServerElement(serverElem)) {
            return;
        }
        this.processServer(serverElem, mergeDoc);
        this.currentContext = this.currentContext.getParent();
    }

    protected void processServer(Element serverElem, Document mergeDoc) {
        ValidationContext dropinContext;
        ConfigurationFile configFile;
        CMElementDeclaration serverDecl = SchemaUtil.getElement(this.topLevelContext.getDocument(), new String[]{"server"}, this.currentContext.getURI());
        if (serverDecl == null) {
            Trace.logError("Validation: could not get server element declaration for " + this.currentContext.getURI(), null);
            return;
        }
        Element mergeElem = mergeDoc.getDocumentElement();
        if (mergeElem == null) {
            Node clone = mergeDoc.importNode(serverElem, false);
            mergeDoc.appendChild(clone);
            this.initData(clone, serverElem);
            mergeElem = (Element)clone;
        }
        if ((configFile = this.currentContext.getConfigFile()) != null) {
            for (ConfigurationFile dropin : configFile.getDefaultDropins()) {
                dropinContext = ValidationContext.createValidationContext(dropin, this.currentContext, null);
                dropinContext.setDropin(true);
                this.processDocument(dropinContext, mergeDoc);
            }
        }
        Element element = DOMUtils.getFirstChildElement(serverElem);
        while (element != null) {
            this.processElement(element, mergeElem, serverDecl);
            element = DOMUtils.getNextElement(element);
        }
        if (configFile != null) {
            for (ConfigurationFile dropin : configFile.getOverrideDropins()) {
                dropinContext = ValidationContext.createValidationContext(dropin, this.currentContext, null);
                dropinContext.setDropin(true);
                this.processDocument(dropinContext, mergeDoc);
            }
        }
    }

    protected void processElement(Element element, Element mergeParent, CMElementDeclaration parentDecl) {
        String name = element.getNodeName();
        if (name.equals("include")) {
            this.processInclude(element, mergeParent.getOwnerDocument());
        } else if (name.equals("variable")) {
            this.processVariable(element, mergeParent, parentDecl);
        } else {
            this.processGeneralElement(element, mergeParent, parentDecl);
        }
    }

    private Document createTmpDoc() {
        Document doc = this.getDocumentBuilder().newDocument();
        return doc;
    }

    private DocumentBuilder getDocumentBuilder() {
        if (this.documentBuilder == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.documentBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInclude(Element element, Document mergeDoc) {
        String path = DOMUtils.getAttributeValue(element, "location");
        if (path != null && !path.isEmpty()) {
            String optional = DOMUtils.getAttributeValue(element, "optional");
            IncludeConflictResolution onConflict = IncludeConflictResolution.getConflictResolution(DOMUtils.getAttributeValue(element, "onConflict"));
            boolean isOptional = optional == null ? false : Boolean.parseBoolean(optional);
            this.currentContext.setCurrentInclude(element);
            ValidationContext newContext = null;
            ValidationContext mergedContext = null;
            try {
                IResource currentContextResource = this.currentContext.getResource();
                IFolder mappedConfigFolder = ConfigUtils.getMappedConfigFolder(currentContextResource);
                if (mappedConfigFolder != null) {
                    IResource includeFile = mappedConfigFolder.findMember(path);
                    if (includeFile != null && includeFile.exists()) {
                        newContext = ValidationContext.createValidationContext(includeFile, this.currentContext, IncludeConflictResolution.MERGE);
                    }
                } else {
                    newContext = ValidationContext.createValidationContext(path, this.currentContext.getURI(), this.currentContext.getUserDirectory(), this.currentContext, IncludeConflictResolution.MERGE);
                }
                if (newContext == null) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Failed to create validation context for include file " + path + ".");
                    }
                    if (this.isTopLevel()) {
                        this.createMessage(NLS.bind((String)Messages.errorLoadingInclude, (Object)path), this.currentContext.getResource(), isOptional ? Level.INFO : Level.ERROR, element);
                    }
                } else {
                    ValidationContext previousContext = this.includes.get(newContext.getURI());
                    if (previousContext != null) {
                        if (this.emitMessage(previousContext, this.currentContext)) {
                            String includePath = this.getFilePathString(newContext);
                            this.createMessage(NLS.bind((String)Messages.infoMultipleInclude, (Object)includePath), this.getTopLevelResource(), Level.INFO, this.getErrorNode(element));
                        }
                        return;
                    }
                    this.includes.put(newContext.getURI(), this.currentContext);
                    Document includeMergeDoc = this.createTmpDoc();
                    this.processDocument(newContext, includeMergeDoc);
                    mergedContext = new DOMValidationContext(includeMergeDoc, newContext.getResource(), newContext.getServer(), newContext.getUserDirectory(), newContext.getParent(), onConflict);
                    this.processDocument(mergedContext, mergeDoc);
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Failed to validate included file " + path + ".", e);
                }
                if (this.isTopLevel()) {
                    this.createMessage(NLS.bind((String)Messages.errorLoadingInclude, (Object)path), this.currentContext.getResource(), isOptional ? Level.INFO : Level.ERROR, element);
                }
            }
            finally {
                if (newContext != null) {
                    newContext.dispose();
                }
                if (mergedContext != null) {
                    mergedContext.dispose();
                }
                this.currentContext.setCurrentInclude(null);
            }
        }
    }

    private void processVariable(Element elem, Element mergeParent, CMElementDeclaration parentDecl) {
        Attr attr = elem.getAttributeNode("name");
        if (attr == null) {
            return;
        }
        String name = attr.getValue();
        if (ConfigVarsUtils.containsReference(name)) {
            if (this.isTopLevel()) {
                this.createMessage(NLS.bind((String)Messages.variableNameContainsRefs, (Object)name), this.currentContext.getResource(), Level.ERROR, attr);
            }
            name = this.globalVars.resolve(name);
        }
        Attr valueAttr = elem.getAttributeNode("value");
        Attr defaultValueAttr = elem.getAttributeNode("defaultValue");
        if (valueAttr != null && defaultValueAttr != null) {
            this.createMessage(NLS.bind((String)Messages.invalidVariableDecl, (Object)name), this.getTopLevelResource(), Level.ERROR, elem);
            return;
        }
        if (valueAttr == null && defaultValueAttr == null) {
            this.createMessage(NLS.bind((String)Messages.variableDeclNoValue, (Object)name), this.getTopLevelResource(), Level.ERROR, elem);
            return;
        }
        Element mergeElem = this.lookupElement("variable", "name", name, mergeParent);
        if (mergeElem == null) {
            mergeElem = mergeParent.getOwnerDocument().createElement(elem.getNodeName());
            this.initData(mergeElem, elem);
            mergeParent.appendChild(mergeElem);
        } else {
            ValidationContext mergeContext = (ValidationContext)mergeElem.getUserData(NODE_CONTEXT);
            IncludeConflictResolution resolution = this.currentContext.getConflictResolution();
            if (resolution == IncludeConflictResolution.IGNORE) {
                return;
            }
            if (resolution == IncludeConflictResolution.REPLACE) {
                Element oldElem = mergeElem;
                String oldElemName = oldElem.getNodeName() + "[" + name + "]";
                String replaceElemName = elem.getNodeName() + "[" + name + "]";
                DocumentLocation location = DocumentLocation.createDocumentLocation(this.currentContext.getURI(), elem);
                DocumentLocation mergeLocation = DocumentLocation.createDocumentLocation(mergeContext.getURI(), mergeElem);
                this.createMessage(NLS.bind((String)Messages.infoReplaceItem, (Object[])new String[]{replaceElemName, location.getLocationString(), oldElemName, mergeLocation.getLocationString()}), this.getTopLevelResource(), Level.INFO, this.getErrorNode(elem));
                mergeElem = mergeParent.getOwnerDocument().createElement(elem.getNodeName());
                this.initData(mergeElem, elem);
                mergeParent.replaceChild(mergeElem, oldElem);
            }
        }
        CMElementDeclaration elemDecl = SchemaUtil.getElement(parentDecl, elem.getNodeName());
        if (elemDecl == null) {
            if (Trace.ENABLED) {
                Trace.logError("Validator: could not get schema declaration for variable element", null);
            }
            return;
        }
        this.processAttributes(elem, mergeElem, elemDecl);
    }

    private void checkRemoteServerSecurePort(ValidationContext validationContext, WebSphereServerInfo webSphereServerInfo) {
        String serverSecurePort;
        WebSphereServer webSphereServer;
        ConfigurationFile configFile = null;
        if (webSphereServerInfo != null && (configFile = webSphereServerInfo.getConfigRoot()) != null && configFile.getIFile().equals(this.getTopLevelResource()) && (webSphereServer = WebSphereUtil.getWebSphereServer(webSphereServerInfo)) != null && !webSphereServer.isLocalHost() && (serverSecurePort = webSphereServer.getServerSecurePort()) != null && !serverSecurePort.isEmpty()) {
            try {
                List<Integer> allSecurePorts = validationContext.getConfigFile().getAllPorts(true);
                if (!allSecurePorts.contains(new Integer(serverSecurePort))) {
                    String defaultSecurePort = Integer.toString(validationContext.getConfigFile().getHTTPSPort());
                    this.quickFixData.setValues(QuickFixType.REMOTE_SERVER_SECURE_PORT_MISMATCH, null, null, -1);
                    this.createMessage(NLS.bind((String)Messages.securePortMismatch, (Object[])new String[]{defaultSecurePort, serverSecurePort}), this.getTopLevelResource(), Level.ERROR, validationContext.getConfigFile().getDocument().getDocumentElement(), this.quickFixData);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void processGeneralElement(Element elem, Element mergeParent, CMElementDeclaration parentDecl) {
        CMElementDeclaration elemDecl = SchemaUtil.getElement(parentDecl, elem.getNodeName());
        this.checkElement(elem, elemDecl, parentDecl);
        if (elemDecl == null) {
            return;
        }
        CMDataType elemType = elemDecl.getDataType();
        if (elemType != null && ConfigVars.isAtomic(elemType)) {
            this.processAtomicElement(elem, mergeParent);
            return;
        }
        boolean hasId = elem.hasAttribute("id");
        boolean singletonNested = !this.isTopLevelElem(elem) && this.isSingleton(elemDecl, parentDecl);
        Node mergeElem = null;
        if (!singletonNested) {
            if (hasId) {
                mergeElem = this.lookupElement(elem.getNodeName(), "id", elem.getAttribute("id"), mergeParent);
            } else {
                String attrType;
                CMAttributeDeclaration attrDecl = SchemaUtil.getAttr(elemDecl, "id");
                if (attrDecl != null && (attrType = ConfigUtils.getTypeName((CMNode)attrDecl)) != null) {
                    hasId = "factoryIdType".equals(attrType);
                }
                if (!hasId && "server".equals(parentDecl.getElementName())) {
                    mergeElem = this.lookupElement(elem.getNodeName(), mergeParent);
                }
            }
        }
        if (mergeElem == null) {
            mergeElem = mergeParent.getOwnerDocument().createElement(elem.getNodeName());
            this.initData(mergeElem, elem);
            mergeParent.appendChild(mergeElem);
        } else {
            ValidationContext mergeContext = (ValidationContext)mergeElem.getUserData(NODE_CONTEXT);
            IncludeConflictResolution resolution = this.currentContext.getConflictResolution();
            if (resolution == IncludeConflictResolution.IGNORE) {
                return;
            }
            if (resolution == IncludeConflictResolution.REPLACE) {
                Node oldElem = mergeElem;
                String oldElemName = oldElem.getNodeName();
                String replaceElemName = elem.getNodeName();
                if (hasId) {
                    oldElemName = oldElemName + "[" + oldElem.getAttribute("id") + "]";
                    replaceElemName = replaceElemName + "[" + elem.getAttribute("id") + "]";
                }
                DocumentLocation location = DocumentLocation.createDocumentLocation(this.currentContext.getURI(), elem);
                DocumentLocation mergeLocation = DocumentLocation.createDocumentLocation(mergeContext.getURI(), mergeElem);
                this.createMessage(NLS.bind((String)Messages.infoReplaceItem, (Object[])new String[]{replaceElemName, location.getLocationString(), oldElemName, mergeLocation.getLocationString()}), this.getTopLevelResource(), Level.INFO, this.getErrorNode(elem));
                mergeElem = mergeParent.getOwnerDocument().createElement(elem.getNodeName());
                this.initData(mergeElem, elem);
                mergeParent.replaceChild(mergeElem, oldElem);
            }
        }
        this.processAttributes(elem, (Element)mergeElem, elemDecl);
        Element child = DOMUtils.getFirstChildElement(elem);
        while (child != null) {
            this.processElement(child, (Element)mergeElem, elemDecl);
            child = DOMUtils.getNextElement(child);
        }
    }

    private boolean isSingleton(CMElementDeclaration elemDecl, CMElementDeclaration parentDecl) {
        int maxOccur;
        if (parentDecl.getContent() instanceof CMGroup && (maxOccur = parentDecl.getContent().getMaxOccur()) == -1) {
            return false;
        }
        maxOccur = elemDecl.getMaxOccur();
        return maxOccur == 1;
    }

    private void processAttributes(Element elem, Element mergeElem, CMElementDeclaration elemDecl) {
        NamedNodeMap attrs = elem.getAttributes();
        this.fillDeclaredAttributes(attrs);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            this.processAttribute((Attr)attr, mergeElem, elemDecl, this.attributes);
        }
    }

    private void fillDeclaredAttributes(NamedNodeMap attrs) {
        this.attributes.clear();
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.attributes.add(attrs.item(i).getNodeName());
        }
    }

    private void processAtomicElement(Element elem, Element mergeParent) {
        if ("featureManager".equals(mergeParent.getNodeName()) && "feature".equals(elem.getNodeName())) {
            this.processFeature(elem, mergeParent);
            return;
        }
        String content = DOMUtils.getTextContent(elem);
        NodeList children = mergeParent.getElementsByTagName(elem.getNodeName());
        Element mergeNode = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            String text = DOMUtils.getTextContent(child);
            if (text == null || !text.equals(content)) continue;
            ValidationContext mergeContext = (ValidationContext)child.getUserData(NODE_CONTEXT);
            mergeNode = child;
            if (this.emitMessage(mergeContext, this.currentContext)) {
                if (this.currentContext.isDropin()) {
                    DocumentLocation location = DocumentLocation.createDocumentLocation(this.currentContext.getURI(), elem);
                    String line = location.getLine() != -1 ? String.valueOf(location.getLine()) : Messages.unknownMsg;
                    Node errorNode = (Node)mergeNode.getUserData(ORIG_NODE);
                    if (errorNode == null) {
                        errorNode = this.topLevelContext.getDocument().getDocumentElement();
                    }
                    this.createMessage(NLS.bind((String)Messages.infoDuplicateItemDropin, (Object[])new String[]{elem.getNodeName(), text, location.getLocationString(), line}), this.getTopLevelResource(), Level.INFO, errorNode);
                } else {
                    this.createMessage(NLS.bind((String)Messages.infoDuplicateItem, (Object[])new String[]{elem.getNodeName(), text}), this.getTopLevelResource(), Level.INFO, this.getErrorNode(elem));
                }
            }
            this.setNodeData(mergeNode, elem);
        }
        if (mergeNode == null) {
            Node clone = mergeParent.getOwnerDocument().importNode(elem, true);
            mergeParent.appendChild(clone);
            this.initData(clone, elem);
        }
    }

    private void processAttribute(Attr attr, Element mergeParent, CMElementDeclaration parentDecl, List<String> declaredAttributes) {
        String name = attr.getNodeName();
        String value = this.checkAttribute(attr, mergeParent, parentDecl, declaredAttributes);
        Attr mergeAttr = mergeParent.getAttributeNode(name);
        if (mergeAttr == null) {
            mergeParent.setAttribute(name, value);
            mergeAttr = mergeParent.getAttributeNode(name);
        } else if (!value.equals(mergeAttr.getNodeValue())) {
            ValidationContext previousContext = (ValidationContext)mergeAttr.getUserData(NODE_CONTEXT);
            if (this.emitMessage(previousContext, this.currentContext)) {
                if (this.currentContext.isDropin()) {
                    DocumentLocation location = DocumentLocation.createDocumentLocation(this.currentContext.getURI(), attr);
                    String line = location.getLine() != -1 ? String.valueOf(location.getLine()) : Messages.unknownMsg;
                    Node errorNode = (Node)mergeAttr.getUserData(ORIG_NODE);
                    if (errorNode == null) {
                        errorNode = this.topLevelContext.getDocument().getDocumentElement();
                    }
                    this.createMessage(NLS.bind((String)Messages.infoOverrideItemDropin, (Object[])new String[]{name, mergeParent.getNodeName(), mergeAttr.getNodeValue(), value, location.getLocationString(), line}), this.getTopLevelResource(), Level.INFO, errorNode);
                } else {
                    this.createMessage(NLS.bind((String)Messages.infoOverrideItem, (Object[])new String[]{name, mergeParent.getNodeName(), mergeAttr.getNodeValue(), value}), this.getTopLevelResource(), Level.INFO, this.getErrorNode(attr));
                }
            }
            mergeAttr.setNodeValue(value);
        }
        this.setNodeData(mergeAttr, attr);
    }

    private Element lookupElement(String name, Element parent) {
        return DOMUtils.getFirstChildElement(parent, name);
    }

    private Element lookupElement(String name, String idAttr, String id, Element parent) {
        Element elem = DOMUtils.getFirstChildElement(parent, name);
        while (elem != null) {
            if (id.equals(elem.getAttribute(idAttr))) {
                return elem;
            }
            elem = DOMUtils.getNextElement(elem, name);
        }
        return null;
    }

    private void processFeature(Element elem, Element mergeParent) {
        String content = DOMUtils.getTextContent(elem);
        String canonicalName = FeatureList.getCanonicalFeatureName(content, this.wsRuntime);
        if (this.isTopLevel()) {
            if (canonicalName != null) {
                if (FeatureList.isFeatureSuperseded(canonicalName, this.wsRuntime)) {
                    this.quickFixData.setValues(QuickFixType.SUPERSEDED_FEATURE, content, null, -1);
                    this.createMessage(NLS.bind((String)Messages.supersededFeature, (Object)content), this.getTopLevelResource(), Level.WARNING, elem, this.quickFixData);
                }
            } else {
                String bestMatch = this.matcher.getBestMatch(FeatureList.getFeatures(false, this.wsRuntime), content, null);
                if (bestMatch != null) {
                    this.quickFixData.setValues(QuickFixType.UNRECOGNIZED_FEATURE, bestMatch, null, -1);
                    this.createMessage(NLS.bind((String)Messages.unrecognizedFeature, (Object)content), this.getTopLevelResource(), Level.WARNING, elem, this.quickFixData);
                } else {
                    this.createMessage(NLS.bind((String)Messages.unrecognizedFeature, (Object)content), this.getTopLevelResource(), Level.WARNING, elem);
                }
            }
        }
        if (canonicalName != null) {
            NodeList children = mergeParent.getElementsByTagName(elem.getNodeName());
            Element mergeNode = null;
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                String text = DOMUtils.getTextContent(child);
                if (text == null || !text.equalsIgnoreCase(content)) continue;
                mergeNode = child;
                ValidationContext mergeContext = (ValidationContext)child.getUserData(NODE_CONTEXT);
                if (mergeContext != null && this.isTopLevel(mergeContext) && this.isTopLevel(this.currentContext)) {
                    this.createMessage(NLS.bind((String)Messages.infoDuplicateItem, (Object[])new String[]{elem.getNodeName(), content}), this.getTopLevelResource(), Level.INFO, this.getErrorNode(elem));
                }
                this.setNodeData(child, elem);
                mergeNode = child;
            }
            if (mergeNode == null) {
                Node clone = mergeParent.getOwnerDocument().importNode(elem, true);
                mergeParent.appendChild(clone);
                this.initData(clone, elem);
            }
            this.checkFeatureConflicts(canonicalName, elem);
        }
    }

    private void checkFeatureConflicts(String featureName, Element elem) {
        Element element = null;
        Set<RuntimeFeatureResolver.FeatureConflict> featureConflicts = this.resolverResult.getFeatureConflicts();
        String featureSymbolicName = FeatureList.getFeatureSymbolicName(featureName, this.wsRuntime);
        if (featureSymbolicName != null) {
            HashSet<RuntimeFeatureResolver.FeatureConflict> tmpConflictSet = new HashSet<RuntimeFeatureResolver.FeatureConflict>(featureConflicts);
            for (RuntimeFeatureResolver.FeatureConflict featureConflict : tmpConflictSet) {
                if (!featureSymbolicName.equals(featureConflict.getDependencyChainA().get(0)) && !featureSymbolicName.equals(featureConflict.getDependencyChainB().get(0))) continue;
                String featureName1 = FeatureList.getPublicFeatureName(featureConflict.getConfiguredFeatureA(), this.wsRuntime);
                String featureName2 = FeatureList.getPublicFeatureName(featureConflict.getConfiguredFeatureB(), this.wsRuntime);
                List<String> dependancyChainA = featureConflict.getDependencyChainA();
                List<String> dependancyChainB = featureConflict.getDependencyChainB();
                if (!featureName1.equalsIgnoreCase(featureName)) {
                    featureName2 = featureName1;
                    dependancyChainA = featureConflict.getDependencyChainB();
                    dependancyChainB = featureConflict.getDependencyChainA();
                }
                String conflictALoc = this.currentContext.getURI().getPath();
                URI conflictBURI = this.getFeatureElementLoc(featureName2);
                String conflictBLoc = null;
                if (conflictBURI != null) {
                    conflictBLoc = conflictBURI.getPath();
                }
                if (conflictALoc == null || conflictBLoc == null) {
                    return;
                }
                this.quickFixData.setValues(QuickFixType.FEATURE_CONFLICT, featureSymbolicName, null, -1);
                if (this.currentContext.getParent() == null && conflictALoc.equals(conflictBLoc)) {
                    this.createMessage(NLS.bind((String)Messages.featureConflict, (Object)RuntimeFeatureResolver.getDependencyChainString(dependancyChainA, this.wsRuntime), (Object)RuntimeFeatureResolver.getDependencyChainString(dependancyChainB, this.wsRuntime)), this.getTopLevelResource(), Level.WARNING, elem, this.quickFixData);
                } else {
                    if (this.currentContext.getParent() != null && conflictALoc.equals(conflictBLoc)) {
                        return;
                    }
                    ValidationContext commonParent = this.getCommonParent(this.currentContext, featureName2);
                    if (commonParent != this.topLevelContext) {
                        return;
                    }
                    element = this.currentContext.getParent() != null ? commonParent.getCurrentInclude() : elem;
                    DocumentLocation location = DocumentLocation.createDocumentLocation(this.currentContext.getURI(), elem);
                    DocumentLocation configLocation = DocumentLocation.createDocumentLocation(conflictBURI, elem);
                    if (this.currentContext.isDropin() && element == null) {
                        Element ele = commonParent.getDocument().getDocumentElement();
                        this.createMessage(NLS.bind((String)Messages.featureConflictWithLoc, (Object[])new String[]{RuntimeFeatureResolver.getDependencyChainString(dependancyChainA, this.wsRuntime), RuntimeFeatureResolver.getDependencyChainString(dependancyChainB, this.wsRuntime), location.getLocationString(), configLocation.getLocationString()}), commonParent.getResource(), Level.WARNING, ele, this.quickFixData);
                    } else {
                        this.createMessage(NLS.bind((String)Messages.featureConflictWithLoc, (Object[])new String[]{RuntimeFeatureResolver.getDependencyChainString(dependancyChainA, this.wsRuntime), RuntimeFeatureResolver.getDependencyChainString(dependancyChainB, this.wsRuntime), location.getLocationString(), configLocation.getLocationString()}), commonParent.getResource(), Level.WARNING, element, this.quickFixData);
                    }
                }
                featureConflicts.remove(featureConflict);
                break;
            }
        }
    }

    private URI getFeatureElementLoc(String featureName) {
        ConfigurationFile[] includes;
        DocumentLocation location;
        Element elem = this.featureMap.get(featureName);
        if (elem != null && (location = (DocumentLocation)elem.getUserData("documentLocationKey")) != null) {
            return location.getURI();
        }
        ConfigurationFile server = this.topLevelContext.getConfigFile();
        if (server == null) {
            return null;
        }
        if (server.hasFeature(featureName)) {
            return server.getURI();
        }
        for (ConfigurationFile file : includes = server.getAllIncludedFiles()) {
            if (!file.hasFeature(featureName)) continue;
            return file.getURI();
        }
        return null;
    }

    private boolean hasFeature(ConfigurationFile file, String featureName) {
        ConfigurationFile[] includes;
        if (file.hasFeature(featureName)) {
            return true;
        }
        for (ConfigurationFile fyl : includes = file.getAllIncludedFiles()) {
            if (!fyl.hasFeature(featureName)) continue;
            return true;
        }
        return false;
    }

    private ValidationContext getCommonParent(ValidationContext context, String featureName) {
        ValidationContext toplevl = context;
        ConfigurationFile configFile = toplevl.getConfigFile();
        while (configFile != null && !this.hasFeature(configFile, featureName)) {
            toplevl = toplevl.getParent();
            configFile = toplevl.getConfigFile();
        }
        return toplevl;
    }

    private void checkElement(Element elem, CMElementDeclaration elemDecl, CMElementDeclaration parentDecl) {
        if (!this.isTopLevel()) {
            return;
        }
        if (elemDecl == null) {
            String bestMatch = this.getBestElementNameMatch(elem, parentDecl);
            if (bestMatch != null) {
                this.quickFixData.setValues(QuickFixType.UNRECOGNIZED_ELEMENT, bestMatch, null, -1);
                this.createMessage(NLS.bind((String)Messages.unrecognizedElement, (Object[])new String[]{elem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, elem, this.quickFixData);
            }
        } else {
            List<String> containingFeatures;
            Node parent = elem.getParentNode();
            if (parent != null && "server".equals(parent.getNodeName()) && (containingFeatures = ConfigUtils.getFeaturesToEnable(elem.getNodeName(), this.features, this.wsRuntime)) != null && !containingFeatures.isEmpty()) {
                StringBuilder possibleFeatures = new StringBuilder();
                for (String feature : containingFeatures) {
                    if (possibleFeatures.length() > 0) {
                        possibleFeatures.append(",");
                    }
                    possibleFeatures.append(feature);
                }
                this.quickFixData.setValues(QuickFixType.UNAVAILABLE_ELEMENT, possibleFeatures.toString(), null, -1);
                this.createMessage(NLS.bind((String)Messages.unavailableElement, (Object[])new String[]{elem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, elem, this.quickFixData);
            }
        }
    }

    private String getBestElementNameMatch(Element elem, CMElementDeclaration parentDecl) {
        if (parentDecl == null) {
            return null;
        }
        return this.matcher.getBestMatch(parentDecl.getLocalElements(), elem.getNodeName(), null);
    }

    private String checkAttribute(Attr attr, Element mergeElem, CMElementDeclaration elemDecl, List<String> declaredAttributes) {
        String value = attr.getNodeValue();
        CMAttributeDeclaration attrDecl = SchemaUtil.getAttr(elemDecl, attr.getNodeName());
        String type = attrDecl != null ? ConfigUtils.getTypeName((CMNode)attrDecl) : null;
        boolean hasVarRef = ConfigVarsUtils.containsReference(value);
        ConfigVars vars = this.globalVars;
        if (hasVarRef) {
            vars = new LocalConfigVars(this.globalVars);
            ConfigUtils.getLocalVariables(attr.getOwnerElement(), attr.getName(), this.currentContext.getURI(), vars);
        }
        vars.resolve(value, this.resolvedInfo, type);
        String resolvedValue = this.resolvedInfo.getResolvedValue();
        if (this.isTopLevel()) {
            XSDSimpleTypeDefinition simpleTypeDef;
            XSDTypeDefinition typeDef;
            String[] references;
            if (attrDecl == null) {
                String elemName = mergeElem.getNodeName();
                String attrName = attr.getNodeName();
                if (this.ignoreMatcher == null || !this.ignoreMatcher.isIgnoreAttribute(this.getTopLevelResource(), elemName, attrName)) {
                    boolean hasExtraProperties = SchemaUtil.hasExtraProperties((CMNode)elemDecl);
                    String bestMatch = this.getBestPropertyNameMatch(attr, elemDecl, declaredAttributes);
                    if (hasExtraProperties) {
                        if (bestMatch != null) {
                            this.quickFixData.setValues(QuickFixType.UNRECOGNIZED_PROPERTY, bestMatch, null, -1);
                            this.createMessage(NLS.bind((String)Messages.unrecognizedProperty, (Object[])new String[]{attrName, elemName}), this.getTopLevelResource(), Level.INFO, attr, this.quickFixData);
                        }
                    } else {
                        this.quickFixData.setValues(QuickFixType.UNRECOGNIZED_PROPERTY, bestMatch, null, -1);
                        this.createMessage(NLS.bind((String)Messages.unrecognizedProperty, (Object[])new String[]{attrName, elemName}), this.getTopLevelResource(), Level.WARNING, attr, this.quickFixData);
                    }
                }
                return resolvedValue;
            }
            if (resolvedValue.isEmpty() && attrDecl.getUsage() == 2) {
                this.createMessage(NLS.bind((String)Messages.emptyRequiredAttribute, (Object[])new String[]{attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr);
            }
            if (("password".equals(type) || "passwordHash".equals(type)) && !value.isEmpty()) {
                int code = ConfigUtils.validatePassword(value, type, this.wsRuntime);
                if (code == 1) {
                    this.quickFixData.setValues(QuickFixType.PLAIN_TEXT_PASSWORD, null, null, -1);
                    this.createMessage(Messages.warningPlainTextPassword, this.getTopLevelResource(), Level.WARNING, attr, this.quickFixData);
                } else if (code == 2) {
                    this.createMessage(Messages.warningAESEncryptedPasswordNotSupported, this.getTopLevelResource(), Level.WARNING, attr);
                } else if (code == 3) {
                    this.createMessage(Messages.warningHashEncodedPasswordNotSupported, this.getTopLevelResource(), Level.WARNING, attr);
                } else if (code == 4 && ConfigUtils.getEncryptionAlgorithm(value) != null) {
                    this.createMessage(NLS.bind((String)Messages.warningCustomEncryptedPasswordNotSupported, (Object)ConfigUtils.getEncryptionAlgorithm(value)), this.getTopLevelResource(), Level.WARNING, attr);
                }
            }
            if (ConfigVars.getTypeSet(type) == ConfigVars.REFERENCE_TYPES && (references = SchemaUtil.getReferences((CMNode)attrDecl)).length > 0) {
                ConfigVars.UndefinedReference[] idSet = new HashSet();
                for (String reference : references) {
                    Set<String> set = this.ids.get(reference);
                    if (set == null) continue;
                    idSet.addAll(set);
                }
                String[] items = value.split("[, ]+");
                HashSet<String> itemSet = new HashSet<String>();
                for (int i = 0; i < items.length; ++i) {
                    String item = items[i];
                    String varName = ConfigVarsUtils.getVariableName(item);
                    if (varName != null) {
                        String[] varItems;
                        String varValue = vars.getValue(varName);
                        if (varValue == null) continue;
                        for (String varItem : varItems = varValue.split("[, ]+")) {
                            this.checkFactoryRef(varItem, (Set<String>)idSet, references, itemSet, false, attr, i);
                            itemSet.add(varItem);
                        }
                        continue;
                    }
                    this.checkFactoryRef(item, (Set<String>)idSet, references, itemSet, true, attr, i);
                    itemSet.add(item);
                }
                if ("pidType".equals(type) && !value.isEmpty()) {
                    for (String reference : references) {
                        NodeList nested = attr.getOwnerElement().getElementsByTagName(reference);
                        if (nested == null || nested.getLength() <= 0) continue;
                        this.createMessage(NLS.bind((String)Messages.singlePidRefAndNested, (Object[])new String[]{mergeElem.getNodeName(), attr.getNodeName(), reference}), this.getTopLevelResource(), Level.WARNING, attr);
                        break;
                    }
                }
            }
            if (!this.resolvedInfo.isFullyResolved()) {
                ConfigVars.UndefinedReference[] refs;
                for (ConfigVars.UndefinedReference ref : refs = this.resolvedInfo.getUndefinedReferences()) {
                    if (vars.isPredefinedVar(ref.getReferenceName())) continue;
                    String bestMatch = this.matcher.getBestMatch(vars, ref.getReferenceName(), type);
                    this.quickFixData.setValues(QuickFixType.UNDEFINED_VARIABLE, bestMatch, ref.getReferenceName(), ref.getReferenceOffset());
                    this.createMessage(NLS.bind((String)Messages.unresolvedPropertyValue, (Object[])new String[]{attr.getNodeName(), mergeElem.getNodeName(), ref.getReferenceName()}), this.getTopLevelResource(), Level.WARNING, attr, this.quickFixData);
                }
            }
            ConfigVars.ExpressionOperandError expressionLeftOperandError = this.resolvedInfo.getExpressionLeftOperandError();
            ConfigVars.ExpressionOperandError expressionRightOperandError = this.resolvedInfo.getExpressionRightOperandError();
            if (this.resolvedInfo.isInvalidExpression()) {
                this.createMessage(NLS.bind((String)Messages.invalidVariableExpression, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName(), vars.getTypeName(type)}), this.getTopLevelResource(), Level.WARNING, attr);
            } else if (expressionLeftOperandError != null || expressionRightOperandError != null) {
                if (expressionLeftOperandError != null) {
                    switch (this.resolvedInfo.getExpressionLeftOperandError()) {
                        case MISSING: {
                            this.createMessage(NLS.bind((String)Messages.expressionMissingLeftOperand, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr);
                            break;
                        }
                        case UNDEFINED: {
                            Expression expression = new Expression(value);
                            String leftOperand = expression.getLeftOperand();
                            int index = 0;
                            if (leftOperand.startsWith("${")) {
                                index = 2;
                                leftOperand = leftOperand.substring(2);
                            }
                            if (vars.isPredefinedVar(leftOperand)) break;
                            String bestMatch = this.matcher.getBestMatch(vars, leftOperand, type);
                            this.quickFixData.setValues(QuickFixType.UNDEFINED_VARIABLE, bestMatch, leftOperand, index);
                            this.createMessage(NLS.bind((String)Messages.expressionUndefinedLeftOperand, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr, this.quickFixData);
                            break;
                        }
                        case INVALID_VALUE: {
                            this.createMessage(NLS.bind((String)Messages.expressionInvalidLeftOperand, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr);
                        }
                    }
                }
                if (expressionRightOperandError != null) {
                    switch (this.resolvedInfo.getExpressionRightOperandError()) {
                        case MISSING: {
                            this.createMessage(NLS.bind((String)Messages.expressionMissingRightOperand, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr);
                            break;
                        }
                        case UNDEFINED: {
                            Expression expression = new Expression(value);
                            String rightOperand = expression.getRightOperand();
                            if (rightOperand.endsWith("}")) {
                                rightOperand = rightOperand.substring(0, rightOperand.length() - 1);
                            }
                            if (vars.isPredefinedVar(rightOperand)) break;
                            String bestMatch = this.matcher.getBestMatch(vars, rightOperand, type);
                            int index = value.indexOf(expression.getOperator().getSymbol()) + 1;
                            this.quickFixData.setValues(QuickFixType.UNDEFINED_VARIABLE, bestMatch, rightOperand, index);
                            this.createMessage(NLS.bind((String)Messages.expressionUndefinedRightOperand, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr, this.quickFixData);
                            break;
                        }
                        case INVALID_VALUE: {
                            this.createMessage(NLS.bind((String)Messages.expressionInvalidRightOperand, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr);
                        }
                    }
                }
            } else if (this.resolvedInfo.isTypeMismatch()) {
                this.createMessage(NLS.bind((String)Messages.incorrectVariableReferenceType, (Object[])new String[]{value, attr.getNodeName(), mergeElem.getNodeName(), vars.getTypeName(type)}), this.getTopLevelResource(), Level.WARNING, attr);
            } else if (this.resolvedInfo.isFullyResolved() && ConfigVars.getTypeSet(type) == ConfigVars.DURATION_TYPES) {
                try {
                    Long.valueOf(resolvedValue);
                }
                catch (NumberFormatException e) {
                    if (!ConfigVars.isDurationType(resolvedValue)) {
                        this.createMessage(NLS.bind((String)Messages.invalidValue, (Object[])new String[]{resolvedValue, attr.getNodeName(), mergeElem.getNodeName(), vars.getTypeName(type)}), this.getTopLevelResource(), Level.WARNING, attr);
                    }
                }
            } else if (this.resolvedInfo.isFullyResolved() && hasVarRef && (typeDef = SchemaUtil.getTypeDefinitionFromSchema((CMNode)attrDecl)) instanceof XSDSimpleTypeDefinition && !(simpleTypeDef = (XSDSimpleTypeDefinition)typeDef).isValidLiteral(resolvedValue)) {
                this.createMessage(NLS.bind((String)Messages.invalidValueNoType, (Object[])new String[]{resolvedValue, attr.getNodeName(), mergeElem.getNodeName()}), this.getTopLevelResource(), Level.WARNING, attr);
            }
        }
        return resolvedValue;
    }

    private void checkFactoryRef(String id, Set<String> idSet, String[] references, Set<String> itemSet, boolean doQuickFix, Node node, int index) {
        if (idSet == null || !idSet.contains(id)) {
            String bestMatch = null;
            if (doQuickFix && idSet != null) {
                bestMatch = this.matcher.getBestMatch(idSet, id, null);
            }
            String messageKey = references.length > 1 ? Messages.factoryIdNotFoundMulti : Messages.factoryIdNotFound;
            String message = NLS.bind((String)messageKey, (Object[])new String[]{this.formatList(references), id});
            if (bestMatch != null) {
                this.quickFixData.setValues(QuickFixType.FACTORY_ID_NOT_FOUND, bestMatch, id, index);
                this.createMessage(message, this.getTopLevelResource(), Level.WARNING, node, this.quickFixData);
            } else {
                this.createMessage(message, this.getTopLevelResource(), Level.WARNING, node);
            }
        }
        if (itemSet.contains(id)) {
            if (doQuickFix) {
                this.quickFixData.setValues(QuickFixType.DUPLICATE_FACTORY_ID, null, id, index);
                this.createMessage(NLS.bind((String)Messages.duplicateFactoryId, (Object)id), this.getTopLevelResource(), Level.WARNING, node, this.quickFixData);
            } else {
                this.createMessage(NLS.bind((String)Messages.duplicateFactoryId, (Object)id), this.getTopLevelResource(), Level.WARNING, node);
            }
        }
    }

    private String formatList(String[] list) {
        StringBuilder builder = new StringBuilder();
        for (String str : list) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(str);
        }
        return builder.toString();
    }

    private String getBestPropertyNameMatch(Node attr, CMElementDeclaration parentDecl, List<String> declaredAttributes) {
        if (parentDecl == null) {
            return null;
        }
        return this.matcher.getBestMatch(parentDecl.getAttributes(), attr.getNodeName(), declaredAttributes);
    }

    private boolean isTopLevel() {
        return this.currentContext.getParent() == null;
    }

    private boolean isTopLevel(ValidationContext context) {
        return context.getParent() == null;
    }

    private boolean isTopLevelElem(Element elem) {
        Node node = elem.getParentNode();
        return node == null || "server".equals(node.getNodeName());
    }

    private void initData(Node mergeNode, Node node) {
        if (this.isTopLevel()) {
            mergeNode.setUserData(ORIG_NODE, node, null);
        }
        mergeNode.setUserData(NODE_CONTEXT, this.currentContext, null);
    }

    private void setNodeData(Node mergeNode, Node node) {
        if (this.isTopLevel()) {
            mergeNode.setUserData(ORIG_NODE, node, null);
        } else {
            mergeNode.setUserData(ORIG_NODE, null, null);
        }
        mergeNode.setUserData(NODE_CONTEXT, this.currentContext, null);
    }

    private boolean emitMessage(ValidationContext previous, ValidationContext current) {
        if (previous == null) {
            Trace.logError("Previous context is null.", null);
            return true;
        }
        if (this.isTopLevel(previous) || this.isTopLevel(current)) {
            return true;
        }
        if (previous == current) {
            return false;
        }
        ValidationContext firstInclude = this.getTopLevelInclude(previous);
        ValidationContext secondInclude = this.getTopLevelInclude(current);
        return firstInclude == null || secondInclude == null || firstInclude != secondInclude;
    }

    private ValidationContext getTopLevelInclude(ValidationContext context) {
        ValidationContext firstInclude = null;
        for (ValidationContext parent = context; parent != null; parent = parent.getParent()) {
            if (parent.getParent() == null) continue;
            firstInclude = parent;
        }
        return firstInclude;
    }

    private Node getErrorNode(Node node) {
        if (this.isTopLevel()) {
            return node;
        }
        return this.topLevelContext.getCurrentInclude();
    }

    private IResource getTopLevelResource() {
        return this.topLevelContext.getResource();
    }

    protected String getTopLevelLocation() {
        URI uri = this.topLevelContext.getURI();
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    private String getFilePathString(ValidationContext context) {
        URI uri;
        IResource resource = context.getResource();
        String path = resource != null ? resource.getFullPath().toString() : ((uri = context.getURI()).getScheme().equals("file") ? new Path(uri.getPath()).toOSString() : uri.toString());
        return path;
    }

    protected void createMessage(String text, IResource resource, Level level, Node node) {
        this.quickFixData.setValues(QuickFixType.NONE, null, null, -1);
        this.createMessage(text, resource, level, node, this.quickFixData);
    }

    protected abstract void createMessage(String var1, IResource var2, Level var3, Node var4, QuickFixData var5);

    public static class QuickFixData {
        private QuickFixType fixType;
        private String bestMatch;
        private String undefinedReferenceName;
        private int undefinedReferenceOffset;
        private final HashMap<String, Object> attributes = new HashMap();

        protected void setValues(QuickFixType type, String match, String refName, int refOffset) {
            this.fixType = type;
            this.bestMatch = match;
            this.undefinedReferenceName = refName;
            this.undefinedReferenceOffset = refOffset;
            this.attributes.clear();
        }

        public QuickFixType getFixType() {
            return this.fixType;
        }

        public String getBestMatch() {
            return this.bestMatch;
        }

        public String getUndefinedReferenceName() {
            return this.undefinedReferenceName;
        }

        public int getUndefinedReferenceOffset() {
            return this.undefinedReferenceOffset;
        }

        public void setAttribute(String attr, Object value) {
            this.attributes.put(attr, value);
        }

        public HashMap<String, Object> getAttributes() {
            return this.attributes;
        }
    }

    protected static enum Level {
        INFO,
        WARNING,
        ERROR;

    }

    public static enum QuickFixType {
        NONE,
        PLAIN_TEXT_PASSWORD,
        UNRECOGNIZED_ELEMENT,
        UNAVAILABLE_ELEMENT,
        UNRECOGNIZED_PROPERTY,
        UNDEFINED_VARIABLE,
        UNRECOGNIZED_FEATURE,
        OUT_OF_SYNC_APP,
        OUT_OF_SYNC_SHARED_LIB_REF_MISMATCH,
        FACTORY_ID_NOT_FOUND,
        DUPLICATE_FACTORY_ID,
        INVALID_WHITESPACE,
        SUPERSEDED_FEATURE,
        FEATURE_CONFLICT,
        SSL_NO_KEYSTORE,
        REMOTE_SERVER_SECURE_PORT_MISMATCH;

    }
}

