/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.config.DOMUtils;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SchemaHelper {
    private HashMap<String, Boolean> supportedApplicationElements;
    private final URL schemaURL;
    private Document document = null;

    public SchemaHelper(URL schemaURL) {
        this.schemaURL = schemaURL;
    }

    private Document getDocument() {
        block7: {
            if (this.document == null && this.schemaURL != null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    this.document = db.parse(this.schemaURL.openStream());
                }
                catch (ParserConfigurationException e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Could not parse the schema.", e);
                    }
                }
                catch (SAXException e) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Could not parse the schema.", e);
                    }
                }
                catch (IOException e) {
                    if (!Trace.ENABLED) break block7;
                    Trace.trace((byte)1, "Could not parse the schema.", e);
                }
            }
        }
        return this.document;
    }

    public boolean isSupportedApplicationElement(String appElementName) {
        if (this.supportedApplicationElements != null) {
            Boolean b = this.supportedApplicationElements.get(appElementName);
            if (b != null) {
                return b;
            }
        } else {
            this.supportedApplicationElements = new HashMap();
        }
        boolean b = false;
        Document doc = this.getDocument();
        if (doc != null) {
            StringBuilder sb = new StringBuilder("/xsd:schema/xsd:complexType[@name='serverType']/xsd:choice/xsd:element[@name='");
            sb = sb.append(appElementName);
            Node node = DOMUtils.getSchemaNode(doc, (sb = sb.append("']")).toString());
            b = node != null;
            this.supportedApplicationElements.put(appElementName, b);
        }
        return b;
    }
}

