/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.IConfigurationElement;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;

public class ConfigurationFolder
implements IConfigurationElement {
    private final IPath path;
    private final IFolder folder;
    private final UserDirectory userDir;
    private List<IConfigurationElement> children;

    public ConfigurationFolder(UserDirectory userDir, IPath path, IFolder folder) {
        this.userDir = userDir;
        this.path = path;
        this.folder = folder;
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public UserDirectory getUserDirectory() {
        return this.userDir;
    }

    public synchronized IConfigurationElement[] getChildren() {
        this.refresh(false);
        return this.children.toArray(new IConfigurationElement[this.children.size()]);
    }

    public synchronized boolean refresh(boolean force) {
        IConfigurationElement existing;
        if (this.children == null) {
            this.children = new ArrayList<IConfigurationElement>();
        }
        boolean changed = false;
        ArrayList<ConfigurationFolder> found = new ArrayList<ConfigurationFolder>();
        File[] files = this.path.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files != null) {
            for (File f : files) {
                existing = null;
                String name = f.getName();
                for (IConfigurationElement element : this.children) {
                    if (!(element instanceof ConfigurationFolder) || !element.getName().equals(name)) continue;
                    existing = (ConfigurationFolder)element;
                }
                if (existing != null && force && existing.refresh(true)) {
                    changed = true;
                }
                if (existing == null) {
                    IFolder childFolder = null;
                    if (this.folder != null) {
                        childFolder = this.folder.getFolder(name);
                    }
                    existing = new ConfigurationFolder(this.userDir, this.path.append(name), childFolder);
                    this.children.add(existing);
                    changed = true;
                }
                found.add((ConfigurationFolder)existing);
            }
        }
        if (files != null) {
            for (File f : files = this.path.toFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith("xml");
                }
            })) {
                existing = null;
                for (IConfigurationElement element : this.children) {
                    if (!(element instanceof ConfigurationFile) || !element.getName().equals(f.getName())) continue;
                    existing = (ConfigurationFile)element;
                }
                if (existing != null && ((ConfigurationFile)existing).hasChanged()) {
                    existing = null;
                }
                if (existing == null) {
                    try {
                        existing = new ConfigurationFile(f.toURI(), this.userDir);
                        this.children.add(existing);
                    }
                    catch (IOException e) {
                        Trace.logError("Error reading configuration file:" + f.toURI(), e);
                    }
                    changed = true;
                }
                if (existing == null) continue;
                found.add((ConfigurationFolder)existing);
            }
        }
        ArrayList<IConfigurationElement> delete = new ArrayList<IConfigurationElement>(2);
        for (IConfigurationElement element : this.children) {
            if (found.contains(element)) continue;
            delete.add(element);
            changed = true;
        }
        for (IConfigurationElement element : delete) {
            this.children.remove(element);
        }
        return changed;
    }

    public String toString() {
        return "Configuration Folder [" + this.getPath() + "]";
    }
}

