/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config;

import com.ibm.ws.st.core.internal.expression.Expression;

public class ConfigVarsUtils {
    public static String getVarRef(String varName) {
        return "${" + varName + "}";
    }

    public static boolean containsReference(String value) {
        int start = value.indexOf("${");
        int end = value.indexOf("}");
        return start >= 0 && end > start;
    }

    public static String getVariableName(String text, int startOffset, int endOffset) {
        int varStart = -1;
        int varEnd = -1;
        int index = text.indexOf("${");
        while (index >= 0 && index <= startOffset) {
            varStart = index;
            if ((index = text.indexOf("}", index)) != -1) {
                varEnd = index;
            } else {
                index = varEnd = text.length() - 1;
            }
            if (startOffset >= varStart && endOffset <= varEnd) {
                String value = text.substring(varStart + 2, varEnd);
                for (Expression.Operator operator : Expression.Operator.values()) {
                    int operatorIndex = value.indexOf(operator.getSymbol());
                    if (operatorIndex == -1) continue;
                    if (startOffset - varStart - 2 <= operatorIndex && endOffset - varStart - 2 <= operatorIndex) {
                        value = value.substring(0, operatorIndex);
                    } else if (startOffset - varStart - 2 > operatorIndex && endOffset - varStart - 2 > operatorIndex) {
                        value = value.substring(operatorIndex + 1);
                    }
                    try {
                        Long.parseLong(value);
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return value;
            }
            index = text.indexOf("${", index);
            if (startOffset != endOffset || startOffset != varEnd + 1 || index != -1 && startOffset >= index) continue;
            return text.substring(varStart + 2, varEnd);
        }
        return null;
    }

    public static String getVariableName(String text) {
        if (text.startsWith("${") && text.endsWith("}")) {
            return text.substring(2, text.length() - 1);
        }
        return null;
    }
}

