/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

class WebSphereRuntimeClasspathHelper {
    private Map<String, Set<String>> featuresPerJar = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> featuresWithConflicts = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> conflictedJarsPerFeature = new HashMap<String, Set<String>>();
    private Map<String, SortedSet<String>> featureByNameAndVersions = new HashMap<String, SortedSet<String>>();
    private final WebSphereRuntime runtime;
    private final String runtimeName;

    public WebSphereRuntimeClasspathHelper(WebSphereRuntime runtime) {
        this.runtime = runtime;
        this.runtimeName = runtime.getRuntime() == null ? "Unknown" : runtime.getRuntime().getName();
    }

    private void findFeaturesPerJar() {
        this.featuresPerJar = new HashMap<String, Set<String>>();
        List<String> features = FeatureList.getFeatures(false, this.runtime);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Found " + features.size() + " features in runtime " + this.runtimeName + ".");
        }
        for (String feature : features) {
            Set<String> jars = FeatureList.getFeatureAPIJars(feature, this.runtime);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Feature: " + feature + ". Jars: " + jars);
            }
            for (String jar : jars) {
                if (!this.featuresPerJar.containsKey(jar)) {
                    HashSet<String> featuresToAdd = new HashSet<String>();
                    featuresToAdd.add(feature);
                    this.featuresPerJar.put(jar, featuresToAdd);
                    continue;
                }
                this.featuresPerJar.get(jar).add(feature);
            }
        }
    }

    private void findFeatureVersions() {
        this.featureByNameAndVersions = new HashMap<String, SortedSet<String>>();
        List<String> features = FeatureList.getFeatures(false, this.runtime);
        for (String feature : features) {
            String name = FeatureUtil.getName(feature);
            if (!this.featureByNameAndVersions.containsKey(name)) {
                TreeSet<String> versions = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String featureA, String featureB) {
                        String[] splitB;
                        int indexA = featureA.lastIndexOf("-");
                        int indexB = featureB.lastIndexOf("-");
                        if (indexA == -1 && indexB == -1) {
                            return 0;
                        }
                        if (indexA == -1) {
                            return -1;
                        }
                        if (indexB == -1) {
                            return 1;
                        }
                        String versionA = featureA.substring(indexA + 1);
                        String versionB = featureB.substring(indexB + 1);
                        String[] splitA = versionA.split("\\.");
                        int comparisonLimit = splitA.length < (splitB = versionB.split("\\.")).length ? splitA.length : splitB.length;
                        for (int i = 0; i < comparisonLimit; ++i) {
                            int valB;
                            int valA = Integer.valueOf(splitA[i]);
                            if (valA > (valB = Integer.valueOf(splitB[i]).intValue())) {
                                return 1;
                            }
                            if (valA >= valB) continue;
                            return -1;
                        }
                        if (versionA.length() > versionB.length()) {
                            return 1;
                        }
                        if (versionA.length() < versionB.length()) {
                            return -1;
                        }
                        return 0;
                    }
                });
                versions.add(feature);
                this.featureByNameAndVersions.put(name, versions);
                continue;
            }
            this.featureByNameAndVersions.get(name).add(feature);
        }
    }

    private Set<String> getJarsInFeatureAndConflicts(String feature) {
        Set<String> jars = FeatureList.getFeatureAPIJars(feature, this.runtime);
        HashSet<String> jarsInConflictingFeaturesOnly = new HashSet<String>();
        for (String jar : jars) {
            Set<String> featuresUsingJar = this.featuresPerJar.get(jar);
            if (featuresUsingJar == null || featuresUsingJar.size() <= 0) continue;
            jarsInConflictingFeaturesOnly.add(jar);
        }
        return jarsInConflictingFeaturesOnly;
    }

    private void findConflictedJarsPerFeature() {
        this.conflictedJarsPerFeature = new HashMap<String, Set<String>>();
        for (String featureWithConflict : this.featuresWithConflicts.keySet()) {
            Set<String> jars1 = this.getJarsInFeatureAndConflicts(featureWithConflict);
            HashSet<String> jarsTotal = new HashSet<String>();
            for (String feature : this.featuresWithConflicts.get(featureWithConflict)) {
                Set<String> tmp = this.getJarsInFeatureAndConflicts(feature);
                tmp.removeAll(jars1);
                jarsTotal.addAll(tmp);
            }
            this.conflictedJarsPerFeature.put(featureWithConflict, jarsTotal);
        }
    }

    private void findFeaturesWithConflicts() {
        this.featuresWithConflicts = new HashMap<String, Set<String>>();
        Map<String, List<FeatureName>> features = FeatureList.getFeatures(false, this.runtime).stream().map(FeatureName::new).collect(Collectors.groupingBy(f -> f.prefix));
        this.addConflictingFeatures(features, "servlet");
        this.addConflictingFeatures(features, "jpa");
        this.addConflictingFeatures(features, "ejbLite", "mdb", "enterpriseBeansLite");
        this.addConflictingFeatures(features, "jaxrs", "jaxrsClient", "restfulWS", "restfulWSClient");
        this.addConflictingFeatures(features, "beanValidation");
        this.addConflictingFeatures(features, "cdi");
        this.addConflictingFeatures(features, "jsf", "faces");
        this.addConflictingFeatures(features, "jsp", "pages");
    }

    private void addConflictingFeatures(Map<String, List<FeatureName>> featuresByPrefix, String ... conflictingPrefixes) {
        List conflictingNames = Arrays.stream(conflictingPrefixes).map(featuresByPrefix::get).filter(Objects::nonNull).flatMap(l -> l.stream()).collect(Collectors.toList());
        for (FeatureName name : conflictingNames) {
            Set conflictsWith = conflictingNames.stream().filter(f -> !f.version.equals(name.version)).map(f -> f.fullname).collect(Collectors.toSet());
            this.featuresWithConflicts.put(name.fullname, conflictsWith);
        }
    }

    public synchronized void refresh() {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Entering WebSphereRuntimeClasspathHelper:refresh() for runtime " + this.runtimeName);
        }
        long start = System.currentTimeMillis();
        this.findFeatureVersions();
        this.findFeaturesPerJar();
        this.findFeaturesWithConflicts();
        this.findConflictedJarsPerFeature();
        if (Trace.ENABLED) {
            Trace.tracePerf("Leaving WebSphereRuntimeClasspathHelper:refresh() for runtime " + this.runtimeName, start);
            Trace.trace((byte)0, "Features per Jar: " + this.featuresPerJar);
            Trace.trace((byte)0, "Features with conflicts: " + this.featuresWithConflicts);
            Trace.trace((byte)0, "Conflicted jars per features: " + this.conflictedJarsPerFeature);
        }
    }

    public Map<String, Set<String>> getFeaturesWithConflicts() {
        return this.featuresWithConflicts;
    }

    public Set<String> getConflictedJarsPerFeature(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException();
        }
        return this.conflictedJarsPerFeature.get(featureName);
    }

    public String getHighestVersion(String featureName) {
        SortedSet<String> versions = this.featureByNameAndVersions.get(featureName);
        if (versions != null) {
            return versions.last();
        }
        return null;
    }

    public Set<String> getApiJars(String featureName) {
        if (featureName == null) {
            throw new IllegalArgumentException();
        }
        return FeatureList.getFeatureAPIJars(featureName, this.runtime);
    }

    private static class FeatureName {
        final String fullname;
        final String prefix;
        final String version;

        public FeatureName(String name) {
            this.fullname = name;
            int separator = name.lastIndexOf("-");
            if (separator == -1) {
                this.prefix = name;
                this.version = "";
            } else {
                this.prefix = name.substring(0, separator);
                this.version = name.substring(separator + 1);
            }
        }

        public String toString() {
            return this.prefix + "-" + this.version;
        }
    }
}

