/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationFolder;
import com.ibm.ws.st.core.internal.config.IConfigurationElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class UserDirectory {
    private final WebSphereRuntime runtime;
    private final IPath userPath;
    protected IPath remoteUserPath;
    private final IProject userProject;
    private final IPath outputPath;
    private ConfigurationFolder sharedConfigFolder;
    private final ConfigVars configVars;

    public UserDirectory(WebSphereRuntime runtime, IPath userPath, IProject userProject, IPath outputPath) {
        this(runtime, userPath, userProject, outputPath, null);
    }

    public UserDirectory(WebSphereRuntime runtime, IPath userPath, IProject userProject) {
        this(runtime, userPath, userProject, null, null);
    }

    public UserDirectory(WebSphereRuntime runtime, IPath userPath, IProject userProject, IPath outputPath, IPath remoteUserPath) {
        if (runtime == null) {
            throw new IllegalArgumentException("Runtime cannot be null");
        }
        if (userPath == null) {
            throw new IllegalArgumentException("User path (WLP_USER_DIR) cannot be null");
        }
        this.runtime = runtime;
        this.userProject = userProject;
        this.remoteUserPath = remoteUserPath;
        String envPath = runtime.getRuntimeLocation() + "/etc/server.env";
        File envFile = new File(envPath);
        Properties envProps = new Properties();
        if (envFile.exists() && !envFile.isDirectory()) {
            try {
                envProps.load(new FileInputStream(envFile));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(envPath + " was found but could not be read");
            }
        } else {
            envProps = null;
        }
        String tempUserPath = null;
        if (envProps != null) {
            tempUserPath = envProps.getProperty("WLP_USER_DIR");
        }
        this.userPath = tempUserPath != null ? new Path(tempUserPath) : userPath;
        String tempOutputPath = null;
        if (envProps != null) {
            tempOutputPath = envProps.getProperty("WLP_OUTPUT_DIR");
        }
        this.outputPath = tempOutputPath != null ? new Path(tempOutputPath) : (outputPath == null ? userPath.append("servers") : outputPath);
        this.configVars = new ConfigVars();
        this.getVariables(this.configVars);
    }

    public WebSphereRuntime getWebSphereRuntime() {
        return this.runtime;
    }

    public IPath getPath() {
        return this.userPath;
    }

    public void setRemoteUserPath(IPath remoteUserPath) {
        this.remoteUserPath = remoteUserPath;
    }

    public IPath getRemoteUserPath() {
        return this.remoteUserPath;
    }

    public IProject getProject() {
        return this.userProject;
    }

    public IPath getOutputPath() {
        return this.outputPath;
    }

    public IPath getServersPath() {
        return this.userPath.append("servers");
    }

    public IPath getSharedPath() {
        return this.userPath.append("shared");
    }

    public IFolder getServersFolder() {
        if (this.userProject == null) {
            return null;
        }
        return this.userProject.getFolder("servers");
    }

    public IFolder getSharedFolder() {
        if (this.userProject == null) {
            return null;
        }
        return this.userProject.getFolder("shared");
    }

    public IFolder getSharedConfigFolder() {
        if (this.userProject == null) {
            return null;
        }
        return this.userProject.getFolder("shared").getFolder("config");
    }

    public IFolder getSharedAppsFolder() {
        if (this.userProject == null) {
            return null;
        }
        return this.userProject.getFolder("shared").getFolder("apps");
    }

    public IPath getSharedConfigPath() {
        return this.userPath.append("shared").append("config");
    }

    public IPath getSharedAppsPath() {
        return this.userPath.append("shared").append("apps");
    }

    public IPath getSharedResourcesPath() {
        return this.userPath.append("shared").append("resources");
    }

    public URI getSharedConfigURI() {
        return this.getSharedConfigPath().toFile().toURI();
    }

    public synchronized IConfigurationElement[] getSharedConfiguration() {
        if (this.sharedConfigFolder == null) {
            IPath path = this.getSharedConfigPath();
            if (path == null || !path.toFile().exists()) {
                return new ConfigurationFile[0];
            }
            this.sharedConfigFolder = new ConfigurationFolder(this, path, this.getSharedConfigFolder());
        }
        return this.sharedConfigFolder.getChildren();
    }

    protected synchronized boolean refreshSharedConfig() {
        if (this.sharedConfigFolder == null) {
            return false;
        }
        if (!this.sharedConfigFolder.getPath().equals((Object)this.getSharedConfigPath())) {
            this.sharedConfigFolder = null;
            this.getWebSphereRuntime().fireRefreshEvent();
            return true;
        }
        boolean changed = this.sharedConfigFolder.refresh(true);
        if (changed) {
            this.getWebSphereRuntime().fireRefreshEvent();
        }
        return changed;
    }

    public IStatus addSharedConfigFile(ConfigurationFolder folder, URL configURL) {
        String name = configURL.getFile();
        int last = name.lastIndexOf(47);
        if (last >= 0) {
            name = name.substring(last + 1);
        }
        IPath to = null;
        to = folder != null ? folder.getPath().append(name) : this.getSharedConfigPath().append(name);
        try {
            IStatus status = FileUtil.copy(configURL, to);
            if (status != null && !status.isOK()) {
                return status;
            }
        }
        catch (IOException e) {
            Trace.logError("Error adding shared config file: " + configURL, e);
            return new Status(4, "com.ibm.ws.st.core", Messages.errorAddingSharedConfig, (Throwable)e);
        }
        if (this.userProject != null) {
            try {
                this.getSharedConfigFolder().refreshLocal(2, null);
            }
            catch (CoreException ce) {
                Trace.logError("Couldn't refresh shared config folder: " + this.getSharedConfigFolder(), ce);
            }
        } else {
            this.refreshSharedConfig();
        }
        return Status.OK_STATUS;
    }

    public URI resolve(URI baseUri, String include) {
        if (include == null) {
            return null;
        }
        String resolvedInclude = this.configVars.resolve(include);
        File f = new File(resolvedInclude);
        if (f.isAbsolute()) {
            if (this.getRemoteUserPath() != null && f.toString().startsWith(this.remoteUserPath.toOSString())) {
                f = new File(f.toString().replace(this.remoteUserPath.toOSString(), this.userPath.toString()));
            }
            return f.toURI();
        }
        try {
            URI result = baseUri.resolve(resolvedInclude);
            return result;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (f.exists()) {
                return f.toURI();
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not resolve: " + include);
            }
            return null;
        }
    }

    public void getVariables(ConfigVars vars) {
        this.getVariables(vars, false);
    }

    public void getVariables(ConfigVars vars, boolean resolvedOnly) {
        vars.add("wlp.user.dir", this.getPath().toOSString(), ConfigVars.LOCATION_TYPE);
        vars.add("shared.app.dir", this.getSharedAppsPath().toOSString(), ConfigVars.LOCATION_TYPE);
        vars.add("shared.config.dir", this.getSharedConfigPath().toOSString(), ConfigVars.LOCATION_TYPE);
        vars.add("shared.resource.dir", this.getSharedResourcesPath().toOSString(), ConfigVars.LOCATION_TYPE);
        vars.add("usr.extension.dir", this.getPath().append("extension").toOSString(), ConfigVars.LOCATION_TYPE);
        if (!resolvedOnly) {
            this.runtime.getVariables(vars);
        }
    }

    public void addDropInLibPaths(List<IPath> paths) {
        paths.add(this.getSharedConfigPath().append("lib"));
    }

    public String getUniqueId() {
        IProject project = this.getProject();
        if (project != null) {
            return project.getName();
        }
        return this.getPath().toPortableString();
    }

    public boolean matchesId(String id) {
        IProject project = this.getProject();
        if (project != null) {
            return project.getName().equals(id);
        }
        return this.getPath().toPortableString().equals(id);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserDirectory)) {
            return false;
        }
        UserDirectory rc = (UserDirectory)obj;
        if (!this.userPath.equals((Object)rc.userPath)) {
            return false;
        }
        return (this.userProject != null || rc.userProject == null) && (this.userProject == null || this.userProject.equals(rc.userProject));
    }

    public int hashCode() {
        int hash = 0;
        hash += this.userPath.hashCode();
        if (this.userProject != null) {
            hash += this.userProject.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("User directory [");
        sb.append(this.userPath.toPortableString());
        if (this.userProject != null) {
            sb.append("|" + this.userProject);
        }
        return sb.append("]").toString();
    }
}

