/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public abstract class FeatureResolver {
    public void getRequiredFeatures(WebSphereRuntime wr, IModule[] module, IModuleResourceDelta[] delta, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, IProgressMonitor monitor) {
        List<IModule[]> moduleList = Collections.singletonList(module);
        List<IModuleResourceDelta[]> deltaList = Collections.singletonList(delta);
        this.getRequiredFeatures(wr, moduleList, deltaList, existingFeatures, requiredFeatures, false, monitor);
    }

    public abstract void getRequiredFeatures(WebSphereRuntime var1, List<IModule[]> var2, List<IModuleResourceDelta[]> var3, FeatureSet var4, RequiredFeatureMap var5, boolean var6, IProgressMonitor var7);

    public FeatureResolverFeature[] getContainedFeatures(WebSphereRuntime wr, IModule[] module, IProgressMonitor monitor) {
        List<IModule[]> moduleList = Collections.singletonList(module);
        return this.getContainedFeatures(wr, moduleList, monitor);
    }

    public FeatureResolverFeature[] getContainedFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, IProgressMonitor monitor) {
        return null;
    }

    public static void checkAndAddFeature(RequiredFeatureMap requiredFeatureMap, FeatureSet existingFeatures, WebSphereRuntime wr, String feature, List<IModule[]> moduleList, boolean includeAll) {
        FeatureResolver.checkAndAddFeature(requiredFeatureMap, existingFeatures, wr, new FeatureResolverFeature(feature), moduleList, includeAll);
    }

    public static void checkAndAddFeature(RequiredFeatureMap requiredFeatureMap, FeatureSet existingFeatures, WebSphereRuntime wr, FeatureResolverFeature feature, List<IModule[]> moduleList, boolean includeAll) {
        String featureName = feature.getName();
        if (existingFeatures != null && existingFeatures.supports(featureName)) {
            return;
        }
        if (requiredFeatureMap.contains(feature)) {
            requiredFeatureMap.addModules(feature, moduleList);
            return;
        }
        if (!includeAll) {
            FeatureResolverFeature[] requiredFeatures = requiredFeatureMap.getFeatures();
            for (int i = 0; i < requiredFeatures.length; ++i) {
                if (FeatureList.isEnabledBy(featureName, requiredFeatures[i].getName(), wr)) {
                    requiredFeatureMap.addModules(feature, moduleList);
                    return;
                }
                if (!FeatureList.isEnabledBy(requiredFeatures[i].getName(), featureName, wr)) continue;
                if (!requiredFeatureMap.contains(feature)) {
                    requiredFeatureMap.replaceFeature(requiredFeatures[i], feature);
                } else {
                    requiredFeatureMap.removeFeature(requiredFeatures[i]);
                }
                requiredFeatureMap.addModules(feature, moduleList);
            }
        }
        if (!requiredFeatureMap.contains(feature)) {
            requiredFeatureMap.addFeature(feature, moduleList);
        }
    }

    public String toString() {
        return "FeatureResolver [" + this.getClass().toString() + "]";
    }
}

