/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Trace;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ClasspathExtension {
    private static final String EXTENSION_POINT = "classpathExtensions";
    private boolean isEmptyContainer = false;
    private final IProjectFacet[] facets;
    private final String[] natures;

    public static void createClasspathExtensions(List<ClasspathExtension> includeList, List<ClasspathExtension> emptyContainerlist) {
        IConfigurationElement[] cf;
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "->- Loading .classpathExtensions extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        for (IConfigurationElement ce : cf = registry.getConfigurationElementsFor("com.ibm.ws.st.core", EXTENSION_POINT)) {
            String isEmptyContainerAttr = ce.getAttribute("isEmptyContainer");
            boolean isEmptyContainer = isEmptyContainerAttr == null ? false : Boolean.valueOf(isEmptyContainerAttr);
            try {
                if (isEmptyContainer) {
                    emptyContainerlist.add(new ClasspathExtension(ce));
                } else {
                    includeList.add(new ClasspathExtension(ce));
                }
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)3, "  Loaded classpathExtension: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.logError("Could not load classpathExtension: " + ce.getAttribute("id"), t);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "-<- Done loading .classpathExtensions extension point -<-");
        }
    }

    public ClasspathExtension(IConfigurationElement element) {
        int i;
        String isEmptyContainerAttr = element.getAttribute("isEmptyContainer");
        this.isEmptyContainer = isEmptyContainerAttr == null ? false : Boolean.valueOf(isEmptyContainerAttr);
        IConfigurationElement[] ce = element.getChildren("facet");
        int size = ce.length;
        this.facets = new IProjectFacet[size];
        for (i = 0; i < size; ++i) {
            String facet = ce[i].getAttribute("type");
            this.facets[i] = ProjectFacetsManager.getProjectFacet((String)facet);
        }
        ce = element.getChildren("nature");
        size = ce.length;
        this.natures = new String[size];
        for (i = 0; i < size; ++i) {
            this.natures[i] = ce[i].getAttribute("type");
        }
    }

    public final boolean containsSupportedFacet(IProject project) {
        IFacetedProject facetedProject;
        block4: {
            facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                if (!Trace.ENABLED) break block4;
                Trace.trace((byte)1, "Failed to create faceted project for: " + project, e);
            }
        }
        if (facetedProject == null) {
            return false;
        }
        for (IProjectFacet facet : this.facets) {
            if (!facetedProject.hasProjectFacet(facet)) continue;
            return true;
        }
        return false;
    }

    public final boolean isEmptyContainer() {
        return this.isEmptyContainer;
    }

    public final boolean supportsNature(IProject project) {
        for (String s : this.natures) {
            try {
                if (project.getNature(s) == null) continue;
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public final boolean supportsFacet(IProjectFacet projectFacet) {
        for (IProjectFacet facet : this.facets) {
            if (!facet.getId().equals(projectFacet.getId())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ClasspathExtension [" + this.getClass().toString() + "]";
    }
}

