/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.IPromptActionHandler;
import com.ibm.ws.st.core.internal.IPromptIssue;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PublishHelper;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;

public class AppMonitorMBeanPrompt
extends PromptHandler.AbstractPrompt
implements IPromptActionHandler {
    private static final String ALWAYS_KEY = "applicationMonitor.updateTrigger.mbean";
    private static final String IGNORE = "ignore";
    IPromptIssue issue = null;

    @Override
    public void prePromptAction(List<IModule[]> publishedModules, PublishHelper helper, IProgressMonitor monitor) {
        String value;
        this.issue = null;
        if (publishedModules == null || publishedModules.isEmpty()) {
            return;
        }
        boolean hasInternalModule = false;
        for (IModule[] m : publishedModules) {
            if (m.length <= 0 || m[0].isExternal()) continue;
            hasInternalModule = true;
            break;
        }
        if (!hasInternalModule) {
            return;
        }
        WebSphereServer server = helper.getWebSphereServer();
        if (server == null) {
            if (Trace.ENABLED) {
                Trace.logError("WebSphere server is null.", null);
            }
            return;
        }
        ConfigurationFile configFile = server.getConfiguration();
        if (configFile == null) {
            if (Trace.ENABLED) {
                Trace.logError("Config file is null.", null);
            }
            return;
        }
        if (!configFile.hasElement("applicationMonitor")) {
            this.setMBean(helper);
            return;
        }
        boolean isAlwaysAdd = false;
        String always = helper.getPromptResponse(ALWAYS_KEY);
        if (always != null) {
            if (always.equals(IGNORE)) {
                return;
            }
            isAlwaysAdd = true;
        }
        if ((value = configFile.getAppMonitorUpdateTrigger()) == null || !value.equals("mbean")) {
            if (isAlwaysAdd) {
                this.setMBean(helper);
                return;
            }
            this.issue = new AppMonitorUpdateTriggerIssue();
        }
    }

    @Override
    public void postPromptAction(IPromptResponse response, PublishHelper helper) {
        PromptAction action = response.getSelectedAction(this.issue);
        boolean always = response.getApplyAlways(this.issue);
        if (always) {
            helper.addPromptResponse(ALWAYS_KEY, action == PromptAction.UPDATE_SERVER_CONFIG ? "add" : IGNORE);
            helper.savePromptResponses();
        }
        if (action == PromptAction.UPDATE_SERVER_CONFIG) {
            this.setMBean(helper);
        }
    }

    private void setMBean(PublishHelper helper) {
        WebSphereServer ws = helper.getWebSphereServer();
        ConfigurationFile configFile = ws.getConfiguration();
        if (!configFile.hasElement("applicationMonitor")) {
            configFile.addElement("applicationMonitor");
        }
        configFile.setAttribute("applicationMonitor", "updateTrigger", "mbean");
        helper.setConfigChanged(true);
    }

    @Override
    public boolean isActive() {
        return this.issue != null;
    }

    @Override
    public IPromptActionHandler getActionHandler() {
        return this;
    }

    @Override
    public IPromptIssue[] getIssues() {
        if (this.issue == null) {
            return null;
        }
        return new IPromptIssue[]{this.issue};
    }

    private static class AppMonitorUpdateTriggerIssue
    implements IPromptIssue {
        AppMonitorUpdateTriggerIssue() {
        }

        @Override
        public String getType() {
            return Messages.appMonitorTriggerMBeanIssue;
        }

        @Override
        public String getSummary() {
            return Messages.appMonitorTriggerMBeanSummary;
        }

        @Override
        public String getDetails() {
            return Messages.appMonitorTriggerMBeanDetails;
        }

        @Override
        public PromptAction[] getPossibleActions() {
            return new PromptAction[]{PromptAction.UPDATE_SERVER_CONFIG, PromptAction.IGNORE};
        }

        @Override
        public PromptAction getDefaultAction() {
            return PromptAction.UPDATE_SERVER_CONFIG;
        }
    }
}

