/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal;

import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.docker.core.internal.AbstractServerCleanupHandler;
import com.ibm.ws.st.docker.ui.internal.Messages;
import com.ibm.ws.st.docker.ui.internal.Trace;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ServerCleanupHandler
extends AbstractServerCleanupHandler {
    public void handleServerDelete(BaseDockerContainer container, Properties properties) {
        block7: {
            final boolean[] response = new boolean[]{true};
            try {
                final String containerName = container.getContainerName();
                final String imageName = container.getImageName();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PromptUtil.isSuppressDialog()) {
                            response[0] = false;
                        } else {
                            Shell shell = Display.getDefault().getActiveShell();
                            response[0] = MessageDialog.openQuestion((Shell)shell, (String)Messages.dockerServerDeleteTitle, (String)NLS.bind((String)Messages.dockerServerDeleteRemoveArtifacts, (Object[])new String[]{containerName, imageName}));
                        }
                    }
                });
                if (response[0]) break block7;
                try {
                    if (container.isRunning()) {
                        container.stop();
                    }
                    container.getDockerMachine().removeContainer(container.getContainerName());
                }
                catch (Exception e) {
                    Trace.logError("Failed to remove Docker container: " + containerName, e);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)Messages.dockerServerDeleteErrorTitle, (String)NLS.bind((String)Messages.dockerServerDeleteRemoveContainerFailed, (Object[])new String[]{containerName, e.getLocalizedMessage()}));
                        }
                    });
                    return;
                }
                try {
                    container.getDockerMachine().removeImage(imageName);
                }
                catch (Exception e) {
                    Trace.logError("Failed to remove Docker image: " + imageName, e);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = Display.getDefault().getActiveShell();
                            MessageDialog.openError((Shell)shell, (String)Messages.dockerServerDeleteErrorTitle, (String)NLS.bind((String)Messages.dockerServerDeleteRemoveImageFailed, (Object[])new String[]{imageName, e.getLocalizedMessage()}));
                        }
                    });
                }
            }
            catch (Exception e) {
                Trace.logError("Failed to get the image name for Docker container: " + container.getContainerName(), e);
            }
        }
    }
}

