/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal;

import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.docker.core.internal.AbstractModeSwitchHandler;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import com.ibm.ws.st.docker.ui.internal.Messages;
import com.ibm.ws.st.docker.ui.internal.Trace;
import java.net.ConnectException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ModeSwitchHandler
extends AbstractModeSwitchHandler {
    public void handleExecutionModeSwitch(WebSphereServer server) {
        String imageName;
        BaseDockerContainer container;
        if (!"LibertyDocker".equals(server.getServerType())) {
            return;
        }
        LibertyDockerServer dockerServer = (LibertyDockerServer)server.getAdapter(LibertyDockerServer.class);
        if (dockerServer == null || !dockerServer.isUserContainer(server)) {
            return;
        }
        try {
            container = dockerServer.getContainer(server);
            if (container == null) {
                Trace.logError("The Docker container was null for server: " + server.getServerName(), null);
                return;
            }
        }
        catch (UnsupportedServiceException e) {
            Trace.logError("Failed to retrieve Docker container information for server: " + server.getServerName(), e);
            return;
        }
        String containerName = container.getContainerName();
        try {
            imageName = container.getImageName();
        }
        catch (ConnectException e) {
            Trace.logError("Could not get the image name for container: " + containerName, e);
            return;
        }
        final String newContainerName = NLS.bind((String)Messages.dockerServerModeSwitchContainerFormat, (Object)containerName);
        final String newImageName = NLS.bind((String)Messages.dockerServerModeSwitchImageFormat, (Object[])new String[]{containerName.toLowerCase(), imageName});
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog.openInformation((Shell)shell, (String)Messages.dockerServerModeSwitchTitle, (String)NLS.bind((String)Messages.dockerServerModeSwitchMessage, (Object[])new String[]{newImageName, newContainerName}));
            }
        });
    }
}

