/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIModelOperations;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import io.smallrye.openapi.runtime.io.info.InfoReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.media.Schema;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIModelOperationsImpl
implements OpenAPIModelOperations {
    private static final TraceComponent tc = Tr.register(OpenAPIModelOperationsImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -4325649447258726100L;

    @Override
    public OpenAPI shallowCopy(OpenAPI model) {
        OpenAPI result = OASFactory.createOpenAPI();
        result.setOpenapi(model.getOpenapi());
        result.setComponents(model.getComponents());
        result.setExtensions(model.getExtensions());
        result.setExternalDocs(model.getExternalDocs());
        result.setInfo(model.getInfo());
        result.setPaths(model.getPaths());
        result.setSecurity(model.getSecurity());
        result.setServers(model.getServers());
        result.setTags(model.getTags());
        return result;
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public Info parseInfo(String infoJson) throws OpenApiRuntimeException {
        try {
            JsonNode infoNode = new ObjectMapper().readTree(infoJson);
            Info info = InfoReader.readInfo((JsonNode)infoNode);
            return info;
        }
        catch (IOException e) {
            throw new OpenApiRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isDefaultOpenApiModel(OpenAPI model) {
        boolean isDefault = false;
        if (model.getOpenapi().equals("3.0.3") && model.getInfo() != null && model.getInfo().getContact() == null && model.getInfo().getDescription() == null && model.getInfo().getLicense() == null && model.getInfo().getTermsOfService() == null && model.getInfo().getTitle().equals("Generated API") && model.getInfo().getVersion().equals("1.0") && model.getPaths() != null && model.getPaths().getPathItems() == null && model.getComponents() == null && model.getExtensions() == null && model.getExternalDocs() == null && model.getSecurity() == null && model.getServers() == null && model.getTags() == null) {
            isDefault = true;
        }
        return isDefault;
    }

    @Override
    @Trivial
    public OpenAPI createDefaultOpenApiModel() {
        OpenAPIImpl openAPI = new OpenAPIImpl();
        openAPI.setOpenapi("3.0.3");
        openAPI.paths((Paths)new PathsImpl());
        openAPI.info(new InfoImpl().title("Generated API").version("1.0"));
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"Created base OpenAPI document", (Object[])new Object[0]);
        }
        return openAPI;
    }

    @Override
    public List<Schema.SchemaType> getTypes(Schema schema) {
        Schema.SchemaType type = schema.getType();
        return type == null ? null : Collections.singletonList(type);
    }
}

