/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.netty;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.framework.IOConnectionContext;
import com.ibm.ws.sib.jfapchannel.framework.IOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOReadRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyIOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.netty.NettyNetworkConnection;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class NettyIOConnectionContext
implements IOConnectionContext {
    private static final TraceComponent tc = SibTr.register(NettyIOConnectionContext.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private NettyNetworkConnection conn = null;

    public NettyIOConnectionContext(NettyNetworkConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn});
        }
        this.conn = conn;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLocalAddress");
        }
        InetAddress localAddress = ((InetSocketAddress)this.conn.getVirtualConnection().localAddress()).getAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLocalAddress", (Object)localAddress);
        }
        return localAddress;
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemoteAddress");
        }
        InetAddress remoteAddress = ((InetSocketAddress)this.conn.getVirtualConnection().remoteAddress()).getAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemoteAddress", (Object)remoteAddress);
        }
        return remoteAddress;
    }

    @Override
    public int getLocalPort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLocalPort");
        }
        int localPort = ((InetSocketAddress)this.conn.getVirtualConnection().localAddress()).getPort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLocalPort", (Object)localPort);
        }
        return localPort;
    }

    @Override
    public int getRemotePort() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRemotePort");
        }
        int remotePort = ((InetSocketAddress)this.conn.getVirtualConnection().remoteAddress()).getPort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRemotePort", (Object)remotePort);
        }
        return remotePort;
    }

    @Override
    public IOReadRequestContext getReadInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReadInterface");
        }
        NettyIOReadRequestContext readCtx = new NettyIOReadRequestContext(this.conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReadInterface", (Object)readCtx);
        }
        return readCtx;
    }

    @Override
    public IOWriteRequestContext getWriteInterface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWriteInterface");
        }
        NettyIOWriteRequestContext writeCtx = new NettyIOWriteRequestContext(this.conn);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWriteInterface", (Object)writeCtx);
        }
        return writeCtx;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.rich.impl/src/com/ibm/ws/sib/netty/jfapchannel/NettyIOConnectionContext.java, SIB.comms, WASX.SIB, uu1215.01 1.2");
        }
    }
}

