/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.gd.RangeObject;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class TickRange
extends RangeObject {
    private static TraceComponent tc = SibTr.register(TickRange.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static final byte Unknown = 0;
    public static final byte Requested = 1;
    public static final byte Uncommitted = 2;
    public static final byte Value = 3;
    public static final byte Discarded = 4;
    public static final byte Accepted = 5;
    public static final byte Rejected = 6;
    public static final byte Completed = 7;
    public static final byte Error = 8;
    public byte type;
    public Object value;
    public long itemStreamIndex;
    private boolean reallocateOnCommit = false;
    public long valuestamp;

    public TickRange(byte type, long start, long end) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TickRange", (Object)new Object[]{type, start, end});
        }
        if (start > end) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Start greater than end");
            }
        } else {
            this.type = type;
            this.startstamp = start;
            this.endstamp = end;
            this.value = null;
            this.valuestamp = 0L;
            this.itemStreamIndex = -1L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"TickRange", (Object)this);
        }
    }

    public static TickRange newValueTick(long tick, Object value, long itemStreamIndex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newValueTick", (Object)new Object[]{tick, value, itemStreamIndex});
        }
        TickRange r = new TickRange(3, tick, tick);
        r.itemStreamIndex = itemStreamIndex;
        r.value = value;
        r.valuestamp = tick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newValueTick", (Object)r);
        }
        return r;
    }

    public static TickRange newUncommittedTick(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newUncommittedTick", (Object)tick);
        }
        TickRange r = new TickRange(2, tick, tick);
        r.valuestamp = tick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newUncommittedTick", (Object)r);
        }
        return r;
    }

    public void reallocateOnCommit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reallocateOnCommit");
            SibTr.exit((TraceComponent)tc, (String)"reallocateOnCommit");
        }
        this.reallocateOnCommit = true;
    }

    public boolean isReallocationRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isReallocationRequired");
            SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired", (Object)this.reallocateOnCommit);
        }
        return this.reallocateOnCommit;
    }

    public String toString() {
        String ret = "[" + TickRange.stateToString(this.type) + " Start:" + TickRange.tickToString(this.startstamp) + ", End:" + (this.endstamp == Long.MAX_VALUE ? "      LAST" : TickRange.tickToString(this.endstamp)) + " ValueTick:" + TickRange.tickToString(this.valuestamp) + ", Value:" + (this.value == null ? "null     " : "@" + Integer.toString(this.value.hashCode(), 16)) + ", Index:" + (this.itemStreamIndex == -1L ? "none     " : Long.toString(this.itemStreamIndex)) + ", HashCode:/" + Integer.toHexString(this.hashCode()) + "]";
        return ret;
    }

    protected static String stateToString(byte state) {
        String stype = "*";
        switch (state) {
            case 0: {
                stype = "Unknown    ";
                break;
            }
            case 1: {
                stype = "Requested  ";
                break;
            }
            case 2: {
                stype = "Uncommitted";
                break;
            }
            case 3: {
                stype = "Value      ";
                break;
            }
            case 4: {
                stype = "Discarded  ";
                break;
            }
            case 5: {
                stype = "Accepted   ";
                break;
            }
            case 6: {
                stype = "Rejected   ";
                break;
            }
            case 7: {
                stype = "Completed  ";
                break;
            }
        }
        return stype;
    }

    protected static String tickToString(long tick) {
        String blanks = "          ";
        String highBits = Long.toString(tick >>> 32);
        highBits = blanks.substring(0, blanks.length() - highBits.length()) + highBits;
        String lowBits = Long.toString(tick & 0xFFFFFFFFL);
        lowBits = blanks.substring(0, blanks.length() - lowBits.length()) + lowBits;
        return lowBits;
    }
}

