/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.client.LibertyServiceImpl;
import com.ibm.ws.jaxws.metadata.JaxWsClientMetaData;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.spi.ServiceDelegate;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.spi.ProviderImpl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyProviderImpl
extends ProviderImpl {
    private static final TraceComponent tc = Tr.register(LibertyProviderImpl.class, null, null);
    private static final ThreadLocal<List<WebServiceFeature>> wsFeatures = new ThreadLocal();
    private static final ThreadLocal<WebServiceRefInfo> wsRefInfo = new ThreadLocal();
    private static final AtomicReference<AtomicServiceReference<JaxWsSecurityConfigurationService>> securityConfigSR = new AtomicReference();
    static final long serialVersionUID = 5918876997604011290L;

    /*
     * WARNING - void declaration
     */
    public ServiceDelegate createServiceDelegate(final URL url, final QName qname, final Class cls) {
        Object bus;
        try {
            if (System.getProperty("org.apache.cxf.stax.allowInsecureParser") == null) {
                System.setProperty("org.apache.cxf.stax.allowInsecureParser", "true");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Insecure Stax property was null setting it to true on the Client.", (Object[])new Object[0]);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Client-Side Insecure Stax property is set to: " + System.getProperty("org.apache.cxf.stax.allowInsecureParser")), (Object[])new Object[0]);
            }
            Class.forName("org.apache.cxf.staxutils.StaxUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.jaxws.client.LibertyProviderImpl", (String)"74", (Object)((Object)this), (Object[])new Object[]{url, qname, cls});
            throw new IllegalStateException((Throwable)e);
        }
        JaxWsClientMetaData clientMetaData = JaxWsMetaDataManager.getJaxWsClientMetaData();
        if (clientMetaData != null) {
            boolean hasClientBus;
            boolean bl = hasClientBus = clientMetaData.getClientBus() != null;
            if (hasClientBus) {
                bus = clientMetaData.getClientBus();
            } else {
                bus = BusFactory.getThreadDefaultBus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No client  bus is found, the thread context default bus " + bus.getId() + " is used"), (Object[])new Object[0]);
                }
            }
        } else {
            bus = BusFactory.getThreadDefaultBus();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No client  bus is found, the thread context default bus " + bus.getId() + " is used"), (Object[])new Object[0]);
            }
        }
        final WebServiceRefInfo wsrInfo = wsRefInfo.get();
        List<WebServiceFeature> serviceFeatures = wsFeatures.get();
        AtomicServiceReference<JaxWsSecurityConfigurationService> secConfigSR = securityConfigSR.get();
        final JaxWsSecurityConfigurationService securityConfigService = secConfigSR == null ? null : (JaxWsSecurityConfigurationService)secConfigSR.getService();
        final List<WebServiceFeature> sf = serviceFeatures;
        if (serviceFeatures != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Thread context features are configured with " + serviceFeatures), (Object[])new Object[0]);
            }
            LibertyServiceImpl lsl = AccessController.doPrivileged(new PrivilegedAction<LibertyServiceImpl>(){
                static final long serialVersionUID = 2183694787991846050L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public LibertyServiceImpl run() {
                    return new LibertyServiceImpl(securityConfigService, wsrInfo, bus, url, qname, cls, sf.toArray(new WebServiceFeature[sf.size()]));
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.LibertyProviderImpl$1", 1.class, null, null);
                }
            });
            return lsl;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Thread context features are not set", (Object[])new Object[0]);
        }
        LibertyServiceImpl lsl = AccessController.doPrivileged(new PrivilegedAction<LibertyServiceImpl>(){
            static final long serialVersionUID = -8638057636547823127L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public LibertyServiceImpl run() {
                return new LibertyServiceImpl(securityConfigService, wsrInfo, bus, url, qname, cls, new WebServiceFeature[0]);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.client.LibertyProviderImpl$2", 2.class, null, null);
            }
        });
        return lsl;
    }

    public static void setWebServiceFeatures(List<WebServiceFeature> features) {
        wsFeatures.set(features);
    }

    public static List<WebServiceFeature> getWebServiceFeatures() {
        return wsFeatures.get();
    }

    public static void clearWebServiceFeatures() {
        wsFeatures.remove();
    }

    public static void setWebServiceRefInfo(WebServiceRefInfo wsrInfo) {
        wsRefInfo.set(wsrInfo);
    }

    public static void clearWebServiceRefInfo() {
        wsRefInfo.remove();
    }

    public static WebServiceRefInfo getWebServiceRefInfo() {
        return wsRefInfo.get();
    }

    public static void setSecurityConfigService(AtomicServiceReference<JaxWsSecurityConfigurationService> serviceRefer) {
        securityConfigSR.set(serviceRefer);
    }
}

