/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.comms.ProtocolVersion;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAccept;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlBrowseEnd;
import com.ibm.ws.sib.mfp.control.ControlBrowseGet;
import com.ibm.ws.sib.mfp.control.ControlBrowseStatus;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCompleted;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDecisionExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlReject;
import com.ibm.ws.sib.mfp.control.ControlRequest;
import com.ibm.ws.sib.mfp.control.ControlRequestAck;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.mfp.control.ControlRequestHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAck;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAckAck;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionVersionException;
import com.ibm.ws.sib.processor.gd.AIRequestedTick;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.gd.AIValueTick;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.impl.AIBrowseCursor;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.exceptions.SIMPNoResponseException;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MPDestinationChangeListener;
import com.ibm.ws.sib.processor.impl.interfaces.RefillKey;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.store.AIExecuteUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter;
import com.ibm.ws.sib.processor.impl.store.items.AICompletedPrefixItem;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.impl.AttachedRemoteSubscriberControl;
import com.ibm.ws.sib.processor.runtime.impl.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.utils.Queue;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.processor.utils.am.AbstractBatchedTimeoutEntry;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.trm.dlm.Capability;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AnycastInputHandler
implements InputHandler,
ControlHandler {
    public static final long INVALID_ACCEPTED_ITEM_ID = -1L;
    public static final long INVALID_COMPLETED_ITEM_ID = -1L;
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static final long INVALID_TICK = -1L;
    private static int NUM_OF_BUCKETS = 4;
    private MPAlarmManager _alarmManager;
    private MessageProcessor _messageProcessor;
    private String _destName;
    private SIBUuid12 _destUuid;
    private SIBUuid8 _destMEUuid;
    private SIBUuid12 _gatheringTargetDestUuid;
    private ItemStream _containerItemStream;
    private AIProtocolItemStream _persistentStreamState;
    private boolean _streamStateRemoveNeedsToWait;
    private RemoteConsumerDispatcher _remoteCD;
    protected AIStreamStatus _streamStatus;
    private boolean _cardinalityOne;
    private boolean _deliverInOrder;
    private long _currentRoundtripTime;
    private long[] _highestDeliveredExpressTicks;
    Queue msgsToBeDelivered = null;
    private Hashtable _browseCursorTable;
    private AsyncUpdateThread _msUpdateThread;
    private LinkedList _flushWorkQueue;
    protected long _areYouFlushedId;
    private BatchedTimeoutManager _createStreamTOM;
    private BatchedTimeoutManager _requestFlushTOM;
    private volatile AIStream _aiStream;
    private CreateStreamTimeoutEntry _createStreamEntry;
    private RequestFlushTimeoutEntry _requestFlushEntry;
    private boolean _requestFlushFailed = false;
    private Alarm _inactivityTimeoutAlarm;
    private AlarmListener _inactivityTimeoutListener;
    private boolean _inactivityAlarmCancelled = false;
    private ReachabilityChangeListener _reachabilityChangeListener;
    private BaseDestinationHandler _baseDestinationHandler;
    private ArrayList _flushCallbacks = new ArrayList();
    private LockingBoolean _forceDeleteMonitor = new LockingBoolean(false);
    private boolean _needToRedriveDeleteDestination = false;
    private volatile long _totalCompletedRequests = 0L;
    private volatile long _totalSentRequests = 0L;
    private AttachedRemoteSubscriberControl _control;
    private int _numberOfFlushWorkItemsOnStream = 0;
    private int _inProgressFlushWork = 0;
    private ArrayList _flushWaiters = new ArrayList();
    private ArrayList _createWaiters = new ArrayList();
    private static final TraceComponent tc = SibTr.register(AnycastInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final Filter COMPLETED_PREFIX_FILTER = new Filter(){

        public boolean filterMatches(AbstractItem item) {
            return item instanceof AICompletedPrefixItem;
        }
    };
    private boolean flushedWillDelete = false;

    public AnycastInputHandler(String destName, SIBUuid12 destUuid, boolean receiveExclusive, MessageProcessor messageProcessor, ItemStream containerItemStream, SIBUuid8 dmeId, SIBUuid12 gatheringTargetDestUuid, AsyncUpdateThread msUpdateThread, BaseDestinationHandler baseDestinationHandler, boolean restartFromStaleBackup) throws SIResourceException {
        this(destName, destUuid, receiveExclusive, messageProcessor, containerItemStream, dmeId, gatheringTargetDestUuid, msUpdateThread, baseDestinationHandler, restartFromStaleBackup, false);
    }

    private static boolean isAIProtocolItemStreamValid(AIProtocolItemStream stream) throws MessageStoreException {
        if (null == stream) {
            return false;
        }
        NonLockingCursor cursor = stream.newNonLockingItemCursor(COMPLETED_PREFIX_FILTER);
        try {
            cursor.allowUnavailableItems();
            if (null != cursor.next()) {
                boolean bl = true;
                return bl;
            }
            SibTr.warning((TraceComponent)tc, (String)"MISSING_COMPLETED_PREFIX_IN_STREAM_CWSIP0511", (Object)new Object[]{stream});
            boolean bl = false;
            return bl;
        }
        finally {
            cursor.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastInputHandler(String destName, SIBUuid12 destUuid, boolean receiveExclusive, MessageProcessor messageProcessor, ItemStream containerItemStream, SIBUuid8 dmeId, SIBUuid12 gatheringTargetDestUuid, AsyncUpdateThread msUpdateThread, BaseDestinationHandler baseDestinationHandler, boolean restartFromStaleBackup, boolean createControllable) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AnycastInputHandler", (Object)new Object[]{destName, destUuid, receiveExclusive, messageProcessor, containerItemStream, dmeId, gatheringTargetDestUuid, msUpdateThread, baseDestinationHandler, restartFromStaleBackup, createControllable});
        }
        AnycastInputHandler anycastInputHandler = this;
        synchronized (anycastInputHandler) {
            this._messageProcessor = messageProcessor;
            this._destName = destName;
            this._destUuid = destUuid;
            this._alarmManager = messageProcessor.getAlarmManager();
            this._containerItemStream = containerItemStream;
            this._destMEUuid = dmeId;
            this._gatheringTargetDestUuid = gatheringTargetDestUuid;
            this._msUpdateThread = msUpdateThread;
            this._baseDestinationHandler = baseDestinationHandler;
            this._cardinalityOne = receiveExclusive;
            this._streamStatus = new AIStreamStatus(0);
            this._deliverInOrder = this._cardinalityOne;
            long tick = this.generateUniqueValue();
            this.msgsToBeDelivered = new Queue();
            this._createStreamTOM = new BatchedTimeoutManager(NUM_OF_BUCKETS, this._messageProcessor.getCustomProperties().get_create_stream_repetition_interval(), null, new CreateStreamTimeoutProcessor(), messageProcessor);
            this._createStreamEntry = null;
            this._requestFlushTOM = new BatchedTimeoutManager(NUM_OF_BUCKETS, this._messageProcessor.getCustomProperties().get_request_flush_repetition_interval(), null, new RequestFlushTimeoutProcessor(), messageProcessor);
            this._requestFlushEntry = null;
            this._areYouFlushedId = -1L;
            boolean startInactivityTimer = false;
            this._streamStateRemoveNeedsToWait = false;
            NonLockingCursor cursor = null;
            try {
                cursor = containerItemStream.newNonLockingItemStreamCursor(null);
                this._persistentStreamState = (AIProtocolItemStream)cursor.next();
                if (AnycastInputHandler.isAIProtocolItemStreamValid(this._persistentStreamState)) {
                    SIBUuid12 streamId = null;
                    this._aiStream = new AIStream(streamId, this._persistentStreamState, this, msUpdateThread, tick, null, true, messageProcessor);
                    if (restartFromStaleBackup || this._persistentStreamState.isFlushStarted() || this._cardinalityOne) {
                        this._streamStatus.set(7);
                        this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
                    } else {
                        this._streamStatus.set(4);
                        startInactivityTimer = true;
                    }
                } else {
                    this._aiStream = null;
                    this._persistentStreamState = null;
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.AnycastInputHandler", (String)"1:590:1.219.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"AnycastInputHandler", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)e);
            }
            finally {
                if (cursor != null) {
                    cursor.finished();
                }
            }
            this._currentRoundtripTime = this._messageProcessor.getCustomProperties().get_init_round_trip_time();
            this._highestDeliveredExpressTicks = new long[10];
            for (int i = 0; i < 9; ++i) {
                this._highestDeliveredExpressTicks[i] = tick;
            }
            this._browseCursorTable = new Hashtable();
            this.start();
            if (startInactivityTimer) {
                this.startInactivityTimer();
            }
            this._reachabilityChangeListener = new ReachabilityChangeListener();
            messageProcessor.getDestinationChangeListener().addMPDestinationChangeListener(this._reachabilityChangeListener);
        }
        if (createControllable) {
            this.createControlAdapter();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AnycastInputHandler", (Object)this);
        }
    }

    public void initRCD(RemoteConsumerDispatcher remoteCD) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initRCD", (Object)remoteCD);
        }
        this._remoteCD = remoteCD;
        this._reachabilityChangeListener.initRCD(remoteCD);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initRCD");
        }
    }

    public RemoteConsumerDispatcher getRCD() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRCD");
            SibTr.exit((TraceComponent)tc, (String)"getRCD", (Object)this._remoteCD);
        }
        return this._remoteCD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete");
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            try {
                if (!this._streamStatus.test(0)) {
                    this.cleanupStreamState();
                    this._streamStatus.set(0);
                }
            }
            catch (SIResourceException sIResourceException) {
            }
            catch (SIErrorException sIErrorException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    public void start() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        this._createStreamTOM.startTimer();
        this._requestFlushTOM.startTimer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this._createStreamTOM.stopTimer();
        this._requestFlushTOM.stopTimer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void startInactivityTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startInactivityTimer");
        }
        if (this._inactivityTimeoutListener == null) {
            this._inactivityTimeoutListener = new InactivityTimeoutListener();
        }
        this._inactivityTimeoutAlarm = this._alarmManager.create(this._messageProcessor.getCustomProperties().get_sender_inactivity_timeout(), this._inactivityTimeoutListener);
        this._inactivityAlarmCancelled = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startInactivityTimer");
        }
    }

    public synchronized void cancelInactivityTimer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelInactivityTimer");
        }
        if (this._inactivityTimeoutAlarm != null) {
            this._inactivityTimeoutAlarm.cancel();
            this._inactivityTimeoutAlarm = null;
            this._inactivityAlarmCancelled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelInactivityTimer");
        }
    }

    public void changeReceiveExclusive(boolean isReceiveExclusive) {
        this._cardinalityOne = isReceiveExclusive;
        this._deliverInOrder = isReceiveExclusive;
    }

    @Override
    public void handleMessage(MessageItem msg, TransactionCommon transaction, SIBUuid8 sourceMEUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{msg, transaction, sourceMEUuid});
        }
        msg.setCurrentMEArrivalTimestamp(System.currentTimeMillis());
        JsMessage jsMsg = msg.getMessage();
        if (jsMsg.isGuaranteedRemoteBrowse()) {
            this.handleBrowseDataMessage(msg);
        } else {
            this.handleDataMessage(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIResourceException {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, cMsg});
        }
        if ((type = cMsg.getControlMessageType()) == ControlMessageType.COMPLETED) {
            this.processCompletedMessage(cMsg);
        } else if (type == ControlMessageType.DECISIONEXPECTED) {
            this.processDecisionExpectedMessage(cMsg);
        } else if (type == ControlMessageType.REQUESTHIGHESTGENERATEDTICK) {
            this.processRequestHighestGeneratedTickMessage(cMsg);
        } else if (type == ControlMessageType.BROWSEEND) {
            this.processBrowseEndMessage(cMsg);
        } else if (type == ControlMessageType.REQUESTACK) {
            this.processRequestAckMessage(cMsg);
        } else if (type == ControlMessageType.RESETREQUESTACK) {
            this.processResetRequestAckMessage(cMsg);
        } else if (type == ControlMessageType.FLUSHED) {
            this.processFlushedMessage(cMsg);
        } else if (type == ControlMessageType.NOTFLUSHED) {
            this.processNotFlushedMessage(cMsg);
        } else if (type == ControlMessageType.CARDINALITYINFO) {
            this.processCardinalityInfoMessage(cMsg);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:862:1.219.1.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.handleControlMessage", (String)"1:868:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:875:1.219.1.1"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean consumerAttaching(long responseTimeout) throws SIResourceException {
        SIResourceException sendException;
        MPIO mpio;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumerAttaching");
        }
        if (!(mpio = this._messageProcessor.getMPIO()).isMEReachable(this._destMEUuid)) {
            String meName = JsAdminUtils.getMENameByUuidForMessage((String)this._destMEUuid.toString());
            if (meName == null) {
                meName = this._destMEUuid.toString();
            }
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{this._destName, meName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", (Object)((Object)e));
            }
            throw e;
        }
        boolean waitForCreate = false;
        boolean waitForFlush = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._requestFlushEntry != null && this._requestFlushFailed) {
                this.redriveFailedRequestFlush();
            }
            switch (this._streamStatus.get()) {
                case 4: {
                    if (this.checkStreamHasNoFlushWork() || this.cancelAllFlushWork()) break;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", (Object)false);
                    }
                    return false;
                }
                case 0: {
                    this._streamStatus.set(3);
                    waitForCreate = true;
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    waitForFlush = true;
                    waitForCreate = true;
                    break;
                }
                case 8: {
                    SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_NOT_FLUSHED_CWSIP0512", new Object[]{this._destName, this._destMEUuid.toString()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", (Object)((Object)e));
                    }
                    throw e;
                }
                case 3: {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler.consumerAttaching", "1:1031:1.219.1.1"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.consumerAttaching", (String)"1:1037:1.219.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler.consumerAttaching", "1:1045:1.219.1.1"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", (Object)((Object)e));
                    }
                    throw e;
                }
            }
        }
        this.cancelInactivityTimer();
        if (waitForFlush && (sendException = this.waitForResponse(responseTimeout, true)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", (Object)((Object)sendException));
            }
            throw sendException;
        }
        if (waitForCreate) {
            this.sendCreateStreamAndWait(responseTimeout);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumerAttaching", (Object)true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConsumerDispatcher getResolvedDurableCD(RemoteConsumerDispatcher rcd) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getResolvedDurableCD", (Object)rcd);
        }
        RemoteConsumerDispatcher returnRCD = null;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(4) && this.cancelAllFlushWork()) {
                returnRCD = rcd;
            }
            if (returnRCD == null) {
                MPIO mpio = this._messageProcessor.getMPIO();
                if (mpio.isMEReachable(this._destMEUuid)) {
                    if (this._requestFlushEntry != null && this._requestFlushFailed) {
                        this.redriveFailedRequestFlush();
                    }
                } else {
                    String meName = JsAdminUtils.getMENameByUuidForMessage((String)this._destMEUuid.toString());
                    if (meName == null) {
                        meName = this._destMEUuid.toString();
                    }
                    SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{this._destName, meName}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"getResolvedDurableCD", (Object)((Object)e));
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getResolvedDurableCD", (Object)returnRCD);
        }
        return returnRCD;
    }

    public void lastCardNConsumerDetached() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lastCardNConsumerDetached");
        }
        this.startInactivityTimer();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lastCardNConsumerDetached");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIStreamKey issueGet(SelectionCriteria[] criterias, long timeout, RemoteDispatchableKey ck, AOValue restoreValue, RefillKey refillCallback) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueGet", (Object)new Object[]{criterias, timeout, ck});
        }
        AIStreamKey requestKey = null;
        long tick = -1L;
        long rejectStartTick = -1L;
        boolean sendRequest = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.isStreamReady() && this.checkStreamHasNoFlushWork()) {
                long issueTime = System.currentTimeMillis();
                AIRequestedTick airt = null;
                if (restoreValue != null) {
                    tick = restoreValue.getAIRequestTick();
                    airt = new AIRequestedTick(tick, restoreValue, timeout);
                } else {
                    tick = this.generateUniqueValue();
                    airt = new AIRequestedTick(tick, criterias, ck, timeout, false, issueTime);
                }
                requestKey = new AIStreamKey(tick, ck, timeout, issueTime);
                if (refillCallback != null) {
                    refillCallback.setLatestTick(tick);
                }
                try {
                    rejectStartTick = this._aiStream.insertRequest(airt, tick, timeout);
                    this._aiStream.setLatestTick(tick);
                    ++this._totalSentRequests;
                    sendRequest = true;
                }
                catch (SIErrorException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.issueGet", (String)"1:1232:1.219.1.1", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)((Object)e));
                    }
                    throw e;
                }
            } else {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1254:1.219.1.1"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.issueGet", (String)"1:1260:1.219.1.1", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (sendRequest) {
            long[] rejectStartTicks = new long[]{rejectStartTick};
            long[] ticks = new long[]{tick};
            long[] timeouts = new long[]{timeout};
            this.sendRequest(rejectStartTicks, ticks, criterias, timeouts, 11);
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("REMOTE_REQUEST_SENT_CWSJU0030", new Object[]{this.getDestName(), this._messageProcessor.getMessagingEngineUuid(), this._destMEUuid, this._gatheringTargetDestUuid}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)requestKey);
        }
        return requestKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AIStreamKey[] issueGet(SelectionCriteria[] criterias, int count, RemoteDispatchableKey ck) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueGet", (Object)new Object[]{criterias, count, ck});
        }
        AIStreamKey[] keys = null;
        long[] rejectStartTicks = null;
        long[] ticks = null;
        long timeout = this._messageProcessor.getCustomProperties().get_infinite_timeout();
        long[] timeouts = null;
        boolean sendRequest = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.isStreamReady() && this.checkStreamHasNoFlushWork()) {
                rejectStartTicks = new long[count];
                ticks = new long[count];
                timeouts = new long[count];
                keys = new AIStreamKey[count];
                for (int i = 0; i < count; ++i) {
                    long tick = -1L;
                    ticks[i] = tick = this.generateUniqueValue();
                    long issueTime = System.currentTimeMillis();
                    keys[i] = new AIStreamKey(tick, ck, timeout, issueTime);
                    timeouts[i] = timeout;
                    try {
                        AIRequestedTick airt = new AIRequestedTick(tick, criterias, ck, timeout, false, issueTime);
                        rejectStartTicks[i] = this._aiStream.insertRequest(airt, tick, timeout);
                        this._aiStream.setLatestTick(tick);
                        ++this._totalSentRequests;
                        sendRequest = true;
                        continue;
                    }
                    catch (SIErrorException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"issueGet", null);
                        }
                        return null;
                    }
                }
            } else {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1373:1.219.1.1"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.issueGet", (String)"1:1379:1.219.1.1", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (sendRequest) {
            this.sendRequest(rejectStartTicks, ticks, criterias, timeouts, 11);
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("REMOTE_REQUEST_SENT_CWSJU0030", new Object[]{this.getDestName(), this._messageProcessor.getMessagingEngineUuid(), this._destMEUuid, this._gatheringTargetDestUuid}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueGet", (Object)keys);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(AIStreamKey key, TransactionCommon transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"accept", (Object)new Object[]{key, transaction});
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            AIProtocolItem acceptedItem;
            if (!this.isStreamFlushing() && this.isStreamReady() && (acceptedItem = this._aiStream.processAccepted(key.getTick(), transaction)) != null) {
                key.setAcceptedItem(acceptedItem);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"accept");
        }
    }

    public void createControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        PubSubOutputHandler psoh = this.getBaseDestinationHandler().getPubSubOutputHandler(this._destMEUuid);
        RemoteTopicSpaceControl remotetopicSpaceControl = null;
        if (psoh == null || psoh.getControlAdapter() == null) {
            remotetopicSpaceControl = new RemoteTopicSpaceControl(null, this, this._messageProcessor);
        } else {
            remotetopicSpaceControl = (RemoteTopicSpaceControl)psoh.getControlAdapter();
            remotetopicSpaceControl.setAnycastInputHandler(this);
        }
        this._control = new AttachedRemoteSubscriberControl(this._destName, this, this._messageProcessor, remotetopicSpaceControl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public AttachedRemoteSubscriberControl getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this._control);
        }
        return this._control;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void committed(AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"committed", (Object)new Object[]{key});
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (!this.isStreamFlushing() && this.isStreamReady()) {
                long tick = key.getTick();
                AIProtocolItem acceptedItem = key.getAcceptedItem();
                try {
                    this._aiStream.updateToAccepted(tick, acceptedItem);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
                if (this._flushWorkQueue != null && !this.streamHasIndoubtTransactions() && this._flushWorkQueue.size() > 0) {
                    Runnable flushWorker = new Runnable(){

                        @Override
                        public void run() {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.entry((TraceComponent)tc, (String)"run");
                            }
                            AnycastInputHandler.this.drainFlushWorkQueue();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"run");
                            }
                        }
                    };
                    try {
                        this._messageProcessor.startNewSystemThread(flushWorker);
                    }
                    catch (InterruptedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.committed", (String)"1:1564:1.219.1.1", (Object)this);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"committed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rolledback(AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)new Object[]{key});
        }
        SendDispatcher rejectedDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (!this.isStreamFlushing() && this.isStreamReady()) {
                try {
                    this._aiStream.updateToRejected(key.getTick(), rejectedDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
                if (this._flushWorkQueue != null && !this.streamHasIndoubtTransactions() && this._flushWorkQueue.size() > 0) {
                    Runnable flushWorker = new Runnable(){

                        @Override
                        public void run() {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.entry((TraceComponent)tc, (String)"run");
                            }
                            AnycastInputHandler.this.drainFlushWorkQueue();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"run");
                            }
                        }
                    };
                    try {
                        this._messageProcessor.startNewSystemThread(flushWorker);
                    }
                    catch (InterruptedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.rolledback", (String)"1:1641:1.219.1.1", (Object)this);
                    }
                }
            }
        }
        rejectedDispatcher.dispatch();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rolledback");
        }
    }

    public void reject(AIStreamKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reject", (Object)key);
        }
        this.reject(key.getTick());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reject", (Object)tick);
        }
        SendDispatcher rejectedDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (!this.isStreamFlushing() && this.isStreamReady()) {
                try {
                    this._aiStream.updateToRejected(tick, rejectedDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
            }
        }
        rejectedDispatcher.dispatch();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectAll() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rejectAll");
        }
        boolean sendRequestFlush = false;
        SendDispatcher rejectedDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(4) || this._streamStatus.test(8)) {
                this._streamStatus.set(2);
                try {
                    this._aiStream.updateAllToRejected(rejectedDispatcher);
                }
                catch (SIErrorException sIErrorException) {
                    // empty catch block
                }
                sendRequestFlush = true;
            } else if (!this.isStreamFlushing() && !this._streamStatus.test(0)) {
                SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1764:1.219.1.1"}, null));
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.rejectAll", (String)"1:1771:1.219.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:1779:1.219.1.1"});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rejectAll", (Object)((Object)e));
                }
                throw e;
            }
        }
        rejectedDispatcher.dispatch();
        if (sendRequestFlush) {
            this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rejectAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForFlushDone() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForFlushDone");
        }
        if (!this.flushedWillDelete) {
            this.delete();
        }
        if (this._forceDeleteMonitor != null) {
            LockingBoolean lockingBoolean = this._forceDeleteMonitor;
            synchronized (lockingBoolean) {
                if (this._forceDeleteMonitor.booleanValue()) {
                    this._forceDeleteMonitor.setBooleanValue(false);
                    this._forceDeleteMonitor.notifyAll();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForFlushDone");
        }
    }

    public long getRoundTripTime() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoundTripTime");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRoundTripTime", (Object)this._currentRoundtripTime);
        }
        return this._currentRoundtripTime;
    }

    public boolean forceFlushAtTarget() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
        boolean returnValue = this.forceFlushAtTarget(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean forceFlushAtTarget(boolean flushRelevant) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)flushRelevant);
        }
        boolean deleted = false;
        this.flushedWillDelete = flushRelevant;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(0)) {
                this._needToRedriveDeleteDestination = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)"Stream non existent");
                }
                return true;
            }
            if (this.isStreamFlushing()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)"Stream force deleting or flushing");
                }
                return false;
            }
            this._streamStatus.set(8);
            if (flushRelevant) {
                this._needToRedriveDeleteDestination = true;
            }
        }
        this._forceDeleteMonitor.setBooleanValue(true);
        this._remoteCD.closeAllConsumersForFlush();
        if (!flushRelevant) {
            this.waitOnForceDeleteMonitor();
            deleted = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)deleted);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStreamHasNoFlushWork() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStreamHasNoFlushWork");
        }
        boolean returnValue = true;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._numberOfFlushWorkItemsOnStream > 0) {
                returnValue = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStreamHasNoFlushWork", (Object)returnValue);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnForceDeleteMonitor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitOnForceDeleteMonitor");
        }
        if (this._forceDeleteMonitor != null) {
            LockingBoolean lockingBoolean = this._forceDeleteMonitor;
            synchronized (lockingBoolean) {
                if (this._forceDeleteMonitor.booleanValue()) {
                    try {
                        this._forceDeleteMonitor.wait();
                    }
                    catch (InterruptedException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.waitOnForceDeleteMonitor", (String)"1:2015:1.219.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)e);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitOnForceDeleteMonitor");
        }
    }

    public boolean destinationDeleted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationDeleted");
        }
        boolean deleted = false;
        deleted = this.forceFlushAtTarget(true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationDeleted", (Object)deleted);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowseCursor newBrowseCursor(SelectionCriteria criteria) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newBrowseCursor", (Object)criteria);
        }
        long nextBrowseId = 0L;
        AIBrowseCursor browseCursor = null;
        nextBrowseId = this.generateUniqueValue();
        MessageSelectorFilter filter = null;
        if (criteria != null && (criteria.getSelectorString() != null && !criteria.getSelectorString().equals("") || criteria.getDiscriminator() != null && !criteria.getDiscriminator().equals(""))) {
            try {
                filter = new MessageSelectorFilter(this._messageProcessor, criteria);
            }
            catch (SISelectorSyntaxException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.newBrowseCursor", (String)"1:2084:1.219.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:2091:1.219.1.1", e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"newBrowseCursor", (Object)((Object)e));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:2103:1.219.1.1", e}, null), (Throwable)e);
            }
        }
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            browseCursor = new AIBrowseCursor(this, filter, nextBrowseId, this._alarmManager);
            this._browseCursorTable.put(nextBrowseId, browseCursor);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newBrowseCursor", (Object)browseCursor);
        }
        return browseCursor;
    }

    public void sendRequest(long[] rejectStartTicks, long[] ticks, SelectionCriteria[] criterias, long[] timeout, int priority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequest", (Object)new Object[]{SIMPUtils.longArrayToString(rejectStartTicks), SIMPUtils.longArrayToString(ticks), criterias, SIMPUtils.longArrayToString(timeout), priority});
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlRequest msg = cmf.createNewControlRequest();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                String[] filters = null;
                int[] selectorDomains = null;
                String[] discriminators = null;
                if (criterias != null) {
                    filters = new String[criterias.length];
                    selectorDomains = new int[criterias.length];
                    discriminators = new String[criterias.length];
                    for (int i = 0; i < criterias.length; ++i) {
                        filters[i] = criterias[i].getSelectorString();
                        selectorDomains[i] = criterias[i].getSelectorDomain().toInt();
                        discriminators[i] = criterias[i].getDiscriminator();
                    }
                } else {
                    filters = new String[]{};
                    discriminators = new String[]{};
                    selectorDomains = new int[]{};
                }
                msg.setRejectStartTick(rejectStartTicks);
                msg.setGetTick(ticks);
                msg.setFilter(filters);
                msg.setSelectorDomain(selectorDomains);
                msg.setControlDiscriminator(discriminators);
                msg.setTimeout(timeout);
                MPIO mpio = this._messageProcessor.getMPIO();
                mpio.sendToMe(this._destMEUuid, priority, (AbstractMessage)msg);
            }
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendRequest", (String)"1:2206:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequest");
        }
    }

    public void sendAccept(long[] ticks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAccept", (Object)SIMPUtils.longArrayToString(ticks));
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlAccept msg = cmf.createNewControlAccept();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                msg.setTick(ticks);
                MPIO mpio = this._messageProcessor.getMPIO();
                mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            }
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendAccept", (String)"1:2249:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAccept");
        }
    }

    public void sendReject(long[] startTicks, long[] endTicks, long[] unlockCounts, boolean recovery) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendReject", (Object)new Object[]{SIMPUtils.longArrayToString(startTicks), SIMPUtils.longArrayToString(endTicks), SIMPUtils.longArrayToString(unlockCounts), recovery});
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlReject msg = cmf.createNewControlReject();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                msg.setStartTick(startTicks);
                msg.setEndTick(endTicks);
                msg.setRecovery(recovery);
                msg.setRMEUnlockCount(unlockCounts);
                MPIO mpio = this._messageProcessor.getMPIO();
                mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            }
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendReject", (String)"1:2299:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendReject");
        }
    }

    public void resolve(AIStreamKey tsKey) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolve", (Object)tsKey);
        }
        this._remoteCD.resolve(tsKey);
    }

    public void sendCompleted(long[] startTicks, long[] endTicks) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompleted", (Object)new Object[]{SIMPUtils.longArrayToString(startTicks), SIMPUtils.longArrayToString(endTicks)});
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlCompleted msg = cmf.createNewControlCompleted();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                msg.setStartTick(startTicks);
                msg.setEndTick(endTicks);
                MPIO mpio = this._messageProcessor.getMPIO();
                mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            }
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCompleted", (String)"1:2353:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompleted");
        }
    }

    public void sendAreYouFlushed(SIBUuid12 streamId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushed", (Object)streamId);
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlAreYouFlushed msg = cmf.createNewControlAreYouFlushed();
            this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, streamId);
            this._areYouFlushedId = this.generateUniqueValue();
            msg.setRequestID(this._areYouFlushedId);
            MPIO mpio = this._messageProcessor.getMPIO();
            mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendAreYouFlushed", (String)"1:2396:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushed");
        }
    }

    public long getUniqueLockID(int storageStrategy) throws PersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUniqueLockID");
        }
        long uniqueId = this._messageProcessor.getMessageStore().getUniqueLockID(storageStrategy);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUniqueLockID", (Object)uniqueId);
        }
        return uniqueId;
    }

    public long getTotalSentRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalSentRequests");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalSentRequests", (Object)this._totalSentRequests);
        }
        return this._totalSentRequests;
    }

    public void sendHighestGeneratedTick(long requestId, long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendHighestGeneratedTick", (Object)new Object[]{requestId, tick});
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlHighestGeneratedTick msg = cmf.createNewControlHighestGeneratedTick();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                msg.setRequestID(requestId);
                msg.setTick(tick);
                MPIO mpio = this._messageProcessor.getMPIO();
                mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            }
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendHighestGeneratedTick", (String)"1:2467:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendHighestGeneratedTick");
        }
    }

    public void sendDecision(long tick) {
    }

    public void sendResetRequestAckAck(long dmeVersion) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendResetRequestAckAck", (Object)dmeVersion);
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlResetRequestAckAck msg = cmf.createNewControlResetRequestAckAck();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                msg.setDMEVersion(dmeVersion);
                MPIO mpio = this._messageProcessor.getMPIO();
                mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            }
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendResetRequestAckAck", (String)"1:2515:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendResetRequestAckAck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCreateStream(long createStreamId) throws SIResourceException {
        SIResourceException e;
        String meName;
        MPIO mpio;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCreateStream", (Object)createStreamId);
        }
        if (!(mpio = this._messageProcessor.getMPIO()).isMEReachable(this._destMEUuid)) {
            meName = JsAdminUtils.getMENameByUuidForMessage((String)this._destMEUuid.toString());
            if (meName == null) {
                meName = this._destMEUuid.toString();
            }
            e = new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{this._destName, meName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCreateStream", (Object)((Object)e));
            }
        }
        if (this._gatheringTargetDestUuid != null && !mpio.isCompatibleME(this._destMEUuid, ProtocolVersion.VERSION_7)) {
            meName = JsAdminUtils.getMENameByUuidForMessage((String)this._destMEUuid.toString());
            if (meName == null) {
                meName = this._destMEUuid.toString();
            }
            e = new SIMPConnectionVersionException(nls.getFormattedMessage("GATHERING_ME_VERSION_INCOMPATIBLE_CWSIP0856", new Object[]{this._destName, meName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCreateStream", (Object)((Object)e));
            }
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlCreateStream msg = cmf.createNewControlCreateStream();
            this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, null);
            msg.setRequestID(createStreamId);
            msg.setDurableSubName(null);
            msg.setDurableDiscriminator(null);
            msg.setDurableSelector(null);
            msg.setDurableSelectorDomain(0);
            msg.setSecurityUserid(null);
            msg.setSecurityUseridSentBySystem(false);
            msg.setCloned(false);
            msg.setNoLocal(false);
            mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (this._streamStatus.test(0)) {
                    this._streamStatus.set(3);
                }
            }
        }
        catch (Exception e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCreateStream", (String)"1:2609:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCreateStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendRequestFlush(IndoubtAction indoubtAction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlush", (Object)indoubtAction);
        }
        if (this._inactivityTimeoutAlarm != null) {
            this._inactivityTimeoutAlarm.cancel();
            this._inactivityTimeoutAlarm = null;
        }
        if (this._requestFlushEntry != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
            }
            return;
        }
        if (!this._persistentStreamState.isFlushStarted()) {
            AIProtocolItemStream aIProtocolItemStream = this._persistentStreamState;
            synchronized (aIProtocolItemStream) {
                this._persistentStreamState.setFlushStarted(true);
                PersistentStreamAsyncUpdate psau = new PersistentStreamAsyncUpdate();
                this._streamStateRemoveNeedsToWait = true;
                AIExecuteUpdate xu = new AIExecuteUpdate(psau, this._messageProcessor);
                xu.run();
            }
        }
        try {
            SIResourceException ex = null;
            long id = -1L;
            try {
                id = this.generateUniqueValue();
            }
            catch (SIResourceException e1) {
                ex = e1;
            }
            this._requestFlushEntry = new RequestFlushTimeoutEntry(id);
            this._requestFlushTOM.addTimeoutEntry(this._requestFlushEntry);
            if (!this._messageProcessor.isStarted()) {
                SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this._destName, this._destMEUuid.toString()}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush", (Object)((Object)e));
                }
                throw e;
            }
            if (ex != null) {
                throw ex;
            }
            this.sendRequestFlush(this._requestFlushEntry.requestFlushId, indoubtAction);
            this._requestFlushTOM.updateTimeout(this._messageProcessor.getCustomProperties().get_request_flush_repetition_interval());
            this._requestFlushFailed = false;
        }
        catch (SIResourceException e) {
            this._requestFlushTOM.updateTimeout(this._messageProcessor.getCustomProperties().get_request_flush_slow_repetition_interval());
            this._requestFlushFailed = true;
            this.wakeUpWaiters(true, e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush", (Object)((Object)e));
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
        }
    }

    protected void sendRequestFlush(long requestFlushId, IndoubtAction indoubtAction) throws SIResourceException {
        MPIO mpio;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlush", (Object)new Object[]{requestFlushId, indoubtAction});
        }
        if (!(mpio = this._messageProcessor.getMPIO()).isMEReachable(this._destMEUuid)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush", null);
            }
            throw new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_REQUEST_FLUSH_CWSIP0518", new Object[]{this._destName, this._destMEUuid}, null));
        }
        try {
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
                ControlRequestFlush msg = cmf.createNewControlRequestFlush();
                this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, localAIStream.getStreamId());
                msg.setRequestID(requestFlushId);
                if (indoubtAction == IndoubtAction.INDOUBT_DELETE) {
                    msg.setIndoubtDiscard(true);
                } else if (indoubtAction == IndoubtAction.INDOUBT_LEAVE) {
                    msg.setIndoubtDiscard(false);
                }
                mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendRequestFlush", (String)"1:2795:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlush");
        }
    }

    private void redriveFailedRequestFlush() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"redriveFailedRequestFlush");
        }
        if (this._requestFlushEntry.requestFlushId == -1L) {
            this._requestFlushEntry.requestFlushId = this.generateUniqueValue();
        }
        if (this._aiStream != null) {
            this._aiStream.resendScheduledRejects();
        }
        this.sendRequestFlush(this._requestFlushEntry.requestFlushId, IndoubtAction.INDOUBT_DELETE);
        this._requestFlushTOM.updateTimeout(this._messageProcessor.getCustomProperties().get_request_flush_repetition_interval());
        this._requestFlushFailed = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"redriveFailedRequestFlush");
        }
    }

    protected final void initializeControlMessage(ControlMessage msg, SIBUuid8 remoteMEId, SIBUuid12 gatheringTargetDestUuid, SIBUuid12 streamId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{msg, remoteMEId, streamId});
        }
        msg.setPriority(11);
        msg.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        SIMPUtils.setGuaranteedDeliveryProperties(msg, this._messageProcessor.getMessagingEngineUuid(), remoteMEId, streamId, gatheringTargetDestUuid, this._destUuid, ProtocolType.ANYCASTOUTPUT, GDConfig.PROTOCOL_VERSION);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    public void sendBrowseGet(long browseId, long seqNum, Filter filter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseGet", (Object)new Object[]{browseId, seqNum, filter});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlBrowseGet msg = cmf.createNewControlBrowseGet();
            this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, null);
            msg.setBrowseID(browseId);
            msg.setSequenceNumber(seqNum);
            if (filter != null && filter instanceof MessageSelectorFilter) {
                MessageSelectorFilter msf = (MessageSelectorFilter)filter;
                String selectorString = msf.getSelectorString();
                msg.setFilter(selectorString);
                msg.setSelectorDomain(msf.getDomain().toInt());
                msg.setControlDiscriminator(msf.getDiscriminator());
            } else {
                msg.setFilter("");
                msg.setSelectorDomain(0);
                msg.setControlDiscriminator(null);
            }
            MPIO mpio = this._messageProcessor.getMPIO();
            mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendBrowseGet", (String)"1:2916:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseGet");
        }
    }

    public void sendBrowseStatus(int status, long browseId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseStatus", (Object)new Object[]{status, browseId});
        }
        try {
            ControlMessageFactory cmf = MessageProcessor.getControlMessageFactory();
            ControlBrowseStatus msg = cmf.createNewControlBrowseStatus();
            this.initializeControlMessage((ControlMessage)msg, this._destMEUuid, this._gatheringTargetDestUuid, null);
            msg.setStatus(status);
            msg.setBrowseID(browseId);
            MPIO mpio = this._messageProcessor.getMPIO();
            mpio.sendToMe(this._destMEUuid, 11, (AbstractMessage)msg);
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendBrowseStatus", (String)"1:2957:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseStatus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBrowseCursor(long browseId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBrowseCursor", (Object)new Object[]{browseId});
        }
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            Long bid = browseId;
            AIBrowseCursor browseCursor = (AIBrowseCursor)this._browseCursorTable.get(bid);
            if (browseCursor != null) {
                this._browseCursorTable.remove(bid);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBrowseCursor");
        }
    }

    public long getCompletedRequestCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedRequestCount");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedRequestCount", (Object)this._totalCompletedRequests);
        }
        return this._totalCompletedRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCreateStreamAndWait(long responseTimeout) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCreateStreamAndWait");
        }
        SIResourceException sendException = null;
        this._createStreamEntry = new CreateStreamTimeoutEntry();
        try {
            this.sendCreateStream(this._createStreamEntry.createStreamId);
        }
        catch (SIResourceException e) {
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                this._streamStatus.set(0);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)e));
            }
            throw e;
        }
        this._createStreamTOM.addTimeoutEntry(this._createStreamEntry);
        if (!this._messageProcessor.isStarted()) {
            e = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this._destName, this._destMEUuid.toString()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)e));
            }
            throw e;
        }
        this._createStreamTOM.startTimer();
        sendException = this.waitForResponse(responseTimeout, false);
        if (sendException == null) {
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (this._streamStatus.test(0)) {
                    SIResourceException e = new SIResourceException(nls.getFormattedMessage("CONSUMERCARDINALITY_LIMIT_REACHED_CWSIP0514", new Object[]{this._destName, this._destMEUuid.toString()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)e));
                    }
                    throw e;
                }
                if (!this._streamStatus.test(4)) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3105:1.219.1.1"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.sendCreateStreamAndWait", (String)"1:3112:1.219.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3120:1.219.1.1"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", (Object)((Object)e));
                    }
                    throw e;
                }
            }
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            this._streamStatus.set(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait", null);
        }
        throw sendException;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCreateStreamAndWait");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementUnlockCount(long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incrementUnlockCount", (Object)tick);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._streamStatus.test(4)) {
                this._aiStream.incrementUnlockCount(tick);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incrementUnlockCount");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataMessage(MessageItem msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleDataMessage", (Object)msg);
        }
        long arrivalTime = System.currentTimeMillis();
        JsMessage jsMsg = msg.getMessage();
        AIMessageItem mainMsgItem = new AIMessageItem(jsMsg);
        mainMsgItem.setCurrentMEArrivalTimestamp(msg.getCurrentMEArrivalTimestamp());
        mainMsgItem.setFromRemoteME(msg.isFromRemoteME());
        mainMsgItem.setFromRemoteBus(msg.isFromRemoteBus());
        AIRequestedTick rt = null;
        long tick = jsMsg.getGuaranteedRemoteGetValueTick();
        long prevTick = jsMsg.getGuaranteedRemoteGetPrevTick();
        long startTick = jsMsg.getGuaranteedRemoteGetStartTick();
        SendDispatcher requestToValueDispatcher = new SendDispatcher();
        boolean deliverToRCD = true;
        boolean restoring = false;
        Queue queue = this.msgsToBeDelivered;
        synchronized (queue) {
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (this.okToProcess(jsMsg)) {
                    Reliability rel;
                    if (startTick < tick && tick > 0L) {
                        try {
                            this._aiStream.updateToCompleted(startTick, tick - 1L);
                        }
                        catch (SIErrorException sIErrorException) {
                            // empty catch block
                        }
                    }
                    boolean isExpress = (rel = jsMsg.getReliability()).compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0;
                    int priority = jsMsg.getPriority();
                    boolean canDeliver = true;
                    if (this._deliverInOrder) {
                        canDeliver = isExpress ? this.canDeliverExpressInOrder(tick, priority) : this._aiStream.canDeliverAssuredInOrder(tick, prevTick, priority);
                    }
                    try {
                        rt = this._aiStream.updateRequestToValue(tick, mainMsgItem, canDeliver, requestToValueDispatcher);
                    }
                    catch (SIErrorException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleDataMessage");
                        }
                        return;
                    }
                    if (rt != null) {
                        RemoteDispatchableKey cKey = rt.getRemoteDispatchableKey();
                        AOValue restoreValue = rt.getRestoringAOValue();
                        if (restoreValue != null) {
                            restoring = true;
                            mainMsgItem.setRestoredTargetAOValue(restoreValue);
                        }
                        ++this._totalCompletedRequests;
                        if (canDeliver) {
                            AIStreamKey tsKey = new AIStreamKey(tick, cKey, rt.getOriginalTimeout(), rt.getIssueTime());
                            mainMsgItem.setInfo(this, tsKey);
                            this.msgsToBeDelivered.enqueue(mainMsgItem);
                            if (this._deliverInOrder) {
                                List undeliveredList;
                                if (isExpress) {
                                    this.setHighestDeliveredExpress(priority, tick);
                                } else if (!restoring && (undeliveredList = this._aiStream.findUndeliveredList(tick, jsMsg)) != null) {
                                    int size = undeliveredList.size();
                                    for (int i = 0; i < size; ++i) {
                                        AIValueTick vt = (AIValueTick)undeliveredList.get(i);
                                        AIMessageItem nextMsgItem = vt.getMsg();
                                        tsKey = new AIStreamKey(vt.getTick(), vt.getRemoteDispatchableKey(), vt.getOriginalTimeout(), vt.getIssueTime());
                                        nextMsgItem.setInfo(this, tsKey);
                                        this.msgsToBeDelivered.enqueue(nextMsgItem);
                                    }
                                    this._aiStream.markListDelivered(undeliveredList);
                                }
                            }
                        } else if (isExpress && this._deliverInOrder) {
                            try {
                                this._aiStream.updateToAccepted(tick, null);
                            }
                            catch (SIErrorException sIErrorException) {}
                        }
                    } else {
                        deliverToRCD = false;
                    }
                }
            }
            requestToValueDispatcher.dispatch();
            if (deliverToRCD) {
                ArrayList<AIMessageItem> msgList = null;
                while (!this.msgsToBeDelivered.isEmpty()) {
                    if (msgList == null) {
                        msgList = new ArrayList<AIMessageItem>(this.msgsToBeDelivered.size());
                    }
                    AIMessageItem nextMsgItem = (AIMessageItem)this.msgsToBeDelivered.dequeue();
                    msgList.add(nextMsgItem);
                }
                if (msgList != null) {
                    this._remoteCD.put(msgList, restoring);
                }
            }
        }
        if (rt != null) {
            long waitTime = jsMsg.getGuaranteedRemoteGetWaitTime();
            this.updateRoundtripTime(rt.getIssueTime(), arrivalTime, waitTime);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleDataMessage");
        }
    }

    private boolean isStreamReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStreamReady");
        }
        boolean isStreamReady = false;
        if (!this._streamStatus.test(4)) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3400:1.219.1.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.isStreamReady", (String)"1:3406:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler", "1:3413:1.219.1.1"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isStreamReady", (Object)((Object)e));
            }
            throw e;
        }
        isStreamReady = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStreamReady", (Object)isStreamReady);
        }
        return isStreamReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamBeingFlushed() {
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            return this.isStreamFlushing();
        }
    }

    private boolean isStreamFlushing() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStreamFlushing");
        }
        boolean isStreamFlushing = false;
        if (this._streamStatus.test(2) || this._streamStatus.test(6) || this._streamStatus.test(7) || this._streamStatus.test(8)) {
            isStreamFlushing = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStreamFlushing", (Object)isStreamFlushing);
        }
        return isStreamFlushing;
    }

    private boolean okToProcess(JsMessage jsMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToProcess", (Object)jsMsg);
        }
        boolean okToProcess = false;
        SIBUuid12 incomingStreamId = jsMsg.getGuaranteedStreamUUID();
        if (this._streamStatus.test(4) && this.checkStreamHasNoFlushWork()) {
            SIBUuid12 streamId = this._aiStream.getStreamId();
            if (!incomingStreamId.equals((Object)streamId)) {
                this.sendAreYouFlushed(streamId);
                okToProcess = false;
            } else {
                okToProcess = true;
            }
        } else if (this._streamStatus.test(0)) {
            this.sendAreYouFlushed(incomingStreamId);
            okToProcess = false;
        } else {
            okToProcess = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToProcess", (Object)okToProcess);
        }
        return okToProcess;
    }

    private boolean okToProcess(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToProcess", (Object)cMsg);
        }
        boolean okToProcess = false;
        SIBUuid12 incomingStreamId = cMsg.getGuaranteedStreamUUID();
        if (this._streamStatus.test(4)) {
            SIBUuid12 streamId = this._aiStream.getStreamId();
            if (!incomingStreamId.equals((Object)streamId)) {
                this.sendAreYouFlushed(streamId);
                okToProcess = false;
            } else {
                okToProcess = true;
            }
        } else if (this._streamStatus.test(0)) {
            this.sendAreYouFlushed(incomingStreamId);
            okToProcess = false;
        } else {
            okToProcess = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToProcess", (Object)okToProcess);
        }
        return okToProcess;
    }

    private boolean canDeliverExpressInOrder(long tick, int priority) {
        boolean canDeliver;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"canDeliverExpressInOrder", (Object)new Object[]{tick, priority});
        }
        boolean bl = canDeliver = tick > this._highestDeliveredExpressTicks[priority];
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"canDeliverExpressInOrder", (Object)canDeliver);
        }
        return canDeliver;
    }

    private void setHighestDeliveredExpress(int priority, long tick) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setHighestDeliveredExpress", (Object)new Object[]{priority, tick});
        }
        this._highestDeliveredExpressTicks[priority] = tick;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setHighestDeliveredExpress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBrowseDataMessage(MessageItem msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleBrowseDataMessage", (Object)msg);
        }
        JsMessage jsMsg = msg.getMessage();
        long browseId = jsMsg.getGuaranteedRemoteBrowseID();
        AIBrowseCursor browseCursor = null;
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            browseCursor = (AIBrowseCursor)this._browseCursorTable.get(browseId);
        }
        if (browseCursor != null) {
            browseCursor.put(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleBrowseDataMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCompletedMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCompletedMessage", (Object)cMsg);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(cMsg) || this.isStreamFlushing()) {
                ControlCompleted cm = (ControlCompleted)cMsg;
                long[] startTicks = cm.getStartTick();
                long[] endTicks = cm.getEndTick();
                int len = startTicks.length;
                for (int i = 0; i < len; ++i) {
                    try {
                        this._aiStream.updateToCompleted(startTicks[i], endTicks[i]);
                        continue;
                    }
                    catch (SIResourceException e) {
                        break;
                    }
                    catch (SIErrorException e) {
                        break;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCompletedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDecisionExpectedMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDecisionExpectedMessage", (Object)cMsg);
        }
        SendDispatcher decisionExpectedDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(cMsg) || this.isStreamFlushing()) {
                long[] ticks = ((ControlDecisionExpected)cMsg).getTick();
                int numOfTicks = ticks.length;
                for (int i = 0; i < numOfTicks; ++i) {
                    this._aiStream.processDecisionExpected(ticks[i], decisionExpectedDispatcher);
                }
            }
        }
        decisionExpectedDispatcher.dispatch();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDecisionExpectedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestHighestGeneratedTickMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestHighestGeneratedTickMessage", (Object)cMsg);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(cMsg)) {
                long incomingRequestId = ((ControlRequestHighestGeneratedTick)cMsg).getRequestID();
                long highestGeneratedTick = this._aiStream.getLatestTick();
                this.sendHighestGeneratedTick(incomingRequestId, highestGeneratedTick);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestHighestGeneratedTickMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBrowseEndMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processBrowseEndMessage", (Object)cMsg);
        }
        ControlBrowseEnd bem = (ControlBrowseEnd)cMsg;
        long browseId = bem.getBrowseID();
        AIBrowseCursor browseCursor = null;
        Hashtable hashtable = this._browseCursorTable;
        synchronized (hashtable) {
            browseCursor = (AIBrowseCursor)this._browseCursorTable.get(browseId);
        }
        if (browseCursor != null) {
            int reasonCode = bem.getExceptionCode();
            switch (reasonCode) {
                case 0: {
                    browseCursor.endBrowse();
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    browseCursor.browseFailed(reasonCode);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processBrowseEndMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequestAckMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestAckMessage", (Object)cMsg);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(cMsg)) {
                ControlRequestAck ram = (ControlRequestAck)cMsg;
                long[] ticks = ram.getTick();
                long dmeVersion = ram.getDMEVersion();
                int numOfTicks = ticks.length;
                for (int i = 0; i < numOfTicks; ++i) {
                    this._aiStream.processRequestAck(ticks[i], dmeVersion);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestAckMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResetRequestAckMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processResetRequestAckMessage", (Object)cMsg);
        }
        SendDispatcher resetDispatcher = new SendDispatcher();
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this.okToProcess(cMsg)) {
                long dmeVersion = ((ControlResetRequestAck)cMsg).getDMEVersion();
                this._aiStream.processResetRequestAck(dmeVersion, resetDispatcher);
            }
        }
        resetDispatcher.dispatch();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processResetRequestAckMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFlushedMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processFlushedMessage", (Object)cMsg);
        }
        AnycastInputHandler anycastInputHandler = this;
        synchronized (anycastInputHandler) {
            if (this._requestFlushEntry != null) {
                this._requestFlushTOM.removeTimeoutEntry(this._requestFlushEntry);
                this._requestFlushEntry = null;
                this._requestFlushFailed = false;
            }
        }
        boolean cleanup = false;
        boolean closeConsumers = false;
        boolean redriveDelete = false;
        Object object = this._streamStatus;
        synchronized (object) {
            switch (this._streamStatus.get()) {
                case 2: 
                case 6: 
                case 7: {
                    cleanup = true;
                    redriveDelete = this._needToRedriveDeleteDestination;
                    break;
                }
                case 4: {
                    SIBUuid12 flushedStreamId = ((ControlFlushed)cMsg).getGuaranteedStreamUUID();
                    SIBUuid12 streamId = this._aiStream.getStreamId();
                    if (!flushedStreamId.equals((Object)streamId)) break;
                    this._streamStatus.set(8);
                    this.flushedWillDelete = false;
                    closeConsumers = true;
                    break;
                }
            }
        }
        if (closeConsumers) {
            this._remoteCD.closeAllConsumersForFlush();
        }
        if (cleanup) {
            try {
                this.waitOnForceDeleteMonitor();
                this.delete();
            }
            catch (SIErrorException sIErrorException) {
                // empty catch block
            }
        }
        this.wakeUpWaiters(true, null);
        object = this._flushCallbacks;
        synchronized (object) {
            for (Runnable next : this._flushCallbacks) {
                try {
                    this._messageProcessor.startNewSystemThread(next);
                }
                catch (InterruptedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processFlushedMessage", (String)"1:3938:1.219.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
            this._flushCallbacks.clear();
        }
        if (redriveDelete) {
            this._baseDestinationHandler.getDestinationManager().startAsynchDeletion();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processFlushedMessage");
        }
    }

    private void cleanupStreamState() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupStreamState");
        }
        this.stop();
        AIStream localAIStream = this._aiStream;
        if (localAIStream != null) {
            localAIStream.stop();
            localAIStream.updateAllToCompleted();
        }
        if (this._control != null) {
            this._control.deregisterControlAdapterMBean();
            this._control = null;
        }
        RemovePersistentStream update = new RemovePersistentStream();
        AIExecuteUpdate xu = new AIExecuteUpdate(update, this._messageProcessor);
        xu.run();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupStreamState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processNotFlushedMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)cMsg);
        }
        ControlNotFlushed nfm = (ControlNotFlushed)cMsg;
        long incomingRequestId = nfm.getRequestID();
        if (this._createStreamEntry != null && incomingRequestId == this._createStreamEntry.createStreamId) {
            if (cMsg.getGuaranteedProtocolType() != ProtocolType.DURABLEINPUT) {
                this._createStreamTOM.removeTimeoutEntry(this._createStreamEntry);
            }
            this._createStreamEntry = null;
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (!this._streamStatus.test(3)) {
                    SIErrorException e2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processNotFlushedMessage", "1:4038:1.219.1.1"}, null));
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processNotFlushedMessage", (String)"1:4043:1.219.1.1", (Object[])new Object[]{this, this._streamStatus, cMsg.toVerboseString()});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processNotFlushedMessage", "1:4050:1.219.1.1"});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)((Object)e2));
                    }
                    SIResourceException ex = new SIResourceException((Throwable)e2);
                    this.wakeUpWaiters(false, ex);
                    return;
                }
            }
            SIBUuid12 streamUuid = nfm.getGuaranteedStreamUUID();
            long tick = 0L;
            try {
                tick = this.generateUniqueValue();
            }
            catch (SIResourceException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                AIStreamStatus aIStreamStatus2 = this._streamStatus;
                synchronized (aIStreamStatus2) {
                    if (this._streamStatus.test(3)) {
                        this._streamStatus.set(0);
                    }
                    this.wakeUpWaiters(false, e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)((Object)e));
                }
                return;
            }
            AIStreamStatus e = this._streamStatus;
            synchronized (e) {
                CreatePersistentStream update = new CreatePersistentStream(streamUuid, tick, tick);
                AIExecuteUpdate xu = new AIExecuteUpdate(update, this._messageProcessor);
                xu.run();
                if (this._streamStatus.test(3)) {
                    this._streamStatus.set(4);
                }
            }
            this.wakeUpWaiters(false, null);
        } else if (incomingRequestId == this._areYouFlushedId) {
            AIStreamStatus streamUuid = this._streamStatus;
            synchronized (streamUuid) {
                this._areYouFlushedId = -1L;
            }
            SIBUuid12 notFlushedStreamId = nfm.getGuaranteedStreamUUID();
            boolean createNewStream = true;
            AIStream localAIStream = this._aiStream;
            if (localAIStream != null) {
                SIBUuid12 streamId = localAIStream.getStreamId();
                if (notFlushedStreamId.equals((Object)streamId)) {
                    createNewStream = false;
                } else {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processNotFlushedMessage", "1:4163:1.219.1.1"}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.processNotFlushedMessage", (String)"1:4169:1.219.1.1", (Object[])new Object[]{this, streamId, this._streamStatus, nfm.toVerboseString()});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)((Object)e));
                    }
                    throw e;
                }
            }
            if (createNewStream) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Creating new stream");
                }
                AIStreamStatus aIStreamStatus = this._streamStatus;
                synchronized (aIStreamStatus) {
                    if (this._streamStatus.test(0)) {
                        long tick = 0L;
                        try {
                            tick = this.generateUniqueValue();
                        }
                        catch (SIResourceException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage", (Object)((Object)e));
                            }
                            return;
                        }
                        long[] completedPrefixTicks = nfm.getCompletedPrefixTicks();
                        long completedPrefix = completedPrefixTicks[0];
                        CreatePersistentStream update = new CreatePersistentStream(notFlushedStreamId, tick, completedPrefix);
                        AIExecuteUpdate xu = new AIExecuteUpdate(update, this._messageProcessor);
                        xu.run();
                        this._streamStatus.set(4);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNotFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processCardinalityInfoMessage(ControlMessage cMsg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCardinalityInfoMessage", (Object)cMsg);
        }
        ControlCardinalityInfo cim = (ControlCardinalityInfo)cMsg;
        long requestId = cim.getRequestID();
        int cardinality = cim.getCardinality();
        if (this._createStreamEntry != null && requestId == this._createStreamEntry.createStreamId) {
            this._createStreamTOM.removeTimeoutEntry(this._createStreamEntry);
            this._createStreamEntry = null;
            AIStreamStatus aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                if (this._streamStatus.test(3)) {
                    this._streamStatus.set(0);
                }
            }
            SIResourceException e = null;
            if (cardinality == 0) {
                String meName = JsAdminUtils.getMENameByUuidForMessage((String)this._destMEUuid.toString());
                if (meName == null) {
                    meName = this._destMEUuid.toString();
                }
                e = new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{this._destName, meName}, null));
            }
            this.wakeUpWaiters(false, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCardinalityInfoMessage");
        }
    }

    private void updateRoundtripTime(long issueTime, long arrivalTime, long waitTime) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateRoundtripTime", (Object)new Object[]{issueTime, arrivalTime, waitTime});
        }
        long latestRoundTripTime = arrivalTime - issueTime - waitTime;
        this._currentRoundtripTime = (this._currentRoundtripTime + latestRoundTripTime) / 2L;
        if (this._currentRoundtripTime < this._messageProcessor.getCustomProperties().get_round_trip_time_low_limit()) {
            this._currentRoundtripTime = this._messageProcessor.getCustomProperties().get_round_trip_time_low_limit();
        }
        if (this._currentRoundtripTime > this._messageProcessor.getCustomProperties().get_round_trip_time_high_limit()) {
            this._currentRoundtripTime = this._messageProcessor.getCustomProperties().get_round_trip_time_high_limit();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRoundtripTime", (Object)this._currentRoundtripTime);
        }
    }

    protected long generateUniqueValue() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateUniqueValue");
        }
        long uniqueValue = 0L;
        uniqueValue = this._messageProcessor.nextTick();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateUniqueValue", (Object)uniqueValue);
        }
        return uniqueValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepareForDurableStartup(long createID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepareForDurableStartup", (Object)createID);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            this._streamStatus.set(3);
        }
        this._createStreamEntry = new CreateStreamTimeoutEntry();
        this._createStreamEntry.createStreamId = createID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepareForDurableStartup");
        }
    }

    public final String getDestName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestName");
            SibTr.exit((TraceComponent)tc, (String)"getDestName");
        }
        return this._destName;
    }

    public final SIBUuid12 getDestUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"getDestUuid", (Object)this._destUuid);
        }
        return this._destUuid;
    }

    public final SIBUuid12 getGatheringTargetDestUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getGatheringTargetDestUuid");
            SibTr.exit((TraceComponent)tc, (String)"getGatheringTargetDestUuid", (Object)this._gatheringTargetDestUuid);
        }
        return this._gatheringTargetDestUuid;
    }

    public final SIBUuid8 getLocalisationUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalisationUuid");
            SibTr.exit((TraceComponent)tc, (String)"getLocalisationUuid", (Object)this._destMEUuid);
        }
        return this._destMEUuid;
    }

    public AIStream getAIStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIStream");
            SibTr.exit((TraceComponent)tc, (String)"getAIStream", (Object)new Object[]{this._aiStream});
        }
        return this._aiStream;
    }

    public BaseDestinationHandler getBaseDestinationHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBaseDestinationHandler");
            SibTr.exit((TraceComponent)tc, (String)"getBaseDestinationHandler", (Object)new Object[]{this._baseDestinationHandler});
        }
        return this._baseDestinationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFlushedCallback(Runnable callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addFlushedCallback", (Object)callback);
        }
        ArrayList arrayList = this._flushCallbacks;
        synchronized (arrayList) {
            this._flushCallbacks.add(callback);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addFlushedCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testStreamStatus(int test) {
        boolean result = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"testStreamStatus", (Object)test);
        }
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            result = this._streamStatus.test(test);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"testStreamStatus", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFlushWork(FlushWorkItem flushWorkItem, boolean forceUpdate) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"performFlushWork", (Object)new Object[]{flushWorkItem, forceUpdate});
        }
        boolean performWorkSynchronously = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            ++this._numberOfFlushWorkItemsOnStream;
            if (!forceUpdate && this.streamHasIndoubtTransactions()) {
                if (this._flushWorkQueue == null) {
                    this._flushWorkQueue = new LinkedList();
                }
                this._flushWorkQueue.add(flushWorkItem);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"flush work has queued until all indoubt-transactions are resolved");
                }
            } else {
                performWorkSynchronously = true;
                ++this._inProgressFlushWork;
            }
        }
        if (performWorkSynchronously) {
            try {
                flushWorkItem.performWorkItem();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.performFlushWork", (String)"1:5292:1.219.1.1", (Object)this);
            }
            aIStreamStatus = this._streamStatus;
            synchronized (aIStreamStatus) {
                --this._numberOfFlushWorkItemsOnStream;
                --this._inProgressFlushWork;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"performFlushWork");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelAllFlushWork() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelAllFlushWork");
        }
        boolean cancelAllowed = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._inProgressFlushWork == 0) {
                cancelAllowed = true;
                this._numberOfFlushWorkItemsOnStream = 0;
                if (this._flushWorkQueue != null) {
                    this._flushWorkQueue.clear();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelAllFlushWork", (Object)cancelAllowed);
        }
        return cancelAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainFlushWorkQueue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"drainFlushWorkQueue");
        }
        LinkedList localList = null;
        int workCount = 0;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            localList = this._flushWorkQueue;
            workCount = localList.size();
            this._inProgressFlushWork += workCount;
            this._flushWorkQueue = null;
        }
        for (FlushWorkItem flushWorkItem : localList) {
            try {
                flushWorkItem.performWorkItem();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.drainFlushWorkQueue", (String)"1:5386:1.219.1.1", (Object)this);
            }
        }
        AIStreamStatus aIStreamStatus2 = this._streamStatus;
        synchronized (aIStreamStatus2) {
            this._numberOfFlushWorkItemsOnStream -= workCount;
            this._inProgressFlushWork -= workCount;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"drainFlushWorkQueue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean streamHasIndoubtTransactions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"streamHasIndoubtTransactions");
        }
        boolean hasIndoubtTrans = false;
        AIStreamStatus aIStreamStatus = this._streamStatus;
        synchronized (aIStreamStatus) {
            if (this._aiStream != null && this._aiStream.countAllMessagesOnStream() > 0L) {
                hasIndoubtTrans = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"streamHasIndoubtTransactions", (Object)hasIndoubtTrans);
        }
        return hasIndoubtTrans;
    }

    public AIProtocolItemStream getAIProtocolStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAIProtocolStream");
            SibTr.exit((TraceComponent)tc, (String)"getAIProtocolStream", (Object)((Object)this._persistentStreamState));
        }
        return this._persistentStreamState;
    }

    public MessageProcessor getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    public String toString() {
        String text = super.toString() + "[";
        text = text + "Dest:" + this._destName + "," + this._destMEUuid + "]";
        return text;
    }

    private SIResourceException waitForResponse(long responseTimeout, boolean flush) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitForResponse", (Object)flush);
        }
        boolean notified = false;
        SIResourceException ex = null;
        long startTime = System.currentTimeMillis();
        long waitTime = 10000L;
        if (responseTimeout < 10000L) {
            waitTime = responseTimeout;
        }
        while (!notified) {
            AIHWaiter waiter = new AIHWaiter(flush);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Waiting for " + waiter));
                }
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.waitForResponse", (String)"1:5764:1.219.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Woken from waiting for " + waiter));
            }
            if (!(notified = waiter.isNotified())) {
                if (System.currentTimeMillis() - startTime <= responseTimeout) continue;
                ex = new SIMPNoResponseException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this._destName, this._destMEUuid.toString()}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)ex));
                notified = true;
                continue;
            }
            ex = waiter.getException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitForResponse", ex);
        }
        return ex;
    }

    private synchronized void wakeUpWaiters(boolean flush, SIResourceException ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"wakeUpWaiters", (Object)new Object[]{flush, ex});
        }
        boolean notify = false;
        if (!this._flushWaiters.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("_flushWaiters: " + this._flushWaiters.size()));
            }
            notify = true;
            if (flush || ex != null) {
                for (AIHWaiter waiter : this._flushWaiters) {
                    waiter.setNotified();
                    if (ex == null) continue;
                    waiter.setException(ex);
                }
            }
            this._flushWaiters.clear();
        }
        if (!this._createWaiters.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("_createWaiters: " + this._createWaiters.size()));
            }
            notify = true;
            if (!flush || ex != null) {
                for (AIHWaiter waiter : this._createWaiters) {
                    waiter.setNotified();
                    if (ex == null) continue;
                    waiter.setException(ex);
                }
            }
            this._createWaiters.clear();
        }
        if (notify) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Notifying all waiters");
            }
            this.notifyAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"wakeUpWaiters");
        }
    }

    public void clearOrderedTran() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearOrderedTran");
        }
        if (this._aiStream != null) {
            this._aiStream.getAIProtocolItemStream().clearOrderedTran();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearOrderedTran");
        }
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }

    class RequestFlushTimeoutEntry
    extends AbstractBatchedTimeoutEntry {
        public long requestFlushId;

        public RequestFlushTimeoutEntry(long requestFlushId) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"RequestFlushTimeoutEntry", (Object)requestFlushId);
            }
            this.requestFlushId = requestFlushId;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"RequestFlushTimeoutEntry", (Object)this);
            }
        }

        @Override
        public void cancel() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"cancel");
            }
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{AnycastInputHandler.this._destName, AnycastInputHandler.this._destMEUuid}, null));
            AnycastInputHandler.this.wakeUpWaiters(true, e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"cancel");
            }
        }
    }

    class CreateStreamTimeoutEntry
    extends AbstractBatchedTimeoutEntry {
        public long createStreamId;

        public CreateStreamTimeoutEntry() throws SIResourceException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CreateStreamTimeoutEntry");
            }
            this.createStreamId = AnycastInputHandler.this.generateUniqueValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CreateStreamTimeoutEntry", (Object)this);
            }
        }

        @Override
        public void cancel() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"cancel");
            }
            SIResourceException e = new SIResourceException(nls.getFormattedMessage("ANYCAST_CANNOT_CREATE_STREAM_CWSIP0517", new Object[]{AnycastInputHandler.this._destName, AnycastInputHandler.this._destMEUuid}, null));
            AnycastInputHandler.this.wakeUpWaiters(false, e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"cancel");
            }
        }
    }

    static class LockingBoolean {
        private boolean myBooleanValue;

        public LockingBoolean(boolean value) {
            this.myBooleanValue = value;
        }

        public boolean booleanValue() {
            return this.myBooleanValue;
        }

        public void setBooleanValue(boolean value) {
            this.myBooleanValue = value;
        }
    }

    public class AIStreamStatus {
        public static final int STREAM_NON_EXISTENT = 0;
        public static final int STREAM_FLUSHING = 2;
        public static final int STREAM_CREATING = 3;
        public static final int STREAM_READY = 4;
        public static final int STREAM_INACT_FLUSH = 6;
        public static final int STREAM_RESTART_FLUSH = 7;
        public static final int STREAM_FORCE_DELETING = 8;
        private int status;

        public AIStreamStatus(int status) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIStreamStatus", (Object)status);
            }
            this.status = status;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AIStreamStatus", (Object)this);
            }
        }

        public boolean test(int testStatus) {
            boolean test;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"test", (Object)new Object[]{testStatus, this.status});
            }
            boolean bl = test = this.status == testStatus;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"test", (Object)test);
            }
            return test;
        }

        public int get() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"get");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"get", (Object)this.status);
            }
            return this.status;
        }

        public void set(int newStatus) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"set", (Object)newStatus);
            }
            this.status = newStatus;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"set");
            }
        }

        public String toString() {
            return String.valueOf(this.status);
        }
    }

    class CreateStreamTimeoutProcessor
    implements BatchedTimeoutProcessor {
        CreateStreamTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTimedoutEntries(List entries) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{"CreateStreamTimedoutProcessor", AnycastInputHandler.this, entries});
            }
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                CreateStreamTimeoutEntry cste = (CreateStreamTimeoutEntry)entries.get(i);
                try {
                    AnycastInputHandler.this.sendCreateStream(cste.createStreamId);
                    continue;
                }
                catch (SIResourceException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"processTimedoutEntries", (Object)((Object)e));
                    }
                    AnycastInputHandler anycastInputHandler = AnycastInputHandler.this;
                    synchronized (anycastInputHandler) {
                        AnycastInputHandler.this._createStreamTOM.removeTimeoutEntry(AnycastInputHandler.this._createStreamEntry);
                        AnycastInputHandler.this._createStreamEntry = null;
                        AIStreamStatus aIStreamStatus = AnycastInputHandler.this._streamStatus;
                        synchronized (aIStreamStatus) {
                            if (AnycastInputHandler.this._streamStatus.test(3)) {
                                AnycastInputHandler.this._streamStatus.set(0);
                            }
                        }
                        AnycastInputHandler.this.wakeUpWaiters(false, e);
                        continue;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
            }
        }
    }

    class RequestFlushTimeoutProcessor
    implements BatchedTimeoutProcessor {
        RequestFlushTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processTimedoutEntries(List entries) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)new Object[]{"RequestFlushTimeoutProcessor", AnycastInputHandler.this, entries});
            }
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                AnycastInputHandler anycastInputHandler = AnycastInputHandler.this;
                synchronized (anycastInputHandler) {
                    RequestFlushTimeoutEntry rfte = (RequestFlushTimeoutEntry)entries.get(i);
                    try {
                        if (rfte.requestFlushId == -1L) {
                            rfte.requestFlushId = AnycastInputHandler.this.generateUniqueValue();
                        }
                        AnycastInputHandler.this.sendRequestFlush(rfte.requestFlushId, IndoubtAction.INDOUBT_DELETE);
                        AnycastInputHandler.this._requestFlushTOM.updateTimeout(AnycastInputHandler.this._messageProcessor.getCustomProperties().get_request_flush_repetition_interval());
                        AnycastInputHandler.this._requestFlushFailed = false;
                    }
                    catch (SIResourceException e) {
                        AnycastInputHandler.this._requestFlushTOM.updateTimeout(AnycastInputHandler.this._messageProcessor.getCustomProperties().get_request_flush_slow_repetition_interval());
                        AnycastInputHandler.this._requestFlushFailed = true;
                        AnycastInputHandler.this.wakeUpWaiters(true, e);
                    }
                    continue;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
            }
        }
    }

    public class ReachabilityChangeListener
    implements MPDestinationChangeListener {
        private RemoteConsumerDispatcher rcd = null;

        public void initRCD(RemoteConsumerDispatcher rcd) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"initRCD", (Object)new Object[]{this, rcd});
            }
            this.rcd = rcd;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initRCD");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destinationLocationChange(SIBUuid12 destId, Set additions, Set deletions, Capability capability) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"destinationLocationChange", (Object)new Object[]{this, destId, additions, deletions, capability});
            }
            if (this.rcd != null && AnycastInputHandler.this._destUuid.equals((Object)destId)) {
                for (SIBUuid8 meUuid : additions) {
                    if (!AnycastInputHandler.this._destMEUuid.equals((Object)meUuid)) continue;
                    AnycastInputHandler.this._messageProcessor.getMPIO().forceConnect(meUuid);
                    AIStreamStatus aIStreamStatus = AnycastInputHandler.this._streamStatus;
                    synchronized (aIStreamStatus) {
                        if (AnycastInputHandler.this._requestFlushEntry != null && AnycastInputHandler.this._requestFlushFailed) {
                            try {
                                AnycastInputHandler.this.redriveFailedRequestFlush();
                            }
                            catch (SIResourceException sIResourceException) {
                                // empty catch block
                            }
                        }
                    }
                    if (capability != Capability.GET) continue;
                    this.rcd.reachabilityChange(true);
                }
                for (SIBUuid8 meUuid : deletions) {
                    if (!AnycastInputHandler.this._destMEUuid.equals((Object)meUuid) || capability != Capability.GET) continue;
                    this.rcd.reachabilityChange(false);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"destinationLocationChange");
            }
        }
    }

    public class InactivityTimeoutListener
    implements AlarmListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{thandle, this});
            }
            SendDispatcher rejectedDispatcher = new SendDispatcher();
            boolean sendRequestFlush = false;
            boolean dispatch = false;
            AnycastInputHandler anycastInputHandler = AnycastInputHandler.this;
            synchronized (anycastInputHandler) {
                AIStreamStatus aIStreamStatus = AnycastInputHandler.this._streamStatus;
                synchronized (aIStreamStatus) {
                    if (!AnycastInputHandler.this._inactivityAlarmCancelled) {
                        boolean streamOkToProcessFlush;
                        boolean bl = streamOkToProcessFlush = !AnycastInputHandler.this.streamHasIndoubtTransactions() && AnycastInputHandler.this.checkStreamHasNoFlushWork();
                        if (AnycastInputHandler.this._streamStatus.test(4)) {
                            try {
                                if (streamOkToProcessFlush) {
                                    AnycastInputHandler.this._aiStream.updateAllToRejected(rejectedDispatcher);
                                    AnycastInputHandler.this._streamStatus.set(6);
                                    sendRequestFlush = true;
                                    dispatch = true;
                                }
                            }
                            catch (SIErrorException sIErrorException) {
                                // empty catch block
                            }
                        }
                        if (!streamOkToProcessFlush) {
                            AnycastInputHandler.this._inactivityTimeoutAlarm = AnycastInputHandler.this._alarmManager.create(AnycastInputHandler.this._messageProcessor.getCustomProperties().get_sender_inactivity_timeout(), this);
                        }
                    }
                }
                if (dispatch) {
                    rejectedDispatcher.dispatch();
                }
                if (sendRequestFlush) {
                    AnycastInputHandler.this.sendRequestFlush(IndoubtAction.INDOUBT_DELETE);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    public class SendDispatcher {
        private static final int SEND_REQUEST = 1;
        private static final int SEND_ACCEPT = 2;
        private static final int SEND_REJECT = 4;
        private static final int SEND_COMPLETED = 8;
        private static final int SEND_RESET_REQUEST_ACK_ACK = 16;
        private static final int SEND_RECOVERED_REJECT = 32;
        private boolean needToSend = false;
        private int typeToSend = 0;
        private ArrayList<Long> acceptTicks = null;
        private ArrayList<Long> requestTicks = null;
        private ArrayList<Long> requestRejectStartTicks = null;
        private ArrayList<SelectionCriteria[]> criterias = null;
        private ArrayList<Long> timeouts = null;
        private ArrayList<Long> completedStartTicks = null;
        private ArrayList<Long> completedEndTicks = null;
        private ArrayList<Long> rejectStartTicks = null;
        private ArrayList<Long> rejectEndTicks = null;
        private ArrayList<Long> rejectUnlockCounts = null;
        private ArrayList<Long> rejectRecoveredStartTicks = null;
        private ArrayList<Long> rejectRecoveredEndTicks = null;
        private long dmeVersion = -1L;

        public void sendRequest(Long rejectStartTick, Long tick, SelectionCriteria[] criteria, Long timeout) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendRequest", (Object)new Object[]{rejectStartTick, tick, criteria, timeout});
            }
            if (this.requestTicks == null) {
                this.requestTicks = new ArrayList();
                this.requestRejectStartTicks = new ArrayList();
                this.criterias = new ArrayList();
                this.timeouts = new ArrayList();
            }
            this.requestRejectStartTicks.add(rejectStartTick);
            this.requestTicks.add(tick);
            this.criterias.add(criteria);
            this.timeouts.add(timeout);
            this.needToSend = true;
            this.typeToSend |= 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendRequest", (Object)this);
            }
        }

        public void sendAccept(Long tick) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendAccept", (Object)tick);
            }
            if (this.acceptTicks == null) {
                this.acceptTicks = new ArrayList();
            }
            this.acceptTicks.add(tick);
            this.needToSend = true;
            this.typeToSend |= 2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendAccept", (Object)this);
            }
        }

        public void sendReject(Long startTick, Long endTick, Long unlockCount, boolean recovery) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendReject", (Object)new Object[]{startTick, endTick, recovery});
            }
            if (!recovery) {
                if (this.rejectStartTicks == null) {
                    this.rejectStartTicks = new ArrayList();
                    this.rejectEndTicks = new ArrayList();
                    this.rejectUnlockCounts = new ArrayList();
                }
                this.rejectStartTicks.add(startTick);
                this.rejectEndTicks.add(endTick);
                this.rejectUnlockCounts.add(unlockCount);
                this.typeToSend |= 4;
            } else {
                if (this.rejectRecoveredStartTicks == null) {
                    this.rejectRecoveredStartTicks = new ArrayList();
                    this.rejectRecoveredEndTicks = new ArrayList();
                }
                this.rejectRecoveredStartTicks.add(startTick);
                this.rejectRecoveredEndTicks.add(endTick);
                this.typeToSend |= 0x20;
            }
            this.needToSend = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendReject", (Object)this);
            }
        }

        public void sendCompleted(Long startTick, Long endTick) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendCompleted", (Object)new Object[]{startTick, endTick});
            }
            if (this.completedStartTicks == null) {
                this.completedStartTicks = new ArrayList();
                this.completedEndTicks = new ArrayList();
            }
            this.completedStartTicks.add(startTick);
            this.completedEndTicks.add(endTick);
            this.needToSend = true;
            this.typeToSend |= 8;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendCompleted", (Object)this);
            }
        }

        public void sendResetRequestAckAck(long dmeVersion) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendResetRequestAckAck", (Object)dmeVersion);
            }
            this.dmeVersion = dmeVersion;
            this.needToSend = true;
            this.typeToSend |= 0x10;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendResetRequestAckAck", (Object)this);
            }
        }

        public void dispatch() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"dispatch");
            }
            if (this.needToSend) {
                if ((this.typeToSend & 1) > 0) {
                    for (int i = 0; i < this.requestTicks.size(); ++i) {
                        AnycastInputHandler.this.sendRequest(this.toArray(this.requestRejectStartTicks.get(i)), this.toArray(this.requestTicks.get(i)), this.criterias.get(i), this.toArray(this.timeouts.get(i)), 11);
                    }
                }
                if ((this.typeToSend & 2) > 0) {
                    AnycastInputHandler.this.sendAccept(this.toArray(this.acceptTicks));
                }
                if ((this.typeToSend & 4) > 0) {
                    AnycastInputHandler.this.sendReject(this.toArray(this.rejectStartTicks), this.toArray(this.rejectEndTicks), this.toArray(this.rejectUnlockCounts), false);
                }
                if ((this.typeToSend & 0x20) > 0) {
                    AnycastInputHandler.this.sendReject(this.toArray(this.rejectRecoveredStartTicks), this.toArray(this.rejectRecoveredEndTicks), new long[this.rejectRecoveredStartTicks.size()], true);
                }
                if ((this.typeToSend & 8) > 0) {
                    AnycastInputHandler.this.sendCompleted(this.toArray(this.completedStartTicks), this.toArray(this.completedEndTicks));
                }
                if ((this.typeToSend & 0x10) > 0) {
                    AnycastInputHandler.this.sendResetRequestAckAck(this.dmeVersion);
                }
            }
            this.reset();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"dispatch", (Object)this);
            }
        }

        private long[] toArray(ArrayList<Long> items) {
            long[] array = new long[items.size()];
            int i = 0;
            Iterator<Long> it = items.iterator();
            while (it.hasNext()) {
                array[i++] = it.next().intValue();
            }
            return array;
        }

        private long[] toArray(Long item) {
            long[] array = new long[]{item};
            return array;
        }

        private void reset() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"reset");
            }
            this.needToSend = false;
            this.typeToSend = 0;
            this.requestTicks = null;
            this.requestRejectStartTicks = null;
            this.criterias = null;
            this.timeouts = null;
            this.rejectStartTicks = null;
            this.rejectEndTicks = null;
            this.rejectUnlockCounts = null;
            this.rejectRecoveredStartTicks = null;
            this.rejectRecoveredEndTicks = null;
            this.completedEndTicks = null;
            this.completedStartTicks = null;
            this.dmeVersion = -1L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reset", (Object)this);
            }
        }
    }

    class PersistentStreamAsyncUpdate
    extends SyncUpdateWithRetry {
        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)new Object[]{this, t});
            }
            Transaction msTran = AnycastInputHandler.this._messageProcessor.resolveAndEnlistMsgStoreTransaction(t);
            AnycastInputHandler.this._persistentStreamState.requestUpdate(msTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed", (Object)this);
            }
            if (AnycastInputHandler.this._streamStateRemoveNeedsToWait) {
                AIProtocolItemStream aIProtocolItemStream = AnycastInputHandler.this._persistentStreamState;
                synchronized (aIProtocolItemStream) {
                    AnycastInputHandler.this._streamStateRemoveNeedsToWait = false;
                    ((Object)((Object)AnycastInputHandler.this._persistentStreamState)).notify();
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class RemovePersistentStream
    extends SyncUpdateWithRetry {
        RemovePersistentStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)t);
            }
            AnycastInputHandler.this._aiStream.removeCompletedPrefix(t, AnycastInputHandler.this._messageProcessor.getMessageStore().getUniqueLockID(1));
            AIProtocolItemStream aIProtocolItemStream = AnycastInputHandler.this._persistentStreamState;
            synchronized (aIProtocolItemStream) {
                if (AnycastInputHandler.this._streamStateRemoveNeedsToWait) {
                    ((Object)((Object)AnycastInputHandler.this._persistentStreamState)).wait();
                }
                long lockID = AnycastInputHandler.this._messageProcessor.getMessageStore().getUniqueLockID(1);
                AnycastInputHandler.this._persistentStreamState.lockItemIfAvailable(lockID);
                Transaction msTran = AnycastInputHandler.this._messageProcessor.resolveAndEnlistMsgStoreTransaction(t);
                AnycastInputHandler.this._persistentStreamState.remove(msTran, lockID);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            AIStreamStatus aIStreamStatus = AnycastInputHandler.this._streamStatus;
            synchronized (aIStreamStatus) {
                AnycastInputHandler.this._aiStream = null;
                AnycastInputHandler.this._persistentStreamState = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class CreatePersistentStream
    extends SyncUpdateWithRetry {
        private SIBUuid12 streamId;
        private AIProtocolItemStream itemStream;
        private long latestTick;
        private AICompletedPrefixItem completedPrefixItem;

        CreatePersistentStream(SIBUuid12 streamId, long latestTick, long completedPrefix) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CreatePersistentStream", (Object)new Object[]{streamId, latestTick, completedPrefix});
            }
            this.streamId = streamId;
            this.latestTick = latestTick;
            this.completedPrefixItem = new AICompletedPrefixItem(completedPrefix);
            this.itemStream = new AIProtocolItemStream(streamId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CreatePersistentStream", (Object)this);
            }
        }

        @Override
        public void execute(TransactionCommon t) throws Throwable {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)t);
            }
            Transaction msTran = AnycastInputHandler.this._messageProcessor.resolveAndEnlistMsgStoreTransaction(t);
            AnycastInputHandler.this._containerItemStream.addItemStream((ItemStream)this.itemStream, msTran);
            this.itemStream.addItem(this.completedPrefixItem, msTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        @Override
        public void committed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            try {
                AnycastInputHandler.this._aiStream = new AIStream(this.streamId, this.itemStream, AnycastInputHandler.this, AnycastInputHandler.this._msUpdateThread, this.latestTick, this.completedPrefixItem, false, AnycastInputHandler.this._messageProcessor);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.CreatePersistentStream.committed", (String)"1:4735:1.219.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
            }
            AnycastInputHandler.this._persistentStreamState = this.itemStream;
            AnycastInputHandler.this.start();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    public static interface FlushWorkItem {
        public void performWorkItem();
    }

    public class AIHWaiter {
        boolean _notified = false;
        SIResourceException _failureEx = null;

        public AIHWaiter(boolean flush) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AIHWaiter", (Object)flush);
            }
            if (flush) {
                AnycastInputHandler.this._flushWaiters.add(this);
            } else {
                AnycastInputHandler.this._createWaiters.add(this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"AIHWaiter", (Object)new Object[]{AnycastInputHandler.this._flushWaiters, AnycastInputHandler.this._createWaiters});
            }
        }

        public void setNotified() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setNotified");
                SibTr.exit((TraceComponent)tc, (String)"setNotified");
            }
            this._notified = true;
        }

        public boolean isNotified() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"isNotified");
                SibTr.exit((TraceComponent)tc, (String)"isNotified", (Object)this._notified);
            }
            return this._notified;
        }

        public void setException(SIResourceException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"setException", (Object)((Object)ex));
                SibTr.exit((TraceComponent)tc, (String)"setException");
            }
            this._failureEx = ex;
        }

        public SIResourceException getException() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"getException");
                SibTr.exit((TraceComponent)tc, (String)"getException", (Object)((Object)this._failureEx));
            }
            return this._failureEx;
        }
    }

    abstract class SyncUpdateWithRetry
    extends AsyncUpdate {
        private int repetitionCount;

        public SyncUpdateWithRetry() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"SyncUpdateWithRetry");
            }
            this.repetitionCount = 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"SyncUpdateWithRetry", (Object)this);
            }
        }

        @Override
        public void rolledback(Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)e);
            }
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.SyncUpdateWithRetry.rolledback", (String)"1:4624:1.219.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Throwable)e);
            ++this.repetitionCount;
            if (this.repetitionCount > 4) {
                Exception e2 = new Exception(nls.getFormattedMessage("MSGSTORE_STOP_RETRY_CWSIP0515", new Object[]{AnycastInputHandler.this._destName, 4}, null));
                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.AnycastInputHandler.SyncUpdateWithRetry.rolledback", (String)"1:4645:1.219.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e2);
            } else {
                AIExecuteUpdate xu = new AIExecuteUpdate(this, AnycastInputHandler.this._messageProcessor);
                xu.run();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }
}

