/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.selector.impl.OrdinalPosition;
import com.ibm.ws.sib.matchspace.tools.PositionAssigner;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceComponent;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;
import java.util.HashMap;
import java.util.Map;

public final class PositionAssignerImpl
implements PositionAssigner {
    private static final Class cclass = PositionAssignerImpl.class;
    private static Trace tc = TraceUtils.getTrace(PositionAssignerImpl.class, (String)"SIBMatchSpace");
    private Map levels = new HashMap();

    @Override
    public void assign(Identifier id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.entry(cclass, "assign", (Object)("identifier: " + id));
        }
        String key = null;
        switch (id.getType()) {
            case -5: {
                key = "S:" + id.getFullName();
                break;
            }
            case -6: {
                key = "B:" + id.getFullName();
                break;
            }
            case -8: {
                key = "C:" + id.getFullName();
                break;
            }
            case 3: {
                key = "T:" + id.getFullName();
                break;
            }
            case -7: 
            case 0: {
                key = "U:" + id.getFullName();
                break;
            }
            default: {
                key = "N:" + id.getFullName();
            }
        }
        Integer level = new Integer(id.getStep());
        LevelEntry positions = (LevelEntry)this.levels.get(level);
        if (positions == null) {
            positions = new LevelEntry();
            this.levels.put(level, positions);
        }
        int levelPos = 0;
        if (key != null) {
            levelPos = positions.getPosition(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            tc.debug((Object)this, cclass, "assign", (Object)("level: " + level + ", levelPos: " + Integer.valueOf(levelPos) + ", for key: " + key));
        }
        OrdinalPosition ordPos = new OrdinalPosition(level, levelPos);
        id.setOrdinalPosition((Object)ordPos);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            tc.exit((Object)this, cclass, "assign");
        }
    }

    private class LevelEntry {
        private int nextPosition = 0;
        private Map positions = new HashMap();

        LevelEntry() {
        }

        public int getPosition(Object key) {
            Integer op = (Integer)this.positions.get(key);
            if (op == null) {
                op = new Integer(this.nextPosition++);
                this.positions.put(key, op);
            }
            return op;
        }
    }
}

