/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.osgi.framework.Version;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class GatewayConfigurationImpl
implements GatewayConfiguration {
    private static final TraceComponent tc = Tr.register(GatewayConfigurationImpl.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private Iterable<String> bundleRequirements;
    private Iterable<String> packageImports;
    private Iterable<String> dynamicPackageImports;
    private boolean delegateToSystem = true;
    private volatile EnumSet<ApiType> apiTypeVisibility;
    private volatile boolean spiVisibility;
    private String appName;
    private Version appVersion;
    static final long serialVersionUID = 2530010006499965936L;

    @Override
    public GatewayConfiguration setRequireBundle(List<String> bundleRequirements) {
        this.bundleRequirements = bundleRequirements;
        return this;
    }

    @Override
    public GatewayConfiguration setRequireBundle(String ... bundleRequirements) {
        return this.setRequireBundle(Arrays.asList(bundleRequirements));
    }

    @Override
    public GatewayConfiguration setImportPackage(List<String> packageImports) {
        this.packageImports = packageImports;
        return this;
    }

    @Override
    public GatewayConfiguration setImportPackage(String ... packageImports) {
        return this.setImportPackage(Arrays.asList(packageImports));
    }

    @Override
    public GatewayConfiguration setDynamicImportPackage(List<String> packageImports) {
        this.dynamicPackageImports = packageImports;
        return this;
    }

    @Override
    public GatewayConfiguration setDynamicImportPackage(String ... packageImports) {
        return this.setDynamicImportPackage(Arrays.asList(packageImports));
    }

    @Override
    public GatewayConfiguration setApplicationName(String name) {
        this.appName = name;
        return this;
    }

    @Override
    public GatewayConfiguration setApplicationVersion(Version version) {
        this.appVersion = version;
        return this;
    }

    @Override
    public Iterable<String> getRequireBundle() {
        return this.bundleRequirements;
    }

    @Override
    public Iterable<String> getImportPackage() {
        return this.packageImports;
    }

    @Override
    public Iterable<String> getDynamicImportPackage() {
        return this.dynamicPackageImports;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public Version getApplicationVersion() {
        return this.appVersion;
    }

    @Override
    public GatewayConfiguration setDelegateToSystem(boolean delegateToSystem) {
        this.delegateToSystem = delegateToSystem;
        return this;
    }

    @Override
    public boolean getDelegateToSystem() {
        return this.delegateToSystem;
    }

    @Override
    public EnumSet<ApiType> getApiTypeVisibility() {
        return this.apiTypeVisibility == null ? null : this.apiTypeVisibility.clone();
    }

    @Override
    public GatewayConfiguration setApiTypeVisibility(ApiType ... types) {
        EnumSet<ApiType> set = EnumSet.noneOf(ApiType.class);
        for (ApiType t : types) {
            if (t == null) continue;
            set.add(t);
        }
        this.apiTypeVisibility = set;
        return this;
    }

    @Override
    public GatewayConfiguration setApiTypeVisibility(Iterable<ApiType> types) {
        EnumSet<ApiType> set = EnumSet.noneOf(ApiType.class);
        if (types != null) {
            for (ApiType t : types) {
                if (t == null) continue;
                set.add(t);
            }
        }
        this.apiTypeVisibility = set;
        return this;
    }

    public boolean getSpiVisibility() {
        return this.spiVisibility;
    }

    public GatewayConfiguration setSpiVisibility(boolean spiVisibility) {
        this.spiVisibility = spiVisibility;
        return this;
    }
}

