/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.core;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.CertMappingKeyManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.ssl.KeyManagerExtendedInfo;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public final class WSX509KeyManager
extends X509ExtendedKeyManager
implements X509KeyManager {
    private static final TraceComponent tc = Tr.register(WSX509KeyManager.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private SSLConfig config = null;
    private KeyStore ks = null;
    private KeyManager[] kmList = null;
    private X509KeyManager km = null;
    private X509KeyManager customKM = null;
    private CertMappingKeyManager certMappingKeyManager = null;
    private String clientAlias = null;
    private String serverAlias = null;
    private WSKeyStore wsks = null;
    private String keyStoreName = null;

    public WSX509KeyManager(KeyStore keystore, char[] passPhrase, KeyManagerFactory kmf, SSLConfig sslConfig, X509KeyManager customKeyManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSX509KeyManager", (Object[])new Object[0]);
        }
        this.ks = keystore;
        this.kmList = kmf.getKeyManagers();
        this.certMappingKeyManager = new CertMappingKeyManager();
        if (this.kmList != null) {
            this.km = (X509KeyManager)this.kmList[0];
        }
        this.config = sslConfig;
        this.customKM = customKeyManager;
        this.keyStoreName = this.config.getProperty("com.ibm.ssl.keyStoreName");
        if (this.keyStoreName != null) {
            this.wsks = KeyStoreManager.getInstance().getKeyStore(this.keyStoreName);
        }
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setSSLConfig(this.config);
            KeyManager[] mgrs = kmf.getKeyManagers();
            X509KeyManager defaultX509keyManager = null;
            if (mgrs != null && mgrs[0] != null) {
                defaultX509keyManager = (X509KeyManager)mgrs[0];
            }
            if (defaultX509keyManager != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setDefaultX509KeyManager(defaultX509keyManager);
            }
            if (keystore != null) {
                ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStore(keystore);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSX509KeyManager");
        }
    }

    public void setClientAlias(String alias) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClientAlias", (Object[])new Object[]{alias});
        }
        if (!this.ks.containsAlias(alias)) {
            String keyFileName = this.config.getProperty("com.ibm.ssl.keyStore");
            String tokenLibraryFile = this.config.getProperty("com.ibm.ssl.tokenLibraryFile");
            String location = keyFileName != null ? keyFileName : tokenLibraryFile;
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.client.alias.not.found.CWPKI0023E", new Object[]{alias, location}, "Client alias " + alias + " is invalid or not found in keystore.");
            Tr.error((TraceComponent)tc, (String)"ssl.client.alias.not.found.CWPKI0023E", (Object[])new Object[]{alias, location});
            throw new IllegalArgumentException(message);
        }
        this.clientAlias = alias;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStoreClientAlias(alias);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setClientAlias");
        }
    }

    public void setServerAlias(String alias) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setServerAlias", (Object[])new Object[]{alias});
        }
        if (!this.ks.containsAlias(alias)) {
            String keyFileName = this.config.getProperty("com.ibm.ssl.keyStore");
            String tokenLibraryFile = this.config.getProperty("com.ibm.ssl.tokenLibraryFile");
            String location = keyFileName != null ? keyFileName : tokenLibraryFile;
            String message = TraceNLSHelper.getInstance().getFormattedMessage("ssl.server.alias.not.found.CWPKI0024E", new Object[]{alias, location}, "Server alias " + alias + " is invalid or not found in keystore.");
            Tr.error((TraceComponent)tc, (String)"ssl.server.alias.not.found.CWPKI0024E", (Object[])new Object[]{alias, location});
            throw new IllegalArgumentException(message);
        }
        this.serverAlias = alias;
        if (this.customKM != null && this.customKM instanceof KeyManagerExtendedInfo) {
            ((KeyManagerExtendedInfo)((Object)this.customKM)).setKeyStoreServerAlias(alias);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setServerAlias");
        }
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseClientAlias", (Object[])new Object[]{keyType, issuers, socket});
        }
        String alias = null;
        try {
            String type;
            if (this.customKM != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("chooseClientAlias -> " + this.customKM.getClass().getName()));
                }
                return this.customKM.chooseClientAlias(keyType, issuers, socket);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"chooseClientAlias");
            }
            String[] stringArray = keyType;
            int n = stringArray.length;
            for (int i = 0; i < n && (alias = this.chooseClientAlias(type = stringArray[i], issuers)) == null; ++i) {
            }
            return alias;
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught exception in chooseClientAlias.", (Object[])new Object[]{t});
            }
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"chooseClientAlias", (Object)this);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseServerAlias", (Object[])new Object[]{keyType, issuers, socket});
        }
        try {
            if (this.customKM != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("chooseServerAlias -> " + this.customKM.getClass().getName()));
                }
                return this.customKM.chooseServerAlias(keyType, issuers, socket);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"chooseServerAlias");
            }
            return this.chooseServerAlias(keyType, issuers);
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught exception in chooseServerAlias.", (Object[])new Object[]{t});
            }
            FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"chooseServerAlias", (Object)this);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public String chooseClientAlias(String keyType, Principal[] issuers) {
        Map<String, Object> connectionInfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseClientAlias", (Object[])new Object[]{keyType, issuers});
        }
        if ((connectionInfo = JSSEHelper.getInstance().getOutboundConnectionInfo()) != null && "IIOP".equals(connectionInfo.get("com.ibm.ssl.endPointName")) && !SSLConfigManager.getInstance().isClientAuthenticationEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"chooseClientAlias: null");
            }
            return null;
        }
        if (this.clientAlias != null && !this.clientAlias.equals("")) {
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            boolean isPKIX = algorithm.equalsIgnoreCase("PKIX");
            String[] list = this.km.getClientAliases(keyType, issuers);
            if (list != null) {
                boolean found = false;
                for (int i = 0; i < list.length && !found; ++i) {
                    if (isPKIX && this.resolvePKIXAlias(this.clientAlias, list[i])) {
                        this.clientAlias = list[i];
                        found = true;
                        continue;
                    }
                    if (!this.clientAlias.equalsIgnoreCase(list[i])) continue;
                    found = true;
                }
                if (found) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"chooseClientAlias", (Object)new Object[]{this.clientAlias});
                    }
                    if (this.ks.getType() != null && (this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS") || this.ks.getType().equals("JCEHYBRIDRACFKS"))) {
                        return this.clientAlias;
                    }
                    return this.clientAlias.toLowerCase();
                }
            }
            if (isPKIX) {
                if (list == null || list.length == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"chooseClientAlias (no aliases available)", null);
                    }
                    return null;
                }
                String prefixedClientAlias = this.clientAlias;
                String prefix = this.getPrefix(list[0]);
                if (prefix != null && !this.clientAlias.startsWith(prefix)) {
                    prefixedClientAlias = prefix + this.clientAlias;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Applied prefix to client alias", (Object[])new Object[]{"Original: " + this.clientAlias, "Prefixed: " + prefixedClientAlias});
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"chooseClientAlias (default)", (Object)new Object[]{prefixedClientAlias});
                }
                return prefixedClientAlias;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"chooseClientAlias (default)", (Object)new Object[]{this.clientAlias});
            }
            return this.clientAlias;
        }
        String[] keyArray = new String[]{keyType};
        String alias = this.km.chooseClientAlias(keyArray, issuers, null);
        if (!(this.ks.getType() == null || this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS") || this.ks.getType().equals("JCEHYBRIDRACFKS") || alias == null)) {
            alias = alias.toLowerCase();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chooseClientAlias (from JSSE)", (Object)new Object[]{alias});
        }
        return alias;
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseEngineServerAlias", (Object[])new Object[]{keyType, issuers, engine});
        }
        String rc = null;
        if (null != this.customKM && this.customKM instanceof X509ExtendedKeyManager) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("chooseEngineServerAlias, using customKM -> " + this.customKM.getClass().getName()), (Object[])new Object[0]);
            }
            rc = ((X509ExtendedKeyManager)this.customKM).chooseEngineServerAlias(keyType, issuers, engine);
        } else {
            rc = this.chooseServerAlias(keyType, issuers);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("chooseEngineServerAlias: " + rc));
        }
        return rc;
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseEngineClientAlias", (Object[])new Object[]{keyType, issuers, engine});
        }
        String alias = null;
        if (null != this.customKM && this.customKM instanceof X509ExtendedKeyManager) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("chooseEngineClientAlias, using customKM -> " + this.customKM.getClass().getName()), (Object[])new Object[0]);
            }
            alias = ((X509ExtendedKeyManager)this.customKM).chooseEngineClientAlias(keyType, issuers, engine);
        } else {
            String type;
            String[] stringArray = keyType;
            int n = stringArray.length;
            for (int i = 0; i < n && (alias = this.chooseClientAlias(type = stringArray[i], issuers)) == null; ++i) {
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chooseEngineClientAlias");
        }
        return alias;
    }

    public String chooseServerAlias(String keyType, Principal[] issuers) {
        String algorithm;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chooseServerAlias", (Object[])new Object[]{keyType, issuers});
        }
        boolean isPKIX = (algorithm = KeyManagerFactory.getDefaultAlgorithm()).equalsIgnoreCase("PKIX");
        Map<String, Object> connectionInfo = JSSEHelper.getInstance().getInboundConnectionInfo();
        String certMappingFile = this.certMappingKeyManager.getProperty("com.ibm.ssl.cert.mapping.file");
        String mappedAlias = null;
        Boolean webContainerInbound = null;
        if (connectionInfo != null) {
            webContainerInbound = (Boolean)connectionInfo.get("com.ibm.ssl.isWebContainerInbound");
        }
        if (webContainerInbound != null && webContainerInbound.booleanValue() && certMappingFile != null) {
            mappedAlias = this.certMappingKeyManager.chooseServerAlias(keyType, issuers, null);
        }
        if (mappedAlias == null) {
            if (this.serverAlias != null && !this.serverAlias.equals("")) {
                String[] list = this.km.getServerAliases(keyType, issuers);
                if (list != null) {
                    boolean found = false;
                    for (int i = 0; i < list.length && !found; ++i) {
                        if (isPKIX && this.resolvePKIXAlias(this.serverAlias, list[i])) {
                            this.serverAlias = list[i];
                            found = true;
                            continue;
                        }
                        if (!this.serverAlias.equalsIgnoreCase(list[i])) continue;
                        found = true;
                    }
                    if (found) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"chooseServerAlias", (Object)new Object[]{this.serverAlias});
                        }
                        if (this.ks.getType() != null && (this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS") || this.ks.getType().equals("JCEHYBRIDRACFKS"))) {
                            return this.serverAlias;
                        }
                        return this.serverAlias.toLowerCase();
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"chooseServerAlias (default)", (Object)new Object[]{this.serverAlias});
                }
                return this.serverAlias;
            }
            String alias = this.km.chooseServerAlias(keyType, issuers, null);
            if (!(this.ks.getType() == null || this.ks.getType().equals("JCERACFKS") || this.ks.getType().equals("JCECCARACFKS") || this.ks.getType().equals("JCEHYBRIDRACFKS") || alias == null)) {
                alias = alias.toLowerCase();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"chooseServerAlias (from JSSE)", (Object)new Object[]{alias});
            }
            return alias;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chooseServerAlias", (Object)new Object[]{mappedAlias});
        }
        return mappedAlias;
    }

    private boolean resolvePKIXAlias(String alias, String keyManagerAlias) {
        Pattern r;
        Matcher m;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"resolvePKIXAlias", (Object[])new Object[]{"KeyManager Factory algorithm is PKIX"});
        }
        if (keyManagerAlias.toLowerCase().contains(alias.toLowerCase()) && (m = (r = Pattern.compile("\\d+\\.\\d+\\." + alias + "$", 2)).matcher(keyManagerAlias)).find()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resolvePKIXAlias", (Object[])new Object[]{"Should use alias:" + keyManagerAlias});
            }
            return true;
        }
        return false;
    }

    public String getPrefix(String alias) {
        Pattern pattern = Pattern.compile("^(\\d+\\.\\d+\\.)");
        Matcher matcher = pattern.matcher(alias);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClientAliases", (Object[])new Object[]{keyType, issuers});
        }
        String[] rc = this.getX509KeyManager().getClientAliases(keyType, issuers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClientAliases", (Object)rc);
        }
        return rc;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerAliases", (Object[])new Object[]{keyType, issuers});
        }
        String[] rc = this.getX509KeyManager().getServerAliases(keyType, issuers);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerAliases", (Object)rc);
        }
        return rc;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPrivateKey", (Object[])new Object[]{s});
        }
        PrivateKey rc = this.getX509KeyManager().getPrivateKey(s);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPrivateKey -> " + (null != rc)));
        }
        return rc;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificateChain: " + s), (Object[])new Object[0]);
        }
        X509Certificate[] rc = this.getX509KeyManager().getCertificateChain(s);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCertificateChain", (Object)rc);
        }
        return rc;
    }

    public X509KeyManager getX509KeyManager() {
        if (this.customKM != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getX509KeyManager -> " + this.customKM.getClass().getName()), (Object[])new Object[0]);
            }
            return this.customKM;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getX509KeyManager -> " + this.km.getClass().getName()), (Object[])new Object[0]);
        }
        return this.km;
    }
}

