/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.constants.OpenTelemetryConstants;
import io.openliberty.microprofile.telemetry.internal.common.info.DisabledOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.DisposedOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.EnabledOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryPropertiesReader;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractOpenTelemetryInfoFactory
implements OpenTelemetryInfoFactory {
    private static final TraceComponent tc = Tr.register(AbstractOpenTelemetryInfoFactory.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final String OS_BEAN_J9 = "com.ibm.lang.management.OperatingSystemMXBean";
    private static final String OS_BEAN_HOTSPOT = "com.sun.management.OperatingSystemMXBean";
    static final long serialVersionUID = 3799916918467292332L;

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfoInternal createOpenTelemetryInfo(boolean runtimeEnabled) {
        try {
            HashMap<String, String> telemetryProperties;
            String instanceName;
            String string = instanceName = runtimeEnabled ? "io.openliberty.microprofile.telemetry.runtime" : ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName().getApplication();
            if (AgentDetection.isAgentActive()) {
                return new EnabledOpenTelemetryInfo(true, GlobalOpenTelemetry.get(), instanceName);
            }
            if (runtimeEnabled) {
                telemetryProperties = OpenTelemetryPropertiesReader.getRuntimeInstanceTelemetryProperties();
            } else {
                telemetryProperties = OpenTelemetryPropertiesReader.getTelemetryProperties();
                this.warnIfAppEnabledAndRuntimeExplicitlyDisabled(telemetryProperties, instanceName);
            }
            if (OpenTelemetryPropertiesReader.isEnabled(telemetryProperties)) {
                OpenTelemetry openTelemetry;
                this.addDefaultVersionedProperties(telemetryProperties);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"OTEL instance {0} is being configured with the properties: {1}", (Object[])new Object[]{instanceName, telemetryProperties});
                }
                if ((openTelemetry = AccessController.doPrivileged(() -> {
                    ClassLoader classLoader = runtimeEnabled ? OpenTelemetry.noop().getClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
                    return this.buildOpenTelemetry(telemetryProperties, this.getResourceCustomizer(runtimeEnabled), classLoader);
                })) != null) {
                    this.mergeInJVMMetrics(openTelemetry, runtimeEnabled);
                    return new EnabledOpenTelemetryInfo(true, openTelemetry, instanceName);
                }
            }
            Tr.info((TraceComponent)tc, (String)"CWMOT5100.tracing.is.disabled", (Object[])new Object[]{instanceName});
            return new DisabledOpenTelemetryInfo();
        }
        catch (Exception instanceName) {
            void e;
            FFDCFilter.processException((Throwable)instanceName, (String)"io.openliberty.microprofile.telemetry.internal.common.info.AbstractOpenTelemetryInfoFactory", (String)"97", (Object)this, (Object[])new Object[]{runtimeEnabled});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    protected void warnIfAppEnabledAndRuntimeExplicitlyDisabled(Map<String, String> telemetryAppProperties, String appName) {
        HashMap<String, String> runtimePropreties = OpenTelemetryPropertiesReader.getRuntimeInstanceTelemetryProperties();
        if (OpenTelemetryPropertiesReader.isEnabled(telemetryAppProperties) && OpenTelemetryPropertiesReader.checkExplicitlyDisabled(runtimePropreties)) {
            Tr.warning((TraceComponent)tc, (String)"CWMOT5007.tel.enabled.conflict", (Object[])new Object[]{appName});
        }
    }

    protected abstract void addDefaultVersionedProperties(Map<String, String> var1);

    protected abstract void mergeInJVMMetrics(OpenTelemetry var1, boolean var2);

    protected abstract OpenTelemetry buildOpenTelemetry(Map<String, String> var1, BiFunction<? super Resource, ConfigProperties, ? extends Resource> var2, ClassLoader var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfoInternal createDisposedOpenTelemetryInfo() {
        try {
            String appName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName().getApplication();
            return new DisposedOpenTelemetryInfo(appName);
        }
        catch (Exception appName) {
            void e;
            FFDCFilter.processException((Throwable)appName, (String)"io.openliberty.microprofile.telemetry.internal.common.info.AbstractOpenTelemetryInfoFactory", (String)"130", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfoInternal createDisabledOpenTelemetryInfo() {
        try {
            return new DisabledOpenTelemetryInfo();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.common.info.AbstractOpenTelemetryInfoFactory", (String)"140", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    private BiFunction<? super Resource, ConfigProperties, ? extends Resource> getResourceCustomizer(boolean runtimeEnabled) {
        return (resource, configProperties) -> this.customizeResource((Resource)resource, (ConfigProperties)configProperties, runtimeEnabled).build();
    }

    protected ResourceBuilder customizeResource(Resource resource, ConfigProperties c, boolean runtimeEnabled) {
        ResourceBuilder builder = resource.toBuilder();
        builder.put(OpenTelemetryConstants.KEY_SERVICE_NAME, (Object)this.getServiceName(c, runtimeEnabled));
        return builder;
    }

    private String getServiceName(ConfigProperties c, boolean runtimeEnabled) {
        String serviceName = c.getString("otel.service.name");
        if (serviceName == null) {
            ComponentMetaData cmd;
            if (!runtimeEnabled && (cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData()) != null) {
                serviceName = cmd.getModuleMetaData().getApplicationMetaData().getName();
            }
            if (serviceName == null) {
                serviceName = "unknown_service";
            }
        }
        return serviceName;
    }

    @FFDCIgnore(value={ClassNotFoundException.class})
    protected boolean runningOnJ9OrHotspot() {
        Class<?> j9BeanClass = null;
        Class<?> hotspotBeanClass = null;
        try {
            j9BeanClass = Class.forName(OS_BEAN_J9);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            hotspotBeanClass = Class.forName(OS_BEAN_HOTSPOT);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return j9BeanClass != null || hotspotBeanClass != null;
    }
}

