/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.IOException;

class TransactionAddLogRecord
extends LogRecord {
    private static final Class cclass = TransactionAddLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 3306878921970180238L;
    protected LogicalUnitOfWork logicalUnitOfWork;
    protected int transactionState;
    protected Token token;
    protected byte[] managedObjectBytes;
    ObjectManagerByteArrayOutputStream serializedBytes;

    protected TransactionAddLogRecord(InternalTransaction internalTransaction, Token token, ObjectManagerByteArrayOutputStream serializedBytes) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{this.logicalUnitOfWork, new Integer(this.transactionState), token, serializedBytes});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.transactionState = internalTransaction.getState();
        this.token = token;
        this.serializedBytes = serializedBytes;
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionAddLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
            this.transactionState = dataInputStream.readInt();
            this.token = Token.restore(dataInputStream, objectManagerState);
            long managedObjectLength = dataInputStream.readLong();
            this.managedObjectBytes = new byte[(int)managedObjectLength];
            dataInputStream.read(this.managedObjectBytes);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:115:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getBuffers", new Object[]{byteArrayOutputStream});
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[2];
        byteArrayOutputStream.reset();
        buffers[0] = byteArrayOutputStream;
        buffers[0].writeInt(1);
        this.logicalUnitOfWork.writeSerializedBytes(buffers[0]);
        buffers[0].writeInt(this.transactionState);
        this.token.writeSerializedBytes(buffers[0]);
        buffers[0].writeLong(this.serializedBytes.getCount());
        buffers[1] = this.serializedBytes;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", "objectManagerState=" + objectManagerState + "(ObjectManagerState)");
        }
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug(this, cclass, "logicalUnitOfWork=" + this.logicalUnitOfWork + "(LogicalUnitOfWork) transactionState=" + this.transactionState + "(int) token=" + this.token + "(token) managedObjectBytes.length=" + this.managedObjectBytes.length + "(int)");
        }
        ManagedObject addedManagedObject = ManagedObject.restoreFromSerializedBytes(this.managedObjectBytes, objectManagerState);
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        ManagedObject managedObject = this.token.setManagedObject(addedManagedObject);
        managedObject.state = 1;
        transactionForRecovery.add(managedObject);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    protected static long maximumSerializedSize() {
        return 4L + LogicalUnitOfWork.maximumSerializedSize() + 4L + Token.maximumSerializedSize() + 8L;
    }
}

