/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.json.JsonException;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.JsonTokenizer;
import org.glassfish.json.UnicodeDetectingInputStream;
import org.glassfish.json.api.BufferPool;

public class JsonParserImpl
implements JsonParser {
    public static String MAX_DEPTH = "org.eclipse.parsson.maxDepth";
    private static final int DEFAULT_MAX_DEPTH = 1000;
    private Context currentContext = new NoneContext();
    private JsonParser.Event currentEvent;
    private final Stack stack;
    private final StateIterator stateIterator;
    private final JsonTokenizer tokenizer;

    public JsonParserImpl(Reader reader, BufferPool bufferPool) {
        this.tokenizer = new JsonTokenizer(reader, bufferPool);
        this.stateIterator = new StateIterator();
        this.stack = new Stack(JsonParserImpl.propertyStringToInt(MAX_DEPTH, 1000));
    }

    public JsonParserImpl(InputStream in, BufferPool bufferPool) {
        UnicodeDetectingInputStream uin = new UnicodeDetectingInputStream(in);
        this.tokenizer = new JsonTokenizer(new InputStreamReader((InputStream)uin, uin.getCharset()), bufferPool);
        this.stateIterator = new StateIterator();
        this.stack = new Stack(JsonParserImpl.propertyStringToInt(MAX_DEPTH, 1000));
    }

    public JsonParserImpl(InputStream in, Charset encoding, BufferPool bufferPool) {
        this.tokenizer = new JsonTokenizer(new InputStreamReader(in, encoding), bufferPool);
        this.stateIterator = new StateIterator();
        this.stack = new Stack(JsonParserImpl.propertyStringToInt(MAX_DEPTH, 1000));
    }

    public String getString() {
        if (this.currentEvent == JsonParser.Event.KEY_NAME || this.currentEvent == JsonParser.Event.VALUE_STRING || this.currentEvent == JsonParser.Event.VALUE_NUMBER) {
            return this.tokenizer.getValue();
        }
        throw new IllegalStateException(JsonMessages.PARSER_GETSTRING_ERR(this.currentEvent));
    }

    public boolean isIntegralNumber() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException(JsonMessages.PARSER_ISINTEGRALNUMBER_ERR(this.currentEvent));
        }
        return this.tokenizer.isIntegral();
    }

    public int getInt() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException(JsonMessages.PARSER_GETINT_ERR(this.currentEvent));
        }
        return this.tokenizer.getInt();
    }

    boolean isDefinitelyInt() {
        return this.tokenizer.isDefinitelyInt();
    }

    public long getLong() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException(JsonMessages.PARSER_GETLONG_ERR(this.currentEvent));
        }
        return this.tokenizer.getBigDecimal().longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException(JsonMessages.PARSER_GETBIGDECIMAL_ERR(this.currentEvent));
        }
        return this.tokenizer.getBigDecimal();
    }

    public JsonLocation getLocation() {
        return this.tokenizer.getLocation();
    }

    public JsonLocation getLastCharLocation() {
        return this.tokenizer.getLastCharLocation();
    }

    public boolean hasNext() {
        return this.stateIterator.hasNext();
    }

    public JsonParser.Event next() {
        return this.stateIterator.next();
    }

    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException e) {
            throw new JsonException(JsonMessages.PARSER_TOKENIZER_CLOSE_IO(), (Throwable)e);
        }
    }

    private JsonParsingException parsingException(JsonTokenizer.JsonToken token, String expectedTokens) {
        JsonLocation location = this.getLastCharLocation();
        return new JsonParsingException(JsonMessages.PARSER_INVALID_TOKEN(token, location, expectedTokens), location);
    }

    static int propertyStringToInt(final String propertyName, final int defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(propertyName, defaultValue);
            }
        });
    }

    private final class ArrayContext
    extends Context {
        private boolean firstValue;

        private ArrayContext() {
            this.firstValue = true;
        }

        @Override
        public JsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
            if (token == JsonTokenizer.JsonToken.SQUARECLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return JsonParser.Event.END_ARRAY;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (token != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(token, "[COMMA]");
                }
                token = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (token.isValue()) {
                return token.getEvent();
            }
            if (token == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return JsonParser.Event.START_OBJECT;
            }
            if (token == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return JsonParser.Event.START_ARRAY;
            }
            throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }
    }

    private final class ObjectContext
    extends Context {
        private boolean firstValue;

        private ObjectContext() {
            this.firstValue = true;
        }

        @Override
        public JsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
            if (JsonParserImpl.this.currentEvent == JsonParser.Event.KEY_NAME) {
                if (token != JsonTokenizer.JsonToken.COLON) {
                    throw JsonParserImpl.this.parsingException(token, "[COLON]");
                }
                token = JsonParserImpl.this.tokenizer.nextToken();
                if (token.isValue()) {
                    return token.getEvent();
                }
                if (token == JsonTokenizer.JsonToken.CURLYOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ObjectContext();
                    return JsonParser.Event.START_OBJECT;
                }
                if (token == JsonTokenizer.JsonToken.SQUAREOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ArrayContext();
                    return JsonParser.Event.START_ARRAY;
                }
                throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
            }
            if (token == JsonTokenizer.JsonToken.CURLYCLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return JsonParser.Event.END_OBJECT;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (token != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(token, "[COMMA]");
                }
                token = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (token == JsonTokenizer.JsonToken.STRING) {
                return JsonParser.Event.KEY_NAME;
            }
            throw JsonParserImpl.this.parsingException(token, "[STRING]");
        }
    }

    private final class NoneContext
    extends Context {
        private NoneContext() {
        }

        @Override
        public JsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
            if (token == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return JsonParser.Event.START_OBJECT;
            }
            if (token == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return JsonParser.Event.START_ARRAY;
            }
            throw JsonParserImpl.this.parsingException(token, "[CURLYOPEN, SQUAREOPEN]");
        }
    }

    private abstract class Context {
        Context next;

        private Context() {
        }

        abstract JsonParser.Event getNextEvent();
    }

    private static final class Stack {
        private int size = 0;
        private final int limit;
        private Context head;

        private Stack(int limit) {
            this.limit = limit;
        }

        private void push(Context context) {
            if (++this.size >= this.limit) {
                throw new RuntimeException("Input is too deeply nested " + this.size);
            }
            context.next = this.head;
            this.head = context;
        }

        private Context pop() {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            --this.size;
            Context temp = this.head;
            this.head = this.head.next;
            return temp;
        }

        private boolean isEmpty() {
            return this.head == null;
        }
    }

    private class StateIterator
    implements Iterator<JsonParser.Event> {
        private StateIterator() {
        }

        @Override
        public boolean hasNext() {
            if (JsonParserImpl.this.stack.isEmpty() && (JsonParserImpl.this.currentEvent == JsonParser.Event.END_ARRAY || JsonParserImpl.this.currentEvent == JsonParser.Event.END_OBJECT)) {
                JsonTokenizer.JsonToken token = JsonParserImpl.this.tokenizer.nextToken();
                if (token != JsonTokenizer.JsonToken.EOF) {
                    throw new JsonParsingException(JsonMessages.PARSER_EXPECTED_EOF(token), JsonParserImpl.this.getLastCharLocation());
                }
                return false;
            }
            return true;
        }

        @Override
        public JsonParser.Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return JsonParserImpl.this.currentEvent = JsonParserImpl.this.currentContext.getNextEvent();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

