/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Queue;

public class AsyncUpdateThread {
    private static final TraceComponent tc = SibTr.register(AsyncUpdateThread.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final SIMPTransactionManager tranManager;
    private final MessageProcessor mp;
    private final Queue<AsyncUpdate> enqueuedItems = new LinkedList<AsyncUpdate>();
    private int enqueuedCount = 0;
    private boolean executing = false;
    private boolean executeSinceExpiry = false;
    private CloseCallerInfo closeCallerInfo = null;
    private final int batchThreshold;

    public static AsyncUpdateThread create(MessageProcessor mp, SIMPTransactionManager tm, int batchThreshold, long maxCommitInterval) {
        AsyncUpdateThread asyncUpdateThread = new AsyncUpdateThread(mp, tm, AsyncUpdateThread.consideredThreshold(batchThreshold, maxCommitInterval));
        asyncUpdateThread.startTimer(AsyncUpdateThread.consideredMaxInterval(maxCommitInterval, batchThreshold));
        return asyncUpdateThread;
    }

    private static int consideredThreshold(int threshold, long maxCommitInterval) {
        if (threshold < 1) {
            return 0;
        }
        if (maxCommitInterval > 0L) {
            return threshold;
        }
        SibTr.warning((TraceComponent)tc, (String)"IGNORING_BATCH_SIZE_CWSIP0351", (Object)new Object[]{threshold, maxCommitInterval});
        return 0;
    }

    private static long consideredMaxInterval(long maxCommitInterval, int threshold) {
        if (maxCommitInterval < 1L) {
            return 0L;
        }
        if (threshold > 0) {
            return maxCommitInterval;
        }
        return 0L;
    }

    private AsyncUpdateThread(MessageProcessor mp, SIMPTransactionManager tranManager, int batchThreshold) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AsyncUpdateThread.<init>", (Object)new Object[]{mp, tranManager, batchThreshold});
        }
        this.mp = mp;
        this.tranManager = tranManager;
        this.batchThreshold = batchThreshold;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AsyncUpdateThread.<init>", (Object)this);
        }
    }

    private void startTimer(long maxCommitInterval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"startTimer", (Object)maxCommitInterval);
        }
        try {
            if (0L == maxCommitInterval) {
                return;
            }
            new Timer(maxCommitInterval).schedule();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"startTimer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueWork(AsyncUpdate item) throws ClosedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"enqueueWork", (Object)item);
        }
        if (null == item) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"enqueueWork", (Object)"No work given");
            }
            return;
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            if (this.isClosed()) {
                ClosedException e = new ClosedException(this.closeCallerInfo);
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"enqueueWork", (Object)"already closed - throwing ClosedException");
                }
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Enqueueing update: " + item));
            }
            this.addItem(item);
            if (this.executing) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"enqueueWork", (Object)"AsyncUpdateThread executing");
                }
                return;
            }
            this.considerScheduleExecution(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"enqueueWork");
        }
    }

    private synchronized void addItem(AsyncUpdate item) {
        this.enqueuedItems.add(item);
        ++this.enqueuedCount;
    }

    private synchronized Iterable<AsyncUpdate> drainItems() {
        LinkedList<AsyncUpdate> copy = new LinkedList<AsyncUpdate>();
        AsyncUpdate item = this.enqueuedItems.poll();
        while (null != item) {
            copy.add(item);
            item = this.enqueuedItems.poll();
        }
        this.enqueuedCount = this.enqueuedItems.size();
        return copy;
    }

    private synchronized void considerScheduleExecution(boolean batch) {
        int threshold;
        if (this.isClosed() || this.executing) {
            return;
        }
        if (!batch && this.executeSinceExpiry) {
            this.executeSinceExpiry = false;
            return;
        }
        int n = threshold = batch ? this.batchThreshold : 0;
        if (this.enqueuedCount <= threshold) {
            return;
        }
        try {
            this.executing = true;
            this.mp.startNewSystemThread(new ExecutionThread(threshold));
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".considerScheduleExecution"), (String)"1:211:1.30", (Object)this);
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
            this.close(e);
        }
    }

    private synchronized Iterable<AsyncUpdate> getNextBatch() {
        return this.getNextBatch(this.batchThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Iterable<AsyncUpdate> getNextBatch(int batchSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextBatch", (Object)batchSize);
        }
        int threshold = this.isClosed() ? 0 : batchSize;
        Iterable<AsyncUpdate> nextBatch = null;
        try {
            if (this.enqueuedCount > threshold) {
                nextBatch = this.drainItems();
            } else {
                this.executing = false;
                if (0 < this.batchThreshold) {
                    this.executeSinceExpiry = true;
                }
                this.notifyAll();
            }
            Iterable<AsyncUpdate> iterable = nextBatch;
            return iterable;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextBatch", nextBatch);
            }
        }
    }

    private void processItems(int initialBatchSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processItems", (Object)initialBatchSize);
        }
        Iterable<AsyncUpdate> items = this.getNextBatch(initialBatchSize);
        while (null != items) {
            AsyncUpdateProcessing.processItems(items, this.tranManager);
            items = this.getNextBatch();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processItems");
        }
    }

    private synchronized boolean isClosed() {
        return null != this.closeCallerInfo;
    }

    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void close(Throwable reason) {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"close", (Object)reason);
            }
            AsyncUpdateThread asyncUpdateThread = this;
            // MONITORENTER : asyncUpdateThread
            if (!this.isClosed()) break block11;
            // MONITOREXIT : asyncUpdateThread
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isEntryEnabled()) return;
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            return;
        }
        this.closeCallerInfo = new CloseCallerInfo(reason);
        if (this.executing) {
            // MONITOREXIT : asyncUpdateThread
            if (!TraceComponent.isAnyTracingEnabled()) return;
            if (!tc.isEntryEnabled()) return;
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            return;
        }
        try {
            // MONITOREXIT : asyncUpdateThread
            this.processItems(0);
            return;
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTillAllUpdatesExecuted() throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitTillAllUpdatesExecuted");
        }
        AsyncUpdateThread asyncUpdateThread = this;
        synchronized (asyncUpdateThread) {
            while (!this.enqueuedItems.isEmpty() || this.executing) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitTillAllUpdatesExecuted", (Object)e);
                    }
                    throw e;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitTillAllUpdatesExecuted");
        }
    }

    private static final class CloseCallerInfo
    extends Throwable {
        private static final long serialVersionUID = 1L;
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yy.MM.dd_HH.mm.ss.SSS_Z");

        CloseCallerInfo(Throwable reason) {
            super("Close called at " + DATE_FORMATTER.format(OffsetDateTime.now()), reason);
        }
    }

    private final class Timer
    implements AlarmListener {
        private final long maxCommitInterval;

        Timer(long maxCommitInterval) {
            this.maxCommitInterval = maxCommitInterval;
        }

        public void alarm(Object ignored) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"alarm", (Object)AsyncUpdateThread.this.mp.getMessagingEngineUuid());
            }
            AsyncUpdateThread.this.considerScheduleExecution(false);
            this.schedule();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"alarm");
            }
        }

        void schedule() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"schedule", (Object)this.maxCommitInterval);
            }
            AsyncUpdateThread.this.mp.getAlarmManager().create(this.maxCommitInterval, this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"schedule");
            }
        }
    }

    private class ExecutionThread
    implements Runnable {
        final int initialBatchSize;

        ExecutionThread(int initialBatchSize) {
            this.initialBatchSize = initialBatchSize;
        }

        @Override
        public void run() {
            AsyncUpdateThread.this.processItems(this.initialBatchSize);
        }
    }

    private static final class AsyncUpdateProcessing
    extends Enum<AsyncUpdateProcessing> {
        private static final /* synthetic */ AsyncUpdateProcessing[] $VALUES;

        public static AsyncUpdateProcessing[] values() {
            return (AsyncUpdateProcessing[])$VALUES.clone();
        }

        public static AsyncUpdateProcessing valueOf(String name) {
            return Enum.valueOf(AsyncUpdateProcessing.class, name);
        }

        static void processItems(Iterable<AsyncUpdate> items, SIMPTransactionManager tranMgr) {
            for (AsyncUpdate item : items) {
                try {
                    AsyncUpdateProcessing.processItem(item, tranMgr);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(AsyncUpdateProcessing.class.getName() + ".processItems"), (String)"1:250:1.30", AsyncUpdateProcessing.class, (Object[])new Object[]{items});
                    SibTr.exception((TraceComponent)tc, (Throwable)t);
                }
            }
        }

        private static void processItem(AsyncUpdate item, SIMPTransactionManager tranMgr) throws Throwable {
            LocalTransaction tran = tranMgr.createLocalTransaction(false);
            try {
                AsyncUpdateProcessing.processItemTran(item, tran);
            }
            catch (Throwable t) {
                AsyncUpdateProcessing.notifyRollbackThenThrow(item, t);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Calling committed on " + item));
            }
            item.committed();
        }

        private static void processItemTran(AsyncUpdate item, LocalTransaction tran) throws Throwable {
            try {
                AsyncUpdateProcessing.executeThenCommit(item, tran);
            }
            catch (CommitFailedException cfe) {
                throw cfe.getCause();
            }
            catch (Throwable t) {
                AsyncUpdateProcessing.rollbackThenThrow(tran, t);
            }
        }

        private static void notifyRollbackThenThrow(AsyncUpdate item, Throwable t) throws Throwable {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Calling rolledback on " + item));
                }
                item.rolledback(t);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }

        private static void rollbackThenThrow(LocalTransaction tran, Throwable t) throws Throwable {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Calling rollback on " + tran));
                }
                tran.rollback();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }

        private static void executeThenCommit(AsyncUpdate item, LocalTransaction tran) throws Throwable, CommitFailedException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Calling execute on " + item + " with tran " + tran));
            }
            item.execute((TransactionCommon)tran);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Calling commit on " + tran));
                }
                tran.commit();
            }
            catch (Throwable t) {
                throw new CommitFailedException(t);
            }
        }

        private static /* synthetic */ AsyncUpdateProcessing[] $values() {
            return new AsyncUpdateProcessing[0];
        }

        static {
            $VALUES = AsyncUpdateProcessing.$values();
        }

        private static final class CommitFailedException
        extends Exception {
            private static final long serialVersionUID = 1L;

            CommitFailedException(Throwable t) {
                super("", t);
            }
        }
    }
}

