/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.udp;

import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.openliberty.netty.internal.BootstrapConfiguration;
import io.openliberty.netty.internal.exception.NettyException;
import java.util.ArrayList;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UDPConfigurationImpl
implements BootstrapConfiguration {
    private static final TraceComponent tc = Tr.register(UDPConfigurationImpl.class, (String)"Netty", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private static int DEFAULT_READ_BUFFER_SIZE = 1024000;
    private Map<String, Object> channelProperties = null;
    private ChannelData channelData;
    private String hostname = null;
    private int port = 0;
    private int sendBufferSize = DEFAULT_READ_BUFFER_SIZE;
    private int receiveBufferSize = DEFAULT_READ_BUFFER_SIZE;
    private int channelReceiveBufferSize = 65535;
    private String[] addressExcludeList = null;
    private String[] addressIncludeList = null;
    private int retryCount = 10;
    private int retryInterval = 5000;
    private String externalName = null;
    private boolean isInbound;
    static final long serialVersionUID = -5130110466749569355L;

    public UDPConfigurationImpl(Map<String, Object> options, boolean inbound) throws NettyException {
        this.channelProperties = options;
        this.isInbound = inbound;
        if (this.channelProperties != null) {
            this.setValues(this.channelProperties);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"UDPConfigurationImpl object constructed with null properties", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.outputConfigToTrace();
        }
    }

    public void applyConfiguration(Bootstrap bootstrap) {
        int receiveBufferSize = this.getReceiveBufferSize();
        if (receiveBufferSize >= 4 && receiveBufferSize <= 0x1000000) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting receive buffer to size " + receiveBufferSize), (Object[])new Object[0]);
            }
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)receiveBufferSize);
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(receiveBufferSize));
        }
        if (this.getSendBufferSize() >= 4 && this.getSendBufferSize() <= 0x1000000) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setting send buffer to size " + this.getSendBufferSize()), (Object[])new Object[0]);
            }
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.getSendBufferSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void setValues(Map<String, Object> props) throws NettyException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setValues", (Object[])new Object[0]);
        }
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if (key.equals("id") || key.equals("type") || key.startsWith("service.") || key.startsWith("component.") || key.startsWith("config.") || key.startsWith("objectClass") || key.startsWith("parentPid") || key.startsWith("osgi.ds.")) continue;
                if (this.isInboundChannel()) {
                    if (key.equalsIgnoreCase("hostname")) {
                        this.setHostname((String)value);
                        continue;
                    }
                    if (key.equalsIgnoreCase("port")) {
                        this.setPort(Integer.parseInt((String)value));
                        continue;
                    }
                    if (key.equalsIgnoreCase("endPointName")) continue;
                    if (key.equalsIgnoreCase("sendBufferSizeSocket")) {
                        this.setSendBufferSize(Integer.parseInt((String)value));
                        continue;
                    }
                }
                if (key.equalsIgnoreCase("ExternalName")) {
                    this.setExternalName((String)value);
                    continue;
                }
                if (key.equalsIgnoreCase("sendBufferSizeSocket")) {
                    this.setSendBufferSize(Integer.parseInt((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("receiveBufferSizeSocket")) {
                    this.setReceiveBufferSize(Integer.parseInt((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("receiveBufferSizeChannel")) {
                    this.setChannelReceiveBufferSize(Integer.parseInt((String)value));
                    continue;
                }
                if (key.equalsIgnoreCase("addressExcludeList")) {
                    if (value instanceof String) {
                        this.addressExcludeList = this.convertToArray((String)value);
                        continue;
                    }
                    this.addressExcludeList = (String[])value;
                    continue;
                }
                if (key.equalsIgnoreCase("addressIncludeList")) {
                    if (value instanceof String) {
                        this.addressIncludeList = this.convertToArray((String)value);
                        continue;
                    }
                    this.addressIncludeList = (String[])value;
                    continue;
                }
                if (value instanceof String) {
                    Tr.warning((TraceComponent)tc, (String)"CWUDP0003W", (Object[])new Object[]{this.getExternalName(), key, value});
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"CWUDP0003W", (Object[])new Object[]{this.getExternalName(), key, ""});
            }
            catch (NumberFormatException numberFormatException) {
                void x;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"io.openliberty.netty.internal.udp.UDPConfigurationImpl", (String)"182", (Object)this, (Object[])new Object[]{props});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Incorrect number in config; " + key + "=" + value), (Object[])new Object[0]);
                }
                throw new NettyException(this.getExternalName() + ": Incorrect number in " + key + "=" + value, (Throwable)x);
            }
            catch (Throwable x) {
                void t;
                FFDCFilter.processException((Throwable)x, (String)"io.openliberty.netty.internal.udp.UDPConfigurationImpl", (String)"187", (Object)this, (Object[])new Object[]{props});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unexpected failure handling new config; " + t), (Object[])new Object[0]);
                }
                throw new NettyException(this.getExternalName() + ": Unexpected error in new config", (Throwable)t);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setValues");
        }
    }

    private String[] convertToArray(String allEntries) {
        int start = 0;
        int end = 0;
        String newAddress = null;
        if (allEntries == null) {
            return null;
        }
        int length = allEntries.length();
        ArrayList<String> entryList = new ArrayList<String>();
        while (start != length) {
            end = allEntries.indexOf(",", start);
            if (end > start) {
                newAddress = allEntries.substring(start, end);
                newAddress = newAddress.trim();
                entryList.add(newAddress);
            } else if (end != start) {
                newAddress = allEntries.substring(start);
                newAddress = newAddress.trim();
                entryList.add(newAddress);
            }
            if (end == -1) break;
            start = end + 1;
        }
        if (entryList.isEmpty()) {
            return null;
        }
        return entryList.toArray(new String[entryList.size()]);
    }

    protected void outputConfigToTrace() {
        Tr.debug((TraceComponent)tc, (String)("Config parameters for UDP Channel: " + this.getExternalName()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("Inbound: " + this.isInboundChannel()), (Object[])new Object[0]);
        if (this.isInboundChannel()) {
            Tr.debug((TraceComponent)tc, (String)("hostname: " + this.getHostname()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("port: " + this.getPort()), (Object[])new Object[0]);
        }
        Tr.debug((TraceComponent)tc, (String)("receiveBufferSizeSocket: " + this.getReceiveBufferSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("receiveBufferSizeChannel: " + this.getChannelReceiveBufferSize()), (Object[])new Object[0]);
        Tr.debug((TraceComponent)tc, (String)("sendBufferSizeSocket: " + this.getSendBufferSize()), (Object[])new Object[0]);
    }

    protected void setHostname(String name) {
        if (null != name) {
            this.hostname = name.trim();
        }
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isInboundChannel() {
        return this.isInbound;
    }

    public ChannelData getChannelData() {
        return this.channelData;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public int getChannelReceiveBufferSize() {
        return this.channelReceiveBufferSize;
    }

    public void setChannelReceiveBufferSize(int size) {
        this.channelReceiveBufferSize = size;
        if (size < 0 || size > 65535) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Channel Receive buffer size not within Limits: " + size + " setting to possible maximum value: " + 65535), (Object[])new Object[0]);
            }
            this.channelReceiveBufferSize = 65535;
        }
    }

    protected String[] getAddressExcludeList() {
        return this.addressExcludeList;
    }

    protected String[] getAddressIncludeList() {
        return this.addressIncludeList;
    }

    public void applyConfiguration(ServerBootstrap bootstrap) {
        throw new UnsupportedOperationException("invalid for UDP config");
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int count) {
        this.retryCount = count;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int interval) {
        this.retryInterval = interval;
    }

    public void setExternalName(String value) {
        this.externalName = value;
    }
}

