/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.storage.OidcStorageUtils;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.token.TokenValidationException;
import io.openliberty.security.oidcclientcore.token.TokenValidator;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IdTokenValidator
extends TokenValidator {
    private String nonce;
    private String state;
    private Storage storage;
    private String secret;
    static final long serialVersionUID = 8085989612449519129L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IdTokenValidator(OidcClientConfig clientConfig) {
        super(clientConfig);
    }

    public IdTokenValidator nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public IdTokenValidator state(String state) {
        this.state = state;
        return this;
    }

    public IdTokenValidator storage(Storage storage) {
        this.storage = storage;
        return this;
    }

    public IdTokenValidator secret(@Sensitive String clientSecret) {
        this.secret = clientSecret;
        return this;
    }

    public void validateNonce() throws TokenValidationException {
        String cookieName = OidcStorageUtils.getNonceStorageKey(this.oidcConfig.getClientId(), this.state);
        String cookieValue = OidcStorageUtils.createNonceStorageValue(this.nonce, this.state, this.secret);
        String storedCookieValue = this.storage.get(cookieName);
        this.storage.remove(cookieName);
        if (!cookieValue.equals(storedCookieValue)) {
            throw new TokenValidationException(this.oidcConfig.getClientId(), "The nonce [ " + this.nonce + " ]in the token does not match the nonce that was specified in the request to the OpenID Connect provider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.token.IdTokenValidator", IdTokenValidator.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    }
}

